@extends($activeTemplate.'layouts.users')

@push('style')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/task.css') }}{{$catch}}">
@endpush


@section('content')
    <uni-app class="uni-app--maxwidth">
		@php $dayList = ["1st","2nd","3rd","4th","5th","6th","7th","8th"]; @endphp
        <uni-page data-page="pages/task/task">
            <uni-page-wrapper class="skOkec">
                <uni-page-body>
                    <uni-view data-v-2382aeb6="">
                        <uni-view data-v-58cb4ed7="" data-v-2382aeb6="" class="back-title">
							<span class="linkBTN" data-href="{{ route('user.home') }}" data-v-58cb4ed7=""></span>
							<span data-v-58cb4ed7="" class="title-txt">Users active task</span>
						</uni-view>
                        <uni-view data-v-2382aeb6="" class="content">
                            <uni-view data-v-2382aeb6="" class="color-bg"></uni-view>
                            <uni-view data-v-2382aeb6="">
                                <uni-view data-v-2382aeb6="">
									<div class="form">
										<uni-view data-v-2382aeb6="" class="bg card balance-card linkBTN" data-href="{{ route('user.withdraw.bonus') }}">
											<span style="color: rgb(75, 127, 12);font-size:24px;font-weight:700;">{{ config('settings')->cur_sym}}</span>
											<uni-view data-v-2382aeb6="" class="balance">
												<span data-v-2382aeb6="" class="color2" style="color: rgb(143, 144, 130);">Received bonus</span>
												<span data-v-2382aeb6="" style="color: rgb(75, 127, 12) !important;" class="usersBalance">{{ showAmount($user->bonus_balance)}}</span>
											</uni-view>
											<span data-v-0a75b799="" class="loadIcon" style="" ></span>
											@if( $user->bonus_balance >= 5 )
											<img src="{{ asset($activeTemplateTrue.'img/bank.png') }}" data-v-0a75b799="" style="position:absolute;height: 24px;right: 4px;bottom: 5px;"/>
											@endif
										</uni-view>
									

										<uni-view data-v-2382aeb6="" class="checkin">
											<uni-view data-v-2382aeb6="" class="days">
												@foreach( $days as $key => $day )
													@if( in_array($day, $checkIns) )
													<uni-view data-v-2382aeb6="" class="everyday">
														<uni-view data-v-2382aeb6="" class="signedDay"><span data-v-2382aeb6="">{{ $dayList[$key] }}</span></uni-view>
													</uni-view>
													@else
													<?php if( $key < @$todayKey[0]){ ?>
													<uni-view data-v-2382aeb6="" class="everyday">
														<uni-view data-v-2382aeb6="" class="noCheck"><span data-v-2382aeb6="">{{ $dayList[$key] }}</span></uni-view>
													</uni-view>
													<?php }else{ ?>
													<uni-view data-v-2382aeb6="" class="everyday">
														<uni-view data-v-2382aeb6="" class="day {{ ($day == $todayDate)? 'naToday':'' }}"><span data-v-2382aeb6="">{{ $dayList[$key] }}</span></uni-view>
													</uni-view>
													<?php } ?>
													@endif
												@endforeach
											</uni-view>
											@if( in_array($todayDate, $checkIns))
											<uni-view data-v-2382aeb6="" class="check-in-btn disable-btn"></uni-view>
											@else
											<uni-view data-v-2382aeb6="" data-href="{{ route('user.daily.check') }}" class="check-in-btn UjslL chckInBTN"><span data-v-0a75b799="" class="loadIcon loaderCheck" style="right:9px;" ></span></uni-view>
											@endif
										</uni-view>
									</div>
									
									<div class="form" style="margin-top:30px">
										<uni-view data-v-2382aeb6="" class="task">
											<uni-view data-v-2382aeb6="" class="title" style="width:auto">Limited Time Task</uni-view>
										</uni-view>
									
										@foreach($tasks as $task)
										<uni-view data-v-2382aeb6="" class="task" style="position:relative;">
											<span style="position:absolute;color:#be0300;right: 10px;z-index: 2;font-size: 18px;font-weight: 700;top: 3px;">{{ $task->currency }}</span>
											<uni-view data-v-2382aeb6="" class="task-content">
												<img data-v-2382aeb6="" src="{{ asset($activeTemplateTrue.'img/task1.png') }}" alt="">
												<uni-view data-v-2382aeb6="" class="task-desc">
													<p data-v-2382aeb6="">{{ $task->name }}</p>
													<p data-v-2382aeb6="">Task bonus +{{ showAmount($task->amount,0) }}</p>
												</uni-view>
												<uni-view data-v-2382aeb6="" data-href="{{ route('user.task.page', ['id' => $task->slug]) }}" class="go-task-btn linkBTN" style="width:120px;top:auto;bottom:0px;" >View Tasks <span data-v-0a75b799="" class="loadIcon" style="top:auto;" ></span></uni-view>
											</uni-view>
										</uni-view>
										@endforeach
									</div>
                                </uni-view>
                            </uni-view><br>
                        </uni-view><br>
                    </uni-view><br>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>

	</uni-app>
@endsection

@push('script')
<script type="text/javascript">
	
	$().ready(function () {
		let ubls = Number($('.usersBalance').text());
		let rwd = Number({{config('settings')->reward_login}});

		$(document).on("click", '.chckInBTN', function () {
        
			// Get CSRF token from the meta tag
			var csrfToken = $('meta[name="csrf-token"]').attr('content');
			var $url = $(this).data('href');

			$('.loaderCheck').show();
			$(this).addClass('disable-btn').removeClass('chckInBTN');
			
			// Make AJAX POST request
			$.ajax({
				type: 'POST',
				url: $url,
				contentType: 'application/json',
				headers: {
					"Content-Type": "application/json",
					"Accept": "application/json",
					"X-Requested-With": "XMLHttpRequest",
					"X-CSRF-TOKEN": csrfToken
				},
				data:JSON.stringify({bonus:1}),
				dataType: 'json',
				success: function(res) {
					if (res.status == 200) {
						$('.naToday').removeClass('day').addClass('signedDay');
						var amt = (ubls+rwd);
						$('.usersBalance').text(amt.toFixed(2));
					}
					$('.loaderCheck').hide();
					Toast(res.message);
				},
				error: function(jqXHR, textStatus, res) {
					$(this).removeClass('disable-btn').addClass('chckInBTN');
					$('.loaderCheck').hide();
					var data = JSON.parse(jqXHR.responseText);
					var responseMessage = data.message
					Toast(responseMessage);
				}
			});
		
		})

    });
	
</script>
@endpush