@php $loginContent = getContent(config('settings')->active_template, 'login.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = @$loginContent->data_values->title; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush


@section('content')
    <uni-app class="uni-app--maxwidth">
        <uni-page data-page="pages/login/login">
            <uni-page-wrapper class="authDev">
                <uni-page-body>
                    <uni-view data-v-b3f3cefe="" style="position: relative;">
                        <uni-view data-v-b3f3cefe="" class="content" >
                            <form method="post" action="{{ route('user.login')}}" data-v-b3f3cefe="" class="login-form">
                                <uni-view data-v-b3f3cefe="" class="hero-content">
                                     
									<h4 data-v-b3f3cefe="" class="color-linear1" style="margin-bottom:30px">Log in</h4>
									<img data-v-b3f3cefe="" src="{{getImage(imagePath()['logoIcon']['path'] .'/logo.png')}}{{$catch}}" class="logo">
									
                                    <uni-view data-v-b3f3cefe="" class="card">
										@csrf
                                        <p data-v-b3f3cefe="" class="inView">
											<span data-v-b3f3cefe="" class="icon-shouji1"></span>
                                            <span data-v-b3f3cefe="" class="country-picker" style="margin-left:2px">+234</span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;">
												<input maxlength="140" step="" name="username" style="width:100%" enterkeyhint="done" id="phdk" autocomplete="off" type="" placeholder="Enter your phone number" class="uni-input-input">
                                            </span>
											<div class="report userReport" style="color:white"></div>
                                        </p>
										
                                        <p data-v-b3f3cefe="" class="inView">
											<span data-v-b3f3cefe="" class="icon-password"></span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;display: flex;justify-content: space-between;">
												<input maxlength="140" style="width:88%" placeholder="Enter your password" name="password" id="pwd" step="" enterkeyhint="done" autocomplete="off" type="password" class="uni-input-input">
												<img class="eye" src="/assets/images/eye-fill.png" style="width: 20px;height:auto;"></div>
                                            </span>
											<div class="report passReport" style="color:white"></div>
                                        </p>
										<div style="float: right;" >
											<label for="remember" class="alignCenter" style="margin-bottom: 10px;">
												<span class="text-sm tracking-normal font-semibold">REMEMBER ME</span>
												<input class="text-c-blue-400" id="remember" name="remember" type="checkbox" value="y" />
											</label>
											
											<div class="alignCenter" style="margin-bottom: 10px;">
												<a href="{{ route('user.password.request')}}" class="tracking-normal font-semibold" style="color: #ffc64d;"></a>
											</div>
										</div>
										<p style="height:30px;">&nbsp;</p>

                                        <uni-button data-v-b3f3cefe="" onclick="onSign()" class="hero-button sendBTN" type="primary">Log In</uni-button>
                                        <uni-view data-v-b3f3cefe=""><br><a data-v-b3f3cefe="" style="color: #06ca88;" href="{{ route('user.register')}}">Sign up</a></uni-view>
                                    </uni-view>
									
                                    <uni-view data-v-b3f3cefe="" class="policy">
                                        <p data-v-b3f3cefe="" style="font-size:15px">&nbsp;</p>
                                    </uni-view>

                                    <uni-view data-v-b3f3cefe="" class="fun" style="padding-bottom: 25px;">
										@if( config('settings')->app_link )
                                        <uni-view data-v-b3f3cefe=""><img data-v-b3f3cefe="" mode="aspectFit" src="{{ asset($activeTemplateTrue.'img/googlePlay.png') }}" style="height: 25px;"></uni-view>
										@endif
                                    </uni-view>
                                </uni-view>
                            </form>
							
                            <uni-image data-v-b3f3cefe="" style="display: flex; justify-content: center; position: absolute; top: 15px; right: 15px; width: 40px; height: 40px;">
							</uni-image>
							
							<uni-tabbar class="" style="box-shadow:none;">
								<div class="uni-tabbar" style="backdrop-filter: none;box-shadow:none">
									<div class="uni-tabbar-border" style=""></div>


								</div>
								<div class="uni-placeholder" style="height: 25px;"></div>
							</uni-tabbar>
							
                        </uni-view>
                    </uni-view>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>

    </uni-app>
@endsection


@push('script')
<script>

	function onSign() {
		let flag = true;
		let li = document.querySelectorAll('.inView');
		var phone = $("#phdk").val();
		var password = $("#pwd").val();
		$('.report').html('');

		li.forEach((dom, index) => {
			let input = dom.querySelector('input');

			if (input.name == 'username') {
				let u = document.querySelector('.userReport');
				
				if (!phone) {
					u.innerText = 'Enter mobile number to login.';
					flag = false
				}else if (phone.length != 10) {
					u.innerText = 'Enter a valid mobile number.';
					flag = false
				}
			} else if(input.name == 'password'){
				let p = document.querySelector('.passReport');
				if (!password) {
					p.innerText = 'Enter password of account.'
					flag = false
				}else
				if (password.length < 5) {
					p.innerText = 'Password required six characters.';
					flag = false
				}
			}
		})

		if (!flag) return
			rememberMe();
			$('.sendBTN').attr('disabled', true).attr('loading', 'true');
			$(".login-form").submit();
	}

	$('.eye').click(function() {
		if ($($(this).siblings('input')[0]).attr('type') == 'password') {
			$($(this).siblings('input')[0]).attr('type', 'text')
			$(this).addClass('active')
		} else {
			$($(this).siblings('input')[0]).attr('type', 'password')
			$(this).removeClass('active')
		}
	})

	var username = document.getElementById('phdk'),
		password = document.getElementById('pwd');

	function rememberMe(){
		var isChecked = document.getElementById('remember');
		if( isChecked.checked ){
			localStorage.setItem('username', username.value);
			localStorage.setItem('password', password.value);
			localStorage.setItem('remember', 'true');
		}else{
			localStorage.setItem('username', '');
			localStorage.setItem('password', '');
			localStorage.setItem('remember', '');
		}
	}

	var remember = document.getElementById('remember'),
		localUser = localStorage.getItem('username') || '', //获取user的值并保存
		localPass = localStorage.getItem('password') || '', //获取user的值并保存
		localReme = localStorage.getItem('remember') || ''; //获取password的值并保存
		username.value = localUser; password.value = localPass; if(localReme){remember.checked=true}; 
	
</script>

@endpush
