@php $loginContent = getContent(config('settings')->active_template, 'register.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = @$loginContent->data_values->title; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/register/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush

@section('content')
    <uni-app class="uni-app--maxwidth">
        <uni-page data-page="pages/login/login">
            <uni-page-wrapper class="authDev">
                <uni-page-body>
                    <uni-view data-v-b3f3cefe="" style="position: relative;">
                        <uni-view data-v-b3f3cefe="" class="content">
                            <form method="post" action="" data-v-b3f3cefe="" class="login-form">
                                <uni-view data-v-b3f3cefe="" class="hero-content"><span class="ksjMNN">Register Account<br><br></span>
                                    <uni-view data-v-b3f3cefe="" class="card">
										@csrf
                                        <p data-v-b3f3cefe="" class="inView">
											<span data-v-b3f3cefe="" class="icon-shouji1"></span>
                                            <span data-v-b3f3cefe="" class="country-picker" style="margin-left:2px">+234</span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;">
												<input type="tel" maxlength="10" name="mobile" style="width:100%" id="phdk" placeholder="Enter phone number" autocomplete="off" value="{{ old('mobile') }}" class="uni-input-input">
                                            </span>
											<div class="report mobileReport" style="color:white"></div>
                                        </p>

                                        <!--p data-v-b3f3cefe="" class="inView">
											<span data-v-b3f3cefe="" class="icon-geren"></span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;">
												<input type="" name="username" style="width:100%" id="niKname" placeholder="Please Enter NickName" autocomplete="off" value="{{ old('username') }}" class="uni-input-input">
                                            </span>
											<div class="report userReport" style="color:white"></div>
                                        </p-->

                                        <p data-v-b3f3cefe="" class="inView" style="padding:7px;">
											<span data-v-b3f3cefe="" class="icon-geren"></span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;">
												<input type="" maxlength="4" name="captcha" style="width:100%" id="captcha" placeholder="Verification code" autocomplete="off" value="{{ old('captcha') }}" class="uni-input-input">
                                            </span>
											<img class="verifyImg" id="verifyImg" src="{{ route('security.image') }}" onclick="refreshCaptcha()" style="width: 74%;height:40px;border-radius: 5px;">
											<div class="report captchaReport" style="color:white"></div>
                                        </p>

										
                                        <p data-v-b3f3cefe="" class="inView">
											<span data-v-b3f3cefe="" class="icon-password"></span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;display: flex;justify-content: space-between;">
												<input maxlength="140" style="width:88%" placeholder="Please enter password" name="password" id="pwd" step="" enterkeyhint="done" autocomplete="off" type="password" class="uni-input-input" />
												<img class="eye" src="/assets/images/eye-fill.png" style="width: 20px;height:auto;"></div>
                                            </span>
											<div class="report passReport" style="color:white"></div>
                                        </p>

                                        <p data-v-b3f3cefe="" class="inView">
											<span data-v-b3f3cefe="" class="icon-password"></span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;display: flex;justify-content: space-between;">
												<input maxlength="140" style="width:88%" placeholder="Enter password again" name="password_confirmation" id="passConfirm" step="" enterkeyhint="done" autocomplete="off" type="password" class="uni-input-input" />
												<img class="eye" src="/assets/images/eye-fill.png" style="width: 20px;height:auto;"></div>
                                            </span>
											<div class="report cPassReport" style="color:white"></div>
                                        </p>

										@if(session()->get('reference') != null)
											<input readonly type="hidden" name="referBy" value="{{ (session()->get('reference')) ? session()->get('reference') : old('referBy') }}" class="uni-input-input" />
										@endif
										
                                        <uni-button data-v-b3f3cefe="" class="hero-button sendBTN" onclick="register()" type="primary">Register</uni-button>
                                    </uni-view>
									
                                    <uni-view data-v-b3f3cefe="" class="policy">
                                    </uni-view>
									
                                    <uni-view data-v-b3f3cefe="" class="fun" style="padding-bottom: 25px;">
                                        <uni-view data-v-b3f3cefe="">Already have account? <a data-v-b3f3cefe="" href="{{ route('user.login')}}">Login Now</a></uni-view>
										@if( config('settings')->app_link )
                                        <uni-view data-v-b3f3cefe=""><img data-v-b3f3cefe="" mode="aspectFit" src="{{ asset($activeTemplateTrue.'img/googlePlay.png') }}" style="height: 25px;"></uni-view>
										@endif
                                    </uni-view>
                                </uni-view>
                            </form>
							
                            <uni-image data-v-b3f3cefe="" style="display: flex; justify-content: center; position: absolute; top: 15px; right: 15px; width: 40px; height: 40px;">
                                <div style="background-image: url('{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}'); background-size: 100% 100%; background-repeat: no-repeat;"></div>
                                <img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" draggable="false">
							</uni-image>
							
                            <uni-image data-v-b3f3cefe="" data-href="{{ route('user.login')}}" class="linkBTN" style="display: flex; justify-content: center; position: absolute; top: 15px; left: 15px; width: 30px; height: 30px;">
                                <div style="background-image: url('{{ asset($activeTemplateTrue.'img/back.png') }}'); background-size: 100% 100%; background-repeat: no-repeat;"></div>
                                <img src="{{ asset($activeTemplateTrue.'img/back.png') }}" draggable="false">
							</uni-image>
							
							<uni-tabbar class="" style="box-shadow:none;">
								<div class="uni-tabbar" style="backdrop-filter: none;box-shadow:none">
									<div class="uni-tabbar-border" style=""></div>

								</div>
								<div class="uni-placeholder" style="height: 25px;"></div>
							</uni-tabbar>
                        </uni-view>
                    </uni-view>
					
		
					
                </uni-page-body>
            </uni-page-wrapper>
		</uni-page>
    </uni-app>
@endsection

@push('script')
<script>

	function register() {
		let flag = true;
		let li = document.querySelectorAll('.inView');
		var phone = $("#phdk").val();
		var uName = $("#niKname").val();
		var password = $("#pwd").val();
		var passConfirm = $("#passConfirm").val();
		$('.report').html('');

		li.forEach((dom, index) => {
			let input = dom.querySelector('input');

			if (input.name == 'mobile') {
				let u = document.querySelector('.mobileReport');
				
				if (!phone) {
					u.innerText = 'Enter mobile number to login.';
					flag = false
				}else if (phone.length != 10) {
					u.innerText = 'Enter a valid mobile number.';
					flag = false
				}
			}else if (input.name == 'username') {
				let u = document.querySelector('.userReport');
				
				if (!uName) {
					u.innerText = 'Nick name required.';
					flag = false
				}else if (uName.length < 4) {
					u.innerText = 'Characters must be 4 up';
					flag = false
				}
			} else if(input.name == 'password'){
				let p = document.querySelector('.passReport');
				if (!password) {
					p.innerText = 'Enter password of account.'
					flag = false
				}else
				if (password.length < 5) {
					p.innerText = 'Password required six characters.';
					flag = false
				}
			} else if(input.name == 'password_confirmation'){
				let p = document.querySelector('.cPassReport');
				if (!passConfirm) {
					p.innerText = 'Confirm your password again.'
					flag = false
				}else
				if (passConfirm.length < 5) {
					p.innerText = 'Password required six characters.';
					flag = false
				}else if(password != passConfirm){
					p.innerText = 'Password dose not match.';
					flag = false
				}
			}else if(input.name == 'captcha'){
				let p = document.querySelector('.captchaReport');
				var captcha = input.value;
				if (!captcha) {
					p.innerText = 'Please enter captcha show below.'
					flag = false
				}else
				if (captcha.length < 4) {
					p.innerText = 'Captcha must be 4 characters.';
					flag = false
				}
			}

		});

		setTimeout(()=>{
			$('.report').html('');
		}, 4000);

		if (!flag) return
			$('.sendBTN').attr('disabled', true).attr('loading', 'true');
			$(".login-form").submit();
	}

	$('.eye').click(function() {
		if ($($(this).siblings('input')[0]).attr('type') == 'password') {
			$($(this).siblings('input')[0]).attr('type', 'text')
			$(this).addClass('active')
		} else {
			$($(this).siblings('input')[0]).attr('type', 'password')
			$(this).removeClass('active')
		}
	})
</script>
@endpush