@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/recharge.css') }}{{$catch}}">
	<style>[data-v-43007dac] .uni-input-input{color:#FFF;}</style>
@endpush


@section('content')
    <uni-app class="uni-app--maxwidth">
        <uni-page data-page="pages/record/recharge">
            <uni-page-wrapper class="IoksjnD">
                <uni-page-body>
                    <uni-view data-v-43007dac="">
						<uni-view data-v-58cb4ed7="" data-v-5c2fef75="" class="back-title">
							<span data-href="{{ route('user.profile') }}" class="returnBank"><img src="{{ asset($activeTemplateTrue.'img/back.png') }}" style="margin-left:12px;width:28px;" /></span>
							<span data-v-58cb4ed7="" class="title-txt">Recharge</span>
						</uni-view>

                        <uni-view data-v-43007dac="" class="content">
                            <uni-view data-v-43007dac="" class="color-bg"></uni-view>

							<form id="depositForm" action="{{ route('user.deposit.insert') }}" method="post">

								<div data-v-43007dac="" class="form wrap ikJlape" style="margin-top: 25px;">
									<uni-view data-v-43007dac="" class="info">
										<p data-v-43007dac="">Enter Recharge Amount:</p>
										<uni-input data-v-64270b22="" class="inView" style="height:auto;margin-top:8px; padding: 4px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;justify-content: space-between;">
												<input step="0.0001" id="amtID" style="width:78%;padding:10px 2px;background:transparent;" placeholder="Enter Amount" name="amount" enterkeyhint="done" autocomplete="off" type="text" class="uni-input-input">
											</span>
										</uni-input>

										<uni-view data-v-43007dac="" class="tip" style="display:none">
											<span data-v-43007dac="" id="rateValue" style="display: block;">{{ config('settings')->cur_sym}}0.00 ≈ {{ config('settings')->cur_sym}}0.00</span>
											<span data-v-43007dac="" id="exchangeRate">{{ config('settings')->cur_sym}}1.00 ≈ {{ config('settings')->cur_sym}}1.00</span>
										</uni-view>

									</uni-view>
								</div>

								<input type="hidden" name="currency" class="edit-currency" value="NGN" />
								<input type="hidden" name="method" class="edit-method-code" value="{{ $gatewayCurrency ? $gatewayCurrency[0]->method_code : config('settings')->defualt_deposit }}" />
								<input type="hidden" required name="plan_id" id="planid" />

								<div data-v-43007dac="" class="form wrap ikJlape" style="">
									<div class="centnen" style="">
										<div class="wrap" >
											<div class="box">
												<p>Select payment method:</p>
												<div class="bank">
													@foreach($gatewayCurrency as $data)
													<button type="button" class="paymentOPN @if($data->method_code == '113') clicked @endif" data-method_code="{{$data->method_code}}" data-currency="{{$data->currency}}">{{__($data->name)}} <span class="checkmark">&#10003;</span></button>
													@endforeach
												</div>
											</div>
										</div>
									</div>

									<uni-view data-v-5c2fef75="" class="rules">
										<p data-v-5c2fef75="">Reminder: If you encounter problems recharging, please contact online support customer service.</p>
									</uni-view>

									<uni-button data-v-43007dac="" onclick="onOk()" class="hero-button" type="primary">Recharge</uni-button>
								</div>
                            </form>

                        </uni-view><br>
                    </uni-view><br>
                </uni-page-body><br>
            </uni-page-wrapper>
        </uni-page>

	@include($activeTemplate.'layouts.menu',['activeLink'=>'invest'])
	</uni-app>
@endsection

@push('script')
	<script type="text/javascript">
		var currency = "NGN", symbol = "₦", rate="1", xchange = "1", other = "₮";
        $('#Uni_kqqz .amounts').click(function() {
            $(this).addClass('amount-active').siblings().removeClass('amount-active');
            let value = $(this).data('amount');
            $('#amtID').val(value);
			exchange();
        })

		let minAmt = 500;
		let maxAmt = 1000000;

		$(".paymentOPN").click(function() {
			$(".edit-currency").val($(this).data('currency'));
			$(".edit-method-code").val($(this).data('method_code'));
			$(".paymentOPN").removeClass('clicked');
			$(this).addClass('clicked');
		})

        $('#amtID').keyup(function() {
            $(this)[0].value = $(this)[0].value.replace(/^(0+)|[^\d]+/g, '');
            $('#Uni_kqqz .amounts').removeClass('amount-active');
			exchange();
        })

        $('.tabs').click(function() {
			$(".tabs").removeClass('active');
			$(this).addClass('active');
			var info = $(this).data();
			currency = info.currency, symbol = info.symbol, rate = info.rate, xchange = info.exchange, other = info.other;
			$('.edit-currency').val(currency);
			$('#exchangeRate').html("["+currency+"] "+symbol+"1.00 ≈ " + other + " "+rate+"");
			exchange();
		})

		function exchange(){
			let amount = $('#amtID').val();
			if( !isNaN(amount) ){
				var value = amount*xchange;
				$('#rateValue').html("₦"+amount+".00 ≈ " + symbol + "" + value + " [" + currency + "]");
			}
		}

        function onOk() {
            var money = Number($('#amtID').val());

            if (money < minAmt || money > maxAmt) {
                Toast("Sorry, the deposit amount is not within the range");
                return false;
            }

			loading.showLoading({type: 3,tip: "loading.."});
			$("#depositForm").submit();
        }
    </script>
@endpush
