@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/bank.css') }}{{$catch}}">
@endpush

@section('content')
    <div class="bank-wrap">
        <div class="navbar">
            <span onclick="onJump('{{ route('user.profile')}}')">
					<i></i>
				</span>
            <span></span>
            <span></span>
        </div>

        <div class="tips-box" style="margin-top:35px;">
            <p class="tips">
                Please input the following 3 parts to facilitate your withdrawal.
            </p>
        </div>

        <form action="" method="post" id="bankForm" class="list-wrap">
            <ul class="uls">
                <li>
                    <span>Mobile Money Name</span>
                    <select name="bank_code" id="bank_name" style="width: 100%;font-size: .24rem;color: #333;">
						<option value="">Please payment name</option>
						@foreach($banks as $bank)
							<option class="text-black">{{ $bank['name'] }}</option>
						@endforeach
					</select>
					<input type="hidden" name="bank_name" id="bank_code">
                    <p></p>
                </li>

                <li>
                    <span>Phone/Account Number</span>
                    <input type="text" name="account_number" id="account" class="name" placeholder="Please your number" value="">
                    <p></p>
                    <b class="close"></b>
                </li>

                <li>
                    <span>Associated Name</span>
                    <input type="text" name="account_name" id="account_name" class="account" placeholder="Please enter associated name" value="">
                    <p></p>
                    <b class="close"></b>
                </li>

                <li>
                    <span>Login Password</span>
                    <input type="text" name="password" id="password" class="account" placeholder="Please enter account password" />
                    <p></p>
                    <b class="close"></b>
                </li>

            </ul>

			@csrf
            <div class="btn" id="reg" onclick="submit();" >Submit</div>
        </form>
    </div>
@endsection

@push('script-lib')
<textarea style="display: none;" id="all_banks">{!! $all_banks !!}</textarea>
<script>
    let all_banks = JSON.parse($("#all_banks").val());

    (function ($) {
        "use strict";
		
        function getByValue(value) {
            let arr = all_banks;
            for (var i = 0, iLen = arr.length; i < iLen; i++) {
                if (arr[i].bank_code == value) return arr[i].name;
            }
        }

        $("#bank_name").change(function (e) {
            let code = $("#bank_name").val();
            let t = getByValue(code);
            $("#bank_code").val(t);
        });

    })(jQuery);
	
	function submit() {
		let flag = true;
		let li = document.querySelectorAll('li');
		li.forEach((dom, index) => {
			dom.querySelector('p').innerText = '';
			if (index == 0) {
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				if (!input.value) {
					p.innerText = 'Please select your mobile bank'
					flag = false
				}
			} else if (index == 1) {
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				if (!input.value) {
					p.innerText = 'Please enter mobile number'
					flag = false
				}
			} else if (index == 2) {
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				if (!input.value) {
					p.innerText = 'Account associated name required'
					flag = false
				}
			} else if (index == 3) {
				let input = dom.querySelector('input');
				let p = dom.querySelector('p');
				if (!input.value) {
					p.innerText = 'Please enter account password'
					flag = false
				}
			}
		})

		if (!flag) return
		let text = document.querySelectorAll('li input');
		console.log(text[0].value, text[1].value, text[2].value, text[3].value);

		hsycms.loading('loading.');
		$("#bankForm").submit();
	}
</script>

@endpush
