@extends($activeTemplate.'layouts.users')

@push('style-lib')
    <link href="{{ asset('users/css/invite.css') }}" rel="stylesheet" type="text/css" />
@endpush


@section('content')
<div class="main">
	<div class="subject radius151500PX h5MaxWidth">
		<div class="img"><img src="{{ asset('users/images/invite/01.png') }}" alt /></div>
		<div class="initiateArea">
			<div class="slogan">
				<h3> </h3>
			</div>
		</div>
	</div>
	<div class="inviteRule">
		<div class="recordCard radius151500PX">
			<ul class="display alignCenter alignStretch">
				<li class="award">
					<div class="cardOutline01">
						<p id="award"><em class='currency'>{{ config('settings')->cur_sym }}</em>{{ showAmount($user->referral) }}</p>
						<span>Obtaining Commission</span>
					</div>
				</li>
				<li class="flex1">
					<div class="cardOutline01">
						<p id="registrants">{{ $referral_count }}</p>
						<span>Registrations</span>
					</div>
				</li>
				<li class="flex1">
					<div class="cardOutline01">
						<p id="active">{{$active_ref}}</p>
						<span>Valid Referrals</span>
					</div>
				</li>
			</ul>
		</div>

		<img id="QRCLogo" src="{{ asset('users/images/logo.png') }}" hidden />
		<div class="actionBar display alignCenter alignStretch">
			<div onclick="copyToClipboard()" class="copyBtn clickBtn radius7PX flex4 display alignCenter justifyCenter" id="copylink"
				data-clipboard-text>
				Copy Invite Link
			</div>
			{{--  <div class="getQRcodeBtn clickBtn radius7PX flex3 display alignCenter justifyCenter" id="getQRC"
				onclick="getQRC()">
				QRCode
			</div>  --}}
			<input style="opacity:0;" type="text" value="{{ route('home') }}?code={{ auth()->user()->ref_code }}" id="referralLink">
		</div>

		{{--  <div class="award1 ratioAward">
			<div class="titleBar display alignCenter justifyDetween">
				<div>
					<h3>REWARD 1</h3>
				</div>
			</div>
			<div class=" radius7PX display alignCenter">
				<div class="img"><img src="{{ asset('users/images/invite/02.png') }}" alt></div>
				<div class="hint radius7PX flex1 display alignCenter">
					<p>If your friend upgrades to VIP1 or above, you
						will receive 1000 rewards</p>
				</div>
			</div>
		</div>  --}}
		
		<div class="award2 ratioAward radius7PX">
			<div class="titleBar display alignCenter justifyDetween">
				<div>
					<h3>REWARD</h3>
				</div>
			</div>
			<div class="rewardList">
				<ul class="display alignEnd">
					@foreach($levels as $level)
					<li class="flex1">
						<div class="reward display alignCenter justifyCenter" style="position: absolute; margin-left: 17px;">
							<div id="commissionLevel1">
								<h3 style="color:#fff;">{{$level->percent}}<em style="color:#fff;">%</em></h3>
								<p style="color:#000;font-size: 15px;">LEVEL {{ $level->level }}</p>
							</div>
						</div>
						<img src="{{ asset('users/images/invite/ticket.svg') }}" alt style="display:block;"/>
					</li>
					@endforeach
				</ul>
			</div>
			<div class="hint radius7PX">
				<p id="commissionDis">We offer {{$levels->count()}} generation referral level</p>
			</div>
		</div>
		
		<div class="cashReturn clear radius7PX">
			<div class="myTeam">

				<div class="titleBar display alignCenter justifyDetween">
					<div>
						<h3>MYTEAM</h3>
					</div>
				</div>

				@foreach($levels as $level)
				<div class="one team display alignEnd radius7PX" onclick="showListdetails({{$level->level}},{{$level->percent}})">
					@php $LevelEarn = \App\Models\Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', $level->level); @endphp
					@php $gAmount = $LevelEarn->sum('amount'); @endphp
					<div class="more_Dots"><i class="iconfont icon-menu-dots"></i></div>
					<div class="rankIcon">
						<div><img src="{{ asset('users/images/invite/lv'.$level->level.'.png') }}" alt /></div>
					</div>
					<div class="standings flex1 display alignEnd">
						<div>
							<p id="level1Count">{{$LevelEarn->count()}}</p>
							<span>Quantity</span>
						</div>
						<div>
							<p id="level1Commission"><em class='currency'>{{ config('settings')->cur_sym }}</em>{{ showAmount($gAmount,0) }}</p>
							<span>Commission</span>
						</div>
					</div>
				</div>
				@endforeach

			</div>
		</div>
	</div>

</div>

@endsection

@push('script-lib')
	<script src="{{ asset('users/js/clipboard.min.js') }}" type="text/javascript"></script>
	<script src="{{ asset('users/js/jqueryqr.js') }}" type="text/javascript"></script>
	<script src="{{ asset('users/js/qrcode.js') }}" type="text/javascript"></script>
@endpush


@push('script')
	<script type="text/javascript">
		function copyToClipboard() {
			var referralLink = document.getElementById("referralLink");
			referralLink.select();
			referralLink.setSelectionRange(0, 99999); // For mobile devices
			document.execCommand("copy");
			toast("","Referral link copied to clipboard: " + referralLink.value,'referral',4000, 2);
		}

		var currentPageDate = null;

		var level1Page = 1;
		var level2Page = 1;
		var level3Page = 1;

		// isScrollTo();
		$(document).ready(function() {
			var btns = document.querySelectorAll('#copylink');
			var clipboard = new Clipboard(btns);
			clipboard.on('success', function(e) {
				toast('', 'Copied successfully and ready to paste and share!', 'copy', 2000, 2);
			});
			clipboard.on('error', function(e) {
				toast('', 'Copy failed', 'copy', 2000, 1);
			});
		});

		function showListdetails(lvID, level) {
			const lv_E = {
				'1': "Direct Recommendation " + level + "%",
				'2': "Indirect Recommendation " + level + "%",
				'3': "Indirect Recommendation " + level + "%",
				'4': "Indirect Recommendation " + level + "%",
			};
			const lv_E_txt = lv_E[lvID];

			var listdetailsHTML = "";

			listdetailsHTML += `
			<div class="listdetails">
				<div class="rankAttribute display alignCenter">
					<div class="icon"><img src="{{ asset('users/images/invite/v` + lvID + `.svg') }}" alt="" /></div>
					<div class="explain flex1"><h4>` + lv_E_txt + `</h4></div>
				</div>
				<div class="listItem">
					<ul>
						<li class="radius7PX skeleton display alignCenter justifyDetween" style="padding: 0px;">
							<div class="name">
								<p>user</p>
								<span>create time</span>
							</div>
							<div class="a benefit"><p>status</p> </div>
						</li> 
					</ul>
					<div class="loadMore"></div>
				</div>
			</div> `;


			UPDownBox(listdetailsHTML, "showListdetails", 0);

			level1Page = 1;
			level2Page = 1;
			level3Page = 1;
			commission_level1 = 20;

			switch (lvID) {
				case 1:
					buildLevel1Html();
					break;
				case 2:
					buildLevel2Html();
					break;
				case 3:
					buildLevel3Html();
					break;
				default:
					break;
			}
		}


		function buildLevel1Html() {
			_api.listTeamLevel1(level1Page, (res) => {
				if (res.code === 0) {
					var loadMoreHtml = ''
					var listHtml = ''
					if (res.data.length > 0) {
						$.each(res.data, function(index, item) {
							listHtml += `<li class="radius7PX display alignCenter justifyDetween" style="padding: 0px;">
								<div class="name">
										<p>` + item.account + `</p>
										<span>` + item.create_time + `</span>
									</div>`

							if (item.is_active) {
								listHtml += `<div class="a benefit"><p>Active</p> </div>`;
							} else {
								listHtml += `<div class="na benefit"><p>Not active</p> </div>`;
							}

							listHtml += `</li>  `
						})
						loadMoreHtml += `<p onclick="buildLevel1Html()">See more</p>`
					} else {
						loadMoreHtml = ''
					}
					if (level1Page == 1 && res.data.length < 1) {
						listHtml += `<li class="noData">
									<div class="tipIcon"><img src="images/DefaultGraph/01.png" alt="" /></div>
									<h3>No data</h3>
							</li>`
					}

				} else {
					toast('', res.msg, 'login', 2000, 1);
				}
				$(".listItem>ul>li.skeleton").remove();
				$(".listItem>ul").append(listHtml);
				$(".listdetails .loadMore").html(loadMoreHtml)
				level1Page += 1;
			});
		}

		function buildLevel2Html() {
			_api.listTeamLevel2(level2Page, (res) => {
				var loadMoreHtml = ''
				var listHtml = ''
				if (res.code === 0) {
					if (res.data.length > 0) {
						$.each(res.data, function(index, item) {
							listHtml += `<li class="radius7PX display alignCenter justifyDetween">
								<div class="name">
										<p>` + item.account + `</p>
										<span>` + item.create_time + `</span>
									</div>`

							if (item.is_active) {
								listHtml += `<div class="a benefit"><p>Active</p> </div>`;
							} else {
								listHtml += `<div class="na benefit"><p>Not active</p> </div>`;
							}

							listHtml += `</li>  `
						})
						loadMoreHtml += `<p onclick="buildLevel2Html()">See more</p>`
					} else {
						loadMoreHtml = ''
					}
					if (level2Page == 1 && res.data.length < 1) {
						listHtml += `<li class="noData">
									<div class="tipIcon"><img src="images/DefaultGraph/01.png" alt="" /></div>
									<h3>No data</h3>
								</li>`
					}
				} else {
					toast('', res.msg, 'login', 2000, 1);
				}
				$(".listItem>ul>li.skeleton").remove();
				$(".listItem>ul").append(listHtml)
				$(".listdetails .loadMore").html(loadMoreHtml)
				level2Page += 1;
			});
		}

		function buildLevel3Html() {
			_api.listTeamLevel3(level3Page, (res) => {
				var loadMoreHtml = ''
				var listHtml = ''
				if (res.code === 0) {
					if (res.data.length > 0) {
						$.each(res.data, function(index, item) {
							listHtml += `<li class="radius7PX display alignCenter justifyDetween">
								<div class="name">
										<p>` + item.account + `</p>
										<span>` + item.create_time + `</span>
									</div>`

							if (item.is_active) {
								listHtml += `<div class="a benefit"><p>Active</p> </div>`;
							} else {
								listHtml += `<div class="na benefit"><p>Not active</p> </div>`;
							}

							listHtml += `</li> `
						})
						loadMoreHtml += `<p onclick="buildLevel3Html()">See more</p>`
					} else {
						loadMoreHtml = ''
					}
					if (level3Page == 1 && res.data.length < 1) {
						listHtml += `<li class="noData">
									<div class="tipIcon"><img src="images/DefaultGraph/01.png" alt="" /></div>
									<h3>No data</h3>
								</li>`
					}
				} else {
					toast('', res.msg, 'login', 2000, 1);
				}
				$(".listItem>ul>li.skeleton").remove();
				$(".listItem>ul").append(listHtml);
				$(".listdetails .loadMore").html(loadMoreHtml)
				level3Page += 1;
			});
		}
	</script>
@endpush
