@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/security.css') }}{{$catch}}">
@endpush


@section('content')
    <uni-app class="uni-app--maxwidth">
        <uni-page data-page="pages/setting/change-password">
            <uni-page-wrapper class="chPoswD">
                <uni-page-body>
                    <uni-view data-v-c23c4702="">
                        <uni-view data-v-c23c4702="" class="content">
							<uni-view data-v-58cb4ed7="" data-v-5c2fef75="" class="back-title">
								<span data-href="{{ route('user.profile') }}" class="returnBank"><img src="{{ asset($activeTemplateTrue.'img/back.png') }}" style="margin-left:12px;width:28px;" /></span>
								<span data-v-58cb4ed7="" class="title-txt">Google factor</span>
							</uni-view>

						@if(Auth::user()->ts)

							<h2 class="title" style="font-size:.50rem;margin-top:2.0rem;position: relative;text-align: center;text-align: -webkit-center;">
								<div class="favicon"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt /></div>

								<p data-v-ee9f835e="" style="font-size:18px;color:#FFF;">@Lang('Disable_2FA')</p>
								<p><br/><hr style="opacity:0.2"/><br/></p>
								<p data-v-ee9f835e="" style="font-size:18px;color:#FFF;" class="mb-1"><strong class="text-dark">@Lang('2fa_disable_tips')</strong></p>
							</h2>
							
                            <uni-view data-v-c23c4702="" class="goods-title">
                            </uni-view>

                            <uni-view data-v-c23c4702="">
                                <uni-view data-v-c23c4702="" class="container-item login kJse" style="">
                                    <form action="{{route('user.twofactor.disable')}}" id="disable2faForm" method="post" data-v-7cbc276a="" data-v-c23c4702="" class="form">
										@csrf  
                                        <uni-view data-v-7cbc276a="" class="info">

											<uni-view data-v-43007dac="" class="info" style="margin-top:34px">
												<p data-v-43007dac="">@Lang('enter_2fa')</p>
												<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
													<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;">
														<span data-v-0a75b799="" style="margin-top:7px"><img src="{{ asset($activeTemplateTrue.'img/record.png') }}" style="width:24px" /></span>
														<input id="google2fa-code" required placeholder="Enter 2FA Code" style="width:78%;padding:10px 2px;background:transparent;" name="code" enterkeyhint="done" autocomplete="off" type="text" class="uni-input-input">
													</span>
												</uni-input>
											</uni-view>
											
											<div class="centnen" style="margin-top:7.5vmin">
												<div class="wrap">
													<div class="tips-box">
														<h2>@Lang('Attention'):</h2>
														<p data-v-ee9f835e="">@Lang('Attention_Note')</p>
													</div>
												</div>
											</div>

                                            <uni-button data-v-7cbc276a="" onclick="disable2FA()" style="margin-top:40px" class="hero-button" type="primary">@Lang('Disable 2FA')</uni-button>
                                        </uni-view>
                                    </form>
                                </uni-view>
							</uni-view>
						@else

							<h2 class="title" style="font-size:.50rem;margin-top:2.0rem;position: relative;text-align: center;text-align: -webkit-center;">
								<div class="favicon"><img src="{{$qrCodeUrl}}" alt /></div>

								<p data-v-ee9f835e="" style="font-size:18px;color:#FFF;">@Lang('2fa_step_1') <a target="_blank" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2" class="text-light f16">Google Play</a> or <a target="_blank" href="https://apps.apple.com/us/app/google-authenticator/id388497605" class="text-light f16">App Store</a>.</p>
								<p><br/><hr style="opacity:0.2"/><br/></p>
								<p data-v-ee9f835e="" style="font-size:18px;color:#FFF;" class="mb-1"><strong class="text-dark">@Lang('2fa_step_2'):</strong></p>
							</h2>

                            <uni-view data-v-c23c4702="" class="goods-title">
                            </uni-view>
						
                            <uni-view data-v-c23c4702="">
                                <uni-view data-v-c23c4702="" class="container-item login kJse" style="">
                                    <form action="{{route('user.twofactor.enable')}}" id="google2faForm" method="post" data-v-7cbc276a="" data-v-c23c4702="" class="form">
										@csrf  
                                        <uni-view data-v-7cbc276a="" class="info">
                                            
											<uni-view data-v-43007dac="" class="info" style="margin-top:10px">
												<p data-v-43007dac="">YOUR 2FA CODE</p>
												<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
													<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;justify-content: space-between;">
														<span data-v-0a75b799="" style="margin-top:7px"><img src="{{ asset($activeTemplateTrue.'img/password.png') }}" style="width:24px" /></span>
														<input readonly disabled style="width:78%;padding:10px 2px;background:transparent;" placeholder="Secret key" name="current_password" value="{{$secret}}" autocomplete="off" type="text" class="uni-input-input">
														<span data-v-0a75b799="" class="eyeView" onclick="copyME(this)" data-clipboard="{{$secret}}" data-copy-text="2FA CODE NOW COPIED" style="margin-top:9px"><svg xmlns="http://www.w3.org/2000/svg" width="19" height="19" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-link" style="margin-left: 16px;"><path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path><path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path></svg></span>
													</span>
												</uni-input>
											</uni-view>
											
											<input type="hidden" name="key" value="{{$secret}}">

											<uni-view data-v-43007dac="" class="info" style="margin-top:34px">
												<p data-v-43007dac="">@Lang('enter_2fa')</p>
												<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
													<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;">
														<span data-v-0a75b799="" style="margin-top:7px"><img src="{{ asset($activeTemplateTrue.'img/record.png') }}" style="width:24px" /></span>
														<input id="google2fa" placeholder="Enter 2FA Code" style="width:78%;padding:10px 2px;background:transparent;" name="code" enterkeyhint="done" autocomplete="off" type="text" class="uni-input-input">
													</span>
												</uni-input>
											</uni-view>

											
											<div class="centnen" style="margin-top:7.5vmin">
												<div class="wrap">
													<div class="tips-box">
														<h2>@Lang('Attention'):</h2>
														<p data-v-ee9f835e="">@Lang('Attention_Warning')</p>
													</div>
												</div>
											</div>

                                            <uni-button data-v-7cbc276a="" onclick="onOk()" style="margin-top:40px" class="hero-button" type="primary">@Lang('confirm_enable')</uni-button>
                                        </uni-view>
                                    </form>
                                </uni-view>
								
                            </uni-view>
						@endif
                    </uni-view>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>
	</uni-app>

</div>
@endsection


@push('script')
    <script>
	function copyME(me){
		var msg = $(me).data('copy-text');
		var copied = $(me).data('clipboard');
		var $temp = $("<input>");
		$("body").append($temp);
		$temp.val(copied).select();
		document.execCommand("copy");
		$temp.remove();
		Toast(msg);
	}
	
	function onOk(){
		let google2fa = $('#google2fa').val();

		if ( !google2fa || google2fa.length < 6 ) {
			Toast('Google 2fa has to be 6 or more digits');
			return false;
		}
		
		loading.showLoading({type: 3,tip: "loading.."});
		$("#google2faForm").submit();
	}
	
	function disable2FA(){
		let google2fa = $('#google2fa-code').val();

		if ( !google2fa || google2fa.length < 6 ) {
			Toast('Google 2fa has to be 6 or more digits');
			return false;
		}
		
		loading.showLoading({type: 3,tip: "loading.."});
		$("#disable2FA").submit();
	}
	
    </script>
@endpush


