<?php $user = auth()->user(); ?>
@extends($activeTemplate.'layouts.users')

@push('style')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/invest.css') }}{{$catch}}">
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/view.css') }}{{$catch}}">

<style>.rgkf[data-v-98c026]{display:block !important; }.flex-shrink-0 .rounded-br{border: 1px solid #094770;
    margin-left: -4px;border-radius:0px;}</style>
@endpush

@php
    $buyLimit = (config('settings')->buy_limit && $plan->escape_buy_limit != 1) ? config('settings')->buy_limit :$plan->buy_limit;
    $limiBuy = (config('settings')->buy_limit && $plan->escape_buy_limit != 1) ? config('settings')->limit_buy : $plan->limit_buy;
    
	$statusText = '';
    $statusLink = 0;
    if($plan['p_status'] == 'coming') {
		$statusClass = 'bg-secondary';
		$statusName = 'Upcoming';
		$statusText = 'UPCOMING';
    }elseif($boughtCount >= $limiBuy && $buyLimit || $plan['p_status'] == 'solid_out') {
		$statusClass = 'bg-danger';
		$statusName = ($plan['p_status'] == 'trial') ? 'Activated' : 'Sold Out';
		$statusText = 'SOLD OUT';
    }else {
		$statusClass = 'bg-primary-blue';
		$statusName = ($plan['p_status'] == 'trial') ? 'Activate' : 'Buy Now';
		$statusLink = 1;
		$statusText = 'BUY NOW';
    }
@endphp

@section('content')
    <uni-app class="uni-app--maxwidth" >
        <uni-page>
            <uni-page-wrapper class="viPlsw">
                <uni-page-body>
                    <uni-view data-v-614da8ff="">
					
						<uni-view data-v-d40c0b3e="" class="content color-bg" style="height: auto;">

							<uni-view data-v-58cb4ed7="" data-v-5c2fef75="" class="back-title" style="background:none;">
								<span data-href="{{ route('user.investment') }}" class="linkBTN"><img src="{{ asset($activeTemplateTrue.'img/back.png') }}" style="margin-left:12px;width:28px;" /></span>
								<span data-v-58cb4ed7="" class="title-txt">Product Details</span>
							</uni-view>
						
							<uni-view data-v-7625a4cc="" data-v-3eaa641c="" class="bg" style="margin-top:80px;display:none">
								
								<uni-view data-v-7625a4cc="" class="asset-info">
									<uni-view data-v-7625a4cc="" class="asset-info-item">
										<span data-v-7625a4cc="" class="asset-info-item-s1">DEPOSIT BALANCE</span>
										<span data-v-7625a4cc="" class="asset-info-item-s2">{{ $user->user_currency_sym }}{{ showAmount($userBalance['main']) }}</span>
									</uni-view>
								</uni-view>

								<uni-view data-v-7625a4cc="" class="asset-btn">
									<span style="position:absolute;top: -19px;left: 15px;">Earnings</span>
									<uni-view data-v-7625a4cc="" class="btn">
										<span data-v-7625a4cc="">{{ showAmount($userBalance['income']) }}</span>
										<uni-text data-v-0a75b799="" data-v-7625a4cc="" class="" style="top:auto;padding-right:4px;">{{ $user->user_currency_sym }}</uni-text>
									</uni-view>
								</uni-view>
							</uni-view>
						
					
							<uni-view data-v-25a9fe6c="" data-v-62c02cd0="" style="position: relative;margin:80px 14px -14px">
								<uni-view data-v-25a9fe6c="" class="goods-card {{$statusClass}}">
									<uni-view data-v-25a9fe6c="" class="goods-content" style="margin-bottom:4px;">
										<uni-view data-v-25a9fe6c="" class="thumb" style="width:45%;">
											<img data-v-25a9fe6c="" src="{{ asset('assets/'.$plan['img']) }}" style="border-radius:8px;">
										</uni-view>
										<uni-view data-v-25a9fe6c="" class="desc" style="font-size:18px;width:55%;">
											<p data-v-25a9fe6c="" class="price color3 mb-4">{{ $plan['name'] }}</p>
											@if( $plan['interest_type'] == 1)
											<span data-v-25a9fe6c="" class="price color3">{{ $plan->cur_sym }}{{ showAmount($plan['min_amount'],2) }} to {{ $plan->cur_sym }}{{ showAmount($plan['max_amount'],2) }} </span>
											@else
											<span data-v-25a9fe6c="" class="price color3">{{ $plan->cur_sym }}{{ showAmount($plan['min_amount'],2) }}</span><span class="font-body text-gray-600 font-bold fkqYfq"> / Per buy order</span>
											@endif
										</uni-view>
									</uni-view>
									@if( $plan['p_status'] == 'coming' )
									<uni-view data-v-410a7989="" class="flash-sale">
										<p data-v-410a7989="">Countdown</p>
										<p data-v-410a7989="" id="counter{{$plan['id']}}">
											<span data-v-410a7989="" class="num">02</span>
											<span data-v-410a7989="">Days</span>
											<span data-v-410a7989="" class="num">20</span>
											<span data-v-410a7989="">:</span>
											<span data-v-410a7989="" class="num">22</span>
											<span data-v-410a7989="">:</span>
											<span data-v-410a7989="" class="num">58</span>
										</p>
									</uni-view>
									@endif
								</uni-view>
							</uni-view>

							<div class="flex flex-col flex-1 relative" style="margin:0 20px">

								<input type="hidden" id="coupon" value="">
								@csrf
								<input type="hidden" id="pay_with" value="{{ $plan->cur_text }}">
								
								<div class="flex flex-wrap justify-between flex-shrink-0 mb-4 w-full">
									<div class="flex flex-shrink-0 flex-col items-center rounded-t rounded-br border w-full p-2" style="padding:4px;border-radius:4px;">
										
										<table style="width:100%;margin:22px auto;color:#fff;font-size:13px;border-spacing:12px;">
										  <tr>
											<td style="font-size:18px;">Daily earnings</td>
											<td style="font-size:18px;">
											@if( $plan->interest_type == 1)
											{{ showAmount($plan->interest_amount) }}%
											@else
											{{ $plan->cur_sym }}{{ showAmount($plan->interest_amount) }}
											@endif
											</td>
										  </tr>
										  <tr>
											<td style="font-size:15px;"><div style="">Cycle </div></td>
											<td style="font-size:15px;"><div style="">{{ $plan->total_return }} Days</div></td>
										  </tr>
										  <tr>
											<td style="font-size:15px;"><div style="">Total earnings</div></td>
											<td style="font-size:15px;"><div style="">{{ $plan->cur_sym }}{{ showAmount($plan->interest_amount * $plan->total_return) }}</div></td>
										  </tr>
										  <tr>
											<td style="font-size:15px;"><div style="">Total return</div></td>
											<td style="font-size:15px;"><div style="">
											@if( $plan->interest_type == 1)
											{{ showAmount($plan->interest_amount * $plan->total_return) }}%
											@else
												 @php $lols = $plan->interest_amount * $plan->total_return; @endphp
											{{ ( ( $lols / $plan->min_amount) * 100 ) }}%
											@endif
											</div></td>
										  </tr>
										  <tr>
											<td style="font-size:15px;"><div style="">Quantity limit</div></td>
											<td style="font-size:15px;"><div style="">{{ $plan->limit_buy }}</div></td>
										  </tr>
										</table>
									</div>
								</div>

								<div class="mb-4">
									<h3 class="font-body text-gray-600 mb-4 w-full" style="color:#f8a324">Payment method</h3>

									@if( $plan['interest_type'] == 1)
									<uni-view data-v-43007dac="" class="info mb-4" style="margin-top:10px;margin-bottom:24px;">
										<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;margin-top:8px;border-radius: 8px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-top:0px;width: 94%;display: flex;justify-content: space-between;">
												<span data-v-0a75b799="" style="margin-top:7px"><img src="{{ asset($activeTemplateTrue.'img/password.png') }}" style="width:24px" /></span>
												<input id="buyAmount" style="width:78%;padding:10px 2px;background:transparent;" placeholder="Enter amount" name="amount" enterkeyhint="done" autocomplete="off" type="number" class="uni-input-input">
												<span data-v-0a75b799="" class="eyeView" style="margin-top:3px">{{ config('settings')->cur_text }}</span>
											</span>
										</uni-input>
									</uni-view>
									@else
									<input type="hidden" id="buyAmount" value="{{ $plan->min_amount }}" step="any" name="amount" class="w-full mb-4" placeholder="ENTER AMOUNT">
									@endif
									

									@if($statusLink)
									<a class="sc-kjoXOD fcoOgC text-center whitespace-no-wrap rounded-t rounded-br w-full justify-center pt-4 py-3 px-6 font-display font-bold text-white" id="btn-pay" style="background:linear-gradient(270deg, #1e7d52, #49da9e)">Recharge wallet</a>&nbsp;&nbsp;
									<a class="sc-kjoXOD fcoOgC text-center whitespace-no-wrap rounded-t rounded-br w-full justify-center pt-4 py-3 px-6 font-display font-bold text-white" id="btnPayInco" style="background:linear-gradient(270deg, #f59503, #ffd38f)">Balance wallet</a>
									@else 
									<a class="sc-kjoXOD fcoOgC text-center whitespace-no-wrap rounded-t rounded-br w-full justify-center pt-4 py-3 px-6 font-display font-bold text-white linkBTN" data-href="{{ route('user.deposit') }}" style="background:linear-gradient(270deg, #1e7d52, #49da9e)">Recharge wallet</a>
									<a class="sc-kjoXOD fcoOgC text-center whitespace-no-wrap rounded-t rounded-br w-full justify-center pt-4 py-3 px-6 font-display font-bold text-white" style="background:linear-gradient(270deg, #f59503, #ffd38f)">SOLD OUT</a>
									@endif
								</div>

								<div class="flex flex-wrap justify-between flex-shrink-0 mb-4 w-full">
									<h3 class="font-body text-gray-600 mb-2 w-full" style="color:#f8a324">Product Description</h3>
									<div class="flex flex-shrink-0 items-center rounded-t rounded-br border w-full p-2 mb-4">
										<div class="flex flex-col mr-2 w-full">
											<p class="font-body text-gray-500 whitespace-pre-wrap">{!! $plan->notes !!}</p>
										</div>
										<div class="flex flex-col flex-1 self-start"></div>
									</div>
								</div>
								<div class="flex flex-col flex-shrink-0 my-4 items-center iJhae">
									<span class="font-body text-gray-600 text-center mb-2">{!! $plan->summary !!}</span>
								</div>
							</div>


						</uni-view>
					</uni-view>
				</uni-page-body>
			</uni-page-wrapper>
		</uni-page>
	</uni-app>

@endsection

@push('script')
<script>
	var userIncom = {{$user->income}}; 
	var userBal = {{$user->balance}}; 
	
    $('#btn-pay').on('click', function() {
        
        // Data
        var buyAmount = $('#buyAmount').val();
        var coupon = $('#coupon').val();
        var pay_with = $('#pay_with').val();
        var token = document.querySelector('input[name="_token"]').value;

        var is_status = true;

        if (!buyAmount) {
            Toast("Please enter an amount to buy order");
            is_status = false;
        }

        if (buyAmount > userBal ) {
			Toast("You do not have sufficient recharge balance, please recharge first!",'ERROR MESSAGE',false,'RECHARGE','{{ route("user.deposit")}}');
            is_status = false;
        }

        if (is_status) {
			$.ajax({
				url: "{{ route('user.investment.post') }}",
				type: 'POST',
				data: {
					'id': "{{ $plan->id }}",
					'coupon': coupon,
					'amount': buyAmount,
					'pay_with': pay_with,
					'debit_wallet': 'Balance',
                    _token: token
				},
				 beforeSend: function() {
					loading.showLoading({type: 2,tip: "Please wait..."});
				},
				success: function(data) {
					console.log(data);
					loading.hideLoading();
					if(data.link) {
						Toast(data.message,'RESPONSE MESSAGE',false,'SUCCESS',data.link);
						return true;
					}
					Toast(data.message);
				},
				error: function(xhr, status, error) {
					var data = JSON.parse(xhr.responseText);
					var responseMessage = data.message
					loading.hideLoading();

					// Validator message
					if (data.errors) {
						var errorMessages = [];
						for (var key in data.errors) {
							if (data.errors.hasOwnProperty(key)) {
								errorMessages.push(data.errors[key][0]);
							}
						}

						responseMessage = errorMessages.join(", ")
					}
					
					if(data.link) {
						Toast(responseMessage,'RESPONSE MESSAGE',false,'ERROR MSG',data.link);
						return true;
					}
					
					Toast(responseMessage);
				}
			});
		}
    })

    $('#btnPayInco').on('click', function() {
        // Data
        var buyAmount = $('#buyAmount').val();
        var coupon = $('#coupon').val();
        var pay_with = $('#pay_with').val();
        var token = document.querySelector('input[name="_token"]').value;

        var is_status = true;

        if (!buyAmount) {
            Toast("Please enter an amount to buy order");
            is_status = false;
        }

        if (buyAmount > userIncom ) {
			Toast("You do not have sufficient balance wallet, please recharge first!",'ERROR MESSAGE',false,'RECHARGE','{{ route("user.deposit")}}');
            is_status = false;
        }

        if (is_status) {
			$.ajax({
				url: "{{ route('user.investment.post') }}",
				type: 'POST',
				data: {
					'id': "{{ $plan->id }}",
					'coupon': coupon,
					'amount': buyAmount,
					'pay_with': pay_with,
					'debit_wallet': 'Income',
                    _token: token
				},
				 beforeSend: function() {
					loading.showLoading({type: 2,tip: "Please wait..."});
				},
				success: function(data) {
					console.log(data);
					loading.hideLoading();
					if(data.link) {
						Toast(data.message,'RESPONSE MESSAGE',false,'SUCCESS',data.link);
						return true;
					}
					Toast(data.message);
				},
				error: function(xhr, status, error) {
					var data = JSON.parse(xhr.responseText);
					var responseMessage = data.message
					loading.hideLoading();

					// Validator message
					if (data.errors) {
						var errorMessages = [];
						for (var key in data.errors) {
							if (data.errors.hasOwnProperty(key)) {
								errorMessages.push(data.errors[key][0]);
							}
						}

						responseMessage = errorMessages.join(", ")
					}
					
					if(data.link) {
						Toast(responseMessage,'RESPONSE MESSAGE',false,'ERROR MSG',data.link);
						return true;
					}
					
					Toast(responseMessage);
				}
			});
		}
    })

</script>
@endpush