@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/withdraw.css') }}{{$catch}}">
@endpush

@section('content')
    <uni-app class="uni-app--maxwidth">
		@php
			$accountNumber = ($user->bankAccount) ? $user->bankAccount->account_number : 'CRYPTO';
			$accountName = ($user->bankAccount) ? $user->bankAccount->account_name : $user->withdrawal_usdt_address;
			$bankName = ($user->bankAccount) ? $user->bankAccount->bank_name : 'USDT';
		@endphp
        <uni-page data-page="pages/record/withdraw">
			<uni-page-wrapper class="cpKljEd">
            <uni-page-wrapper>
                <uni-page-body>
                    <uni-view data-v-5c2fef75="">
                        <uni-view data-v-5c2fef75="" class="content">
							<uni-view data-v-58cb4ed7="" data-v-5c2fef75="" class="back-title">
								<span data-href="{{ route('user.profile') }}" class="returnBank"><img src="{{ asset($activeTemplateTrue.'img/back.png') }}" style="margin-left:12px;width:28px;" /></span>
								<span data-v-58cb4ed7="" class="title-txt">withdraw</span>
							</uni-view>
                            <uni-view data-v-5c2fef75="" class="color-bg"></uni-view>
							
                            <form method="post" action="{{ route('user.withdraw.money') }}" data-v-5c2fef75="" class="">

								<div data-v-43007dac="" class="form xkKlDe" style="margin:24px 30px -25px;border-radius: 13px 13px 0 0;">
									<uni-view data-v-5c2fef75="" class="balance-card" style="justify-content:start;">
										<img src="{{ asset($activeTemplateTrue.'img/wallet.png') }}" style="margin-left:12px;height:28px;" />
										<span style="color: #fff;font-size:20px;font-weight:700;margin-top: 3px; margin-left: 4px;"> Available assets</span>
										<uni-view data-v-240cb67c="" data-v-5c2fef75="" class="first" style="padding:24px 0 0;left: -43px;position: relative;">
											<p data-v-240cb67c="" class="" style="color: #fff;">{{ showAmount($user->referral_wallet) }}</p>
										</uni-view>
									</uni-view>
								</div>

								<div data-v-43007dac="" class="form xkKlDe" style="margin-top: 25px;">
									<uni-view data-v-43007dac="" class="info">
										<p data-v-43007dac="">Withdrawal amount</p>
										<uni-input data-v-64270b22="" class="inView" style="height:auto;margin-top:8px; padding: 4px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;font-size:18px;justify-content: space-between;">
												<span data-v-0a75b799="" style="margin-top:7px;color:#FFF">{{ config('settings')->cur_sym}}</span>
												<input step="0.0001" id="amtID" style="width:78%;padding:10px 2px;background:transparent;text-align:center;font-size:18px;color:#FFF;" placeholder="Minimum {{ getAmount($withdrawMethod[0]->min_limit) }}" name="amount" enterkeyhint="done" autocomplete="off" type="text" class="uni-input-input">
												<span data-v-0a75b799="" style="margin-top:7px;color:#FFF">{{ config('settings')->cur_text}}</span>
											</span>
										</uni-input>
										
										<uni-view data-v-5c2fef75="" class="tip" style="display:none">
											<span data-v-5c2fef75="" style="display: block;" >
												<span id="rateValue">{{ config('settings')->cur_sym}}0.00 ≈ {{ config('settings')->cur_sym}}0.00</span>
												<span id="taxRate" data-v-5c2fef75="" style="font-size: 15px; color: rgb(99, 132, 66); margin-top: 0px; padding-left: 0px; margin-bottom: 2px;">({{ ($withdrawMethod[0]->percent_charge + 0)}}% Tax)</span>
											</span>
											<span data-v-5c2fef75="" id="exchangeRate">{{ config('settings')->cur_sym}}1.00 ≈ {{ config('settings')->cur_sym}}1.00</span>
										</uni-view>
									</uni-view>
									
									<p data-v-5c2fef75="" major-title="true" style="margin: 45px 0px 10px;">Bank account: <span class="linkBTN" data-href="{{ route('user.account-setup') }}" style="float:right;-webkit-text-fill-color:#d5931a !important"><b style="color:#d5931a;">My Bank</b></span></p>
									<uni-view data-v-5c2fef75="" class="transfer-to-card" style="margin-left: -7%">
										<table style="width:100%;border-spacing:4px 20px;font-size:17px;">
											<tr>
												<td style="text-align:end;padding-right: 15px;">Your Name</td>
												<td style="border-bottom: 1px solid;">{{ $accountName }}</td>
											</tr>
											<tr>
												<td style="text-align:end;padding-right: 15px;">Bank Name</td>
												<td style="border-bottom: 1px solid;">{{ $bankName }}</td>
											</tr>
											<tr>
												<td style="text-align:end;padding-right: 15px;">Bank Accounts</td>
												<td style="border-bottom: 1px solid;">{{ $accountNumber }}</td>
											</tr>
										</table>

									</uni-view>

									@if( $user->withdrawal_password )
									<uni-view data-v-43007dac="" style="margin-top:12px" class="info">
										<p data-v-43007dac="">Transaction Pin</p>
										<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;justify-content: space-between;">
												<span data-v-0a75b799="" style="margin-top:7px"><img src="{{ asset($activeTemplateTrue.'img/password.png') }}" style="width:24px" /></span>
												<input id="withPassword" style="width:78%;padding:10px 2px;background:transparent;" placeholder="Requires Transaction Pin" name="code" enterkeyhint="done" autocomplete="off" type="password" maxlength="6" class="uni-input-input">
												<span data-v-0a75b799="" class="eyeView" style="margin-top:9px"><img src="{{ asset($activeTemplateTrue.'img/eye-fill.png') }}" style="width:17px" /></span>
											</span>
										</uni-input>
									</uni-view>
									@endif
									
									@if( $user->ts )
									<uni-view data-v-43007dac="" style="margin-top:12px" class="info">
										<p data-v-43007dac="">Google authenticator</p>
										<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;justify-content: space-between;">
												<span data-v-0a75b799="" style="margin-top:7px"><img src="{{ asset($activeTemplateTrue.'img/password.png') }}" style="width:24px" /></span>
												<input id="authenticator" style="width:78%;padding:10px 2px;background:transparent;" placeholder="Requires two factor code" name="authenticator" enterkeyhint="done" autocomplete="off" type="password" maxlength="6" class="uni-input-input">
												<span data-v-0a75b799="" class="eyeView" style="margin-top:9px"><img src="{{ asset($activeTemplateTrue.'img/eye-fill.png') }}" style="width:17px" /></span>
											</span>
										</uni-input>
									</uni-view>
									@endif
								
									<input type="hidden" name="method" id="method" value="{{ $withdrawMethod[0]->id}}">
									<input type="hidden" name="debit_from" id="debit_with" value="referral_wallet">
									<input id="bank_free" type="hidden" value="{{ ($withdrawMethod[0]->percent_charge/100) }}">
									@csrf

									<div style="width: 100%; height: 25px; line-height: 30px; margin-top:10px;border-width: 0px; border-style: solid; border-radius: 2px 2px 2px 2px; text-align: left;display:none;">
										<span class="textOthers" style="float:left;font-size:12px;">
											<font>Receiving amount</font>:
											<font id="jieguo1"></font>
										</span>
										<span class="textOthers" style="float: right; font-size: 12px;"><font>Tax</font>: <font id="free">{{ $withdrawMethod[0]->percent_charge}}</font>%</span>
									</div>
									<uni-button data-v-5c2fef75="" class="hero-button" id="withdrawBTN" type="primary">Withdraw</uni-button>
								</div>
								
                            </form>
							
                            <uni-view data-v-5c2fef75="" class="rules">
                                <h3 data-v-5c2fef75="">Withdrawal Rules</h3>
								{!! $withdrawMethod[0]->description !!}
                            </uni-view>
                        </uni-view>
                    </uni-view>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>

	</uni-app>
@endsection

@push('script')
<script>
	var currency = "NGN", symbol = "₦", rate="1", xchange = "1", other = "₮";
	$('#amtID').keyup(function() {
		$(this)[0].value = $(this)[0].value.replace(/^(0+)|[^\d]+/g, '')
		exchange();
	})

	$('.eyeView').click(function() {
		if ($($(this).siblings('input')[0]).attr('type') == 'password') {
			$($(this).siblings('input')[0]).attr('type', 'text')
			$(this).addClass('active')
		} else {
			$($(this).siblings('input')[0]).attr('type', 'password')
			$(this).removeClass('active')
		}
	})


	$('.tabs').click(function() {
		$(".tabs").removeClass('active');
		$(this).addClass('active');
		var info = $(this).data();
		currency = info.currency, symbol = info.symbol, rate = info.rate, xchange = info.exchange, other = info.other;
		$('#exchangeRate').html("["+currency+"] "+symbol+"1.00 ≈ " + other + " "+rate+"");
		exchange();
	})

	function exchange(){
		let amount = $('#amtID').val();
		var free = $("#bank_free").val();
		var toFix = 2;
		if( !isNaN(amount) ){
			var value = amount*xchange;
			$('#rateValue').html("₦"+amount+".00 ≈ " + symbol + "" + value + " [" + currency + "]");
			
			toFix = (currency == "NGN") ? 2:4;

			var freeamount = value * free * 1;
			var sjamount = value - freeamount;
			$("#jieguo1").html(currency + " " + sjamount.toFixed(toFix));

		}
		
	}

    $("#withdrawBTN").click(function() {

        var amount = $('#amtID');
        var method = $('#method');
        var debit_from = $('#debit_with');
        var password = $('#withPassword');
        var gFactore = $('#authenticator');
        var token = document.querySelector('input[name="_token"]').value;
        var is_status = true;

        if (!amount.val()) {
			Toast('Withdrawing amount required','REQUEST AMOUNT');
            is_status = false; return false;
        }

		<?php if( $user->withdrawal_password ){ ?>
        if (!password.val()) {
            Toast("Withdrawal pin Required",'SECURITY PIN');
            is_status = false;
        }
		<?php } ?>

		<?php if( $user->ts ){ ?>
        if (!gFactore.val()) {
            Toast("Google two factor code Required",'GOOGLE AUTHENTICATOR');
            is_status = false;
        }
		<?php } ?>

        if (is_status) {
            $.ajax({
                type: "POST",
                url: "{{ route('user.withdraw.money') }}",
                data: {
                    amount: amount.val(),
                    method: method.val(),
                    debit_from: debit_from.val(),
                    password: password.val(),
                    _token: token
                },
                beforeSend: function() {
					loading.showLoading({type: 3,tip: "loading.."});
                },
                success: function(data) {
					loading.hideLoading();
					Toast(data.message,'RESPONSE MESSAGE',false,'SUCCESS',data.link);
					password.val('');
                },
                error: function(xhr, status, error) {
                    var responseText = JSON.parse(xhr.responseText);
					loading.hideLoading();
					Toast(responseText.message,'ERROR MESSAGE');
					password.val('');
                },
                fail: function() {
					Toast('Request Failed', 'RESPONSE MESSAGE');
					loading.hideLoading();
					password.val('');
                }
            });
        }

        return false;
    });
</script>
@endpush
