<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  @include('partials.seo')

  <title>@if(View::hasSection('pageTitle')) @yield('pageTitle') @else {{ config('settings')->sitename(__($pageTitle)) }} @endif</title>
  <link rel="shortcut icon" type="image/x-icon" href="{{ asset('users/assets/trade/img/favicon.png') }}" />

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tiny-slider/2.9.4/tiny-slider.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css"/>
  <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
  <link rel="stylesheet" href="{{ asset('users/jasper/css/bootstrap.min.css') }}{{$catch}}" >
  <link rel="stylesheet" href="{{ asset('users/jasper/css/widgets.css') }}{{$catch}}" >
  <link rel="stylesheet" href="{{ asset('users/jasper/css/loading.css') }}{{$catch}}" >
  <script src="https://code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

  @stack('style-lib')

  @stack('style')

</head>
  <body>
    <div class="main-container" id="container">
		@yield('content')
	</div>
	@include($activeTemplate. 'layouts.menu')

	@stack('script')

	<script src="{{ asset('users/jasper/js/app.js') }}{{$catch}}"></script>
  
	@include($activeTemplate. 'partials.notify')
  </body>
</html>
