@extends($activeTemplate.'layouts.app')

@push('style')
<style type="text/css">
    .text p {
        background: #cebdff;
        width: 100px;
        text-align: center;
        color: #fff;
        border-radius: 5px;
        font-size: 16px;
        height: 30px;
        line-height: 30px;
        margin-top: 10px;
    }

    .appContent {
        padding: 0 10px 20px 10px;

    }

    .text-muted {
        color: #8D95A0;
        font-size: 14px;
        font-weight: 400;
        display: initial;
        float: right;
    }

    .itema a {
        display: flex;
    }

    .itemList .item {
        border-radius: 8px;
    }

    .mtbe {
        padding-top: 14px;
    }

    .itemList {
        border-radius: 6px;
    }

    .itemList .item .image img {
        width: 133px;
        border-radius: 0;
    }

    .itemList .item .text {
        margin-top: 6px;
        margin-left: 10px;
    }


    .text span {
        font-size: 13px;
        color: #999;
    }

    .texle {
        text-align: center;
        margin-top: 8px;
    }

    .texle span {
        background: #ca95ed;
        color: #333;
        padding: 4px 20px;
        border-radius: 4px;
    }

    .itemList .item {

        padding-bottom: 0;
        padding: 0;

    }

    .text h3 {
        text-align: center;
        background: #3d45e6;
        width: 40px;
        float: right;
        margin-right: 10px;
        border-radius: 50%;
        font-size: 18px;
        height: 40px;
        line-height: 40px;
        color: #fff;
    }

    .geyu span {
        font-size: 18px;
        color: #fd3133;
        font-weight: 600;
    }

    .itemList .item .text .title {
        font-size: 16px;
    }
</style>
@endpush


@section('container') <div id="appCapsule" class="pb-2"> @endsection
@section('content')
@include($activeTemplate. 'layouts.app_navprev')

<div style="clear: both;"></div>
<div class="appContent pb-0  pt-1">

    <div class="mx-1 ">

        @foreach($tasks as $task)
        <div class="itemList">
            <a href="{{ route('user.task.page', ['id' => $task->slug]) }}">
                <div class="item itema">
                    <div class="image">
                        <img src="{{ asset('assets') }}/{{ $task->image }}" alt="image">
                    </div>
                    <div class="text">
                        <h4 class="title">{{ $task->name }}</h4>
                        <span>Complete tasks to get rewards</span>
                        <div class="geyu">
                            <span>{{ $task->currency }} {{ showAmount($task->amount) }}</span>

                        </div>

                    </div>

                </div>
            </a>
        </div>
        @endforeach

    </div>


</div>
@endsection

@push('script')
@endpush