@extends('layouts.auth')
@section('content')


    <div class="d-table-cell align-middle">

        <div class="text-center mt-4">
            <h1 class="h2 text-danger">Welcome!</h1>
            <p class="lead text-primary ">
                @lang('Please Verify Your Email to Get Access')
            </p>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="m-sm-3">

                    <form action="{{route('user.verify.email')}}" method="POST" class="login-form">
                        @csrf

                        <div class="mb-3">
                            <p class="text-center">@lang('Your Email'):
                                <strong>{{auth()->user()->email}}</strong></p>
                        </div>


                        <div class="mb-3">
                            <label class="form-label">@lang('Verification Code')</label>
                            <input type="text" name="email_verified_code" class="form-control form-control-lg" maxlength="7"
                                   id="code">
                        </div>


                        <div class="mb-3">
                            <div class="btn-area text-center">
                                <button type="submit" class="btn btn-success w-100">@lang('Submit')</button>
                            </div>
                        </div>


                        <div class="mb-3">
                            <p>@lang('Please check including your Junk/Spam Folder. if not found, you can') <a
                                        href="{{route('user.send.verify.code')}}?type=email"
                                        class="forget-pass text--base"> @lang('Resend code')</a></p>
                            @if ($errors->has('resend'))
                                <br/>
                                <small class="text-danger">{{ $errors->first('resend') }}</small>
                            @endif
                        </div>


                    </form>


                </div>
            </div>
        </div>
    </div>

@endsection
@push('script')
    <script>
        (function ($) {
            "use strict";
            $('#code').on('input change', function () {
                var xx = document.getElementById('code').value;

                $(this).val(function (index, value) {
                    value = value.substr(0, 7);
                    return value.replace(/\W/gi, '').replace(/(.{3})/g, '$1 ');
                });

            });
        })(jQuery)
    </script>
@endpush
