@extends($activeTemplate.'layouts.auth')

@push("page_title") Login @endpush

@push('style') 
@endpush

@section('content')
<div class="form-container outer">
	<div class="form-form">
		<div class="form-form-wrap">
			<div class="form-container">
				<div class="form-content">
					<a href=""><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" width="80" style="border-radius: 20%;"></a>

					<h1 class="" style="padding-top: 10px;">Sign-In</h1>
					<p class="">Log in to your account to continue.</p>
					<form class="text-left post-form">
						
						<div class="form">
							<div id="username-field" class="field-wrapper input">
								<label for="username">USERNAME</label>
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
								<input id="username" name="username" type="text" class="form-control" placeholder="e.g king-Richie">
							</div>

							<div id="password-field" class="passwordIn field-wrapper input mb-2">
								<div class="d-flex justify-content-between">
									<label for="password">PASSWORD</label>
									<a data-href="{{ route('user.password.request') }}" class="linkBTN forgot-pass-link">Forgot Password?</a>
								</div>
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-lock"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
								<input id="password" name="password" type="password" class="form-control" placeholder="Password">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" id="toggle-password" class="viewPass feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
							</div>
							
							@csrf

							<div class="d-sm-flex justify-content-between">
								<div class="field-wrapper">
									<button type="button" id="btn-submit" class="btn btn-primary" value="">Login</button>
								</div>
							</div>
							<p class="signup-link">Not registered ? <a class="linkBTN" data-href="{{ route('user.register') }}">Create an account</a></p>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@push('script')
<script>
    $('#btn-submit').on('click', function() {
        // Form input Value
        var username = $('#username');
        var password = $('#password');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!username.val()) {
            modalMessage('Please enter your Phone Number');
            is_status = false;
        }

        if (!password.val()) {
            modalMessage('Please enter your password');
            is_status = false;
        }
        // End Verify

        if (is_status) {
            $.ajax({
                url: "",
                type: 'POST',
                data: {
                    password: password.val(),
                    username: username.val(),
                    _token: token
                },
                beforeSend: function() {
					loading.showLoading({type: 4,tip: "loading.."});
                },
                success: function(data) {
                    modalMessage('Login Successful', 200, data.intended);
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

					loading.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush