@extends($activeTemplate.'layouts.auth')

@push("page_title") Password reset @endpush

@push('style')
@endpush

@section('content')
<div class="form-container outer">
	<div class="form-form">
		<div class="form-form-wrap relative">
			<div class="linkBTN van-nav-bar__left van-haptics-feedback" data-href="{{ route('user.login')}}"><img class="van-badge__wrapper van-icon van-icon-arrow-left van-nav-bar__arrow" src="{{ asset('users/assets/trade/img/arrow-left-thin.svg') }}" style="width:34px"></div>
			<div class="form-container">
				<div class="form-content">
					<a href=""><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" width="80" style="border-radius: 20%;"></a>

					<h1 class="" style="padding-top: 10px;">Password Reset</h1>
					<p class="">Provide account details to continue.</p>
					<form class="text-left post-form">
						
						<div class="form">
							<div id="username-field" class="field-wrapper input">
								<label for="username">USERNAME</label>
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
								<input id="username" name="username" type="text" class="form-control" placeholder="e.g king-Richie">
							</div>

							<div id="password-field" class="passwordIn field-wrapper input mb-2">
								<div class="d-flex justify-content-between">
									<label for="password"></label>
									<a data-href="{{ route('user.login') }}" class="linkBTN forgot-pass-link">REMEMBER? LOGIN</a>
								</div>
							</div>

							@csrf

							<div class="d-sm-flex justify-content-between" style="margin-top:40px">
								<div class="field-wrapper">
									<button type="button" id="btn-submit" class="btn btn-primary" value="">Request reset</button>
								</div>
							</div>
							<p class="signup-link">Not registered ? <a class="linkBTN" data-href="{{ route('user.register') }}">Create an account</a></p>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@push('script')
<script>
    $('#username').on('keyup', function() {
        
        // Get value
        var inputValue = $(this).val();

        // Remove non-digit characters
        var numericValue = inputValue.replace(/\D/g, '');

        // Keep value to 10 digits
        var truncatedValue = numericValue.slice(0, 10);

        // Update the input value
        $(this).val(truncatedValue);
    });
    
    $('#btn-submit').on('click', function() {
        
        // Form input Value
        var username = $('#username');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        // Verify input
        if (!username.val()) {
            modalMessage('Please enter your mobile');
            is_status = false;
            return true;
        }
        // End Verify

        if (is_status) {
            $.ajax({
                url: "{{ route('user.password.email') }}",
                type: 'POST',
                data: {
                    username: username.val(),
                    _token: token
                },
                beforeSend: function() {
                    // Handle before sending the request
                    mui.showLoading("Please wait...", "div");
                },
                success: function(data) {
                    
                    // Redirect
                    modalMessage(data.message, 200, data.link);
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    // Validator message
                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    // Redirect
                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

                    mui.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush