@extends($activeTemplate.'layouts.auth')

@section('pageTitle') Register @endsection

@push('style')
@endpush

@section('content')
<div class="form-container outer">
	<div class="form-form">
		<div class="form-form-wrap relative">
			<div class="linkBTN van-nav-bar__left van-haptics-feedback" data-href="{{ route('user.login')}}"><img class="van-badge__wrapper van-icon van-icon-arrow-left van-nav-bar__arrow" src="{{ asset('users/assets/trade/img/arrow-left-thin.svg') }}" style="width:34px"></div>
			<div class="form-container">
				<div class="form-content">
					<a href=""><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" width="80" style="border-radius: 20%;"></a>

					<h1 class="" style="padding-top: 10px;">Sign-Up</h1>
					<p class="">Register an account to continue.</p>
					<form class="text-left post-form">
						<div class="form">

							<div id="invite-field" class="field-wrapper input">
								<label for="invite">Invite code</label>
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
								<input id="invite" name="invite" type="text" class="form-control" placeholder="Invite code [optional]" value="{{ Session::get('reference') }}" >
							</div>

							<div id="mobile-field" class="field-wrapper input">
								<label for="mobile">Mobile No.</label>
								<span class="intext">+234:</span>
								<input id="mobile" name="mobile" type="text" class="form-control" placeholder="e.g 80123478" style="padding-left:56px">
							</div>

							<div id="username-field" class="field-wrapper input">
								<label for="username">Username</label>
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-user"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
								<input id="username" name="username" type="text" class="form-control" placeholder="e.g king-Richie">
							</div>

							<div id="password-field" class="passwordIn field-wrapper input mb-2">
								<div class="d-flex justify-content-between">
									<label for="password">Password</label>
								</div>
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-lock"><rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect><path d="M7 11V7a5 5 0 0 1 10 0v4"></path></svg>
								<input id="password" name="password" type="password" class="form-control" placeholder="Password">
								<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" id="toggle-password" class="viewPass feather feather-eye"><path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path><circle cx="12" cy="12" r="3"></circle></svg>
							</div>
							
							@csrf

							<div class="d-sm-flex justify-content-between">
								<div class="field-wrapper">
									<button type="button" id="btn-submit" class="btn btn-primary" value="">Register</button>
								</div>
								<p class="signup-link" style="margin-top: 15px;margin-bottom: 0px;">Have an account? <a class="linkBTN" data-href="{{ route('user.login') }}">Login account</a></p>
								
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

@push('script')
<script>
    $('#mobile').on('keyup', function() {
        var inputValue = $(this).val();
        var numericValue = inputValue.replace(/\D/g, '');
        var truncatedValue = numericValue.slice(0, 10);
        $(this).val(truncatedValue);
    });

    $('#btn-submit').on('click', function() {
        var username = $('#username');
        var password = $('#password');
        var mobile = $('#mobile');
        var password_confirmation = $('#password');
        var invite = $('#invite');
        var captcha = $('#captcha');
        var token = document.querySelector('input[name="_token"]').value;

        // Enable form submit
        var is_status = true;

        if (!mobile.val()) {
            modalMessage('Please enter your Mobile Number');
            is_status = false;
            return true;
        }
		
        if (!username.val()) {
            modalMessage('Please enter your Username');
            is_status = false;
            return true;
        }

        if (!password.val()) {
            modalMessage('Please enter your password');
            is_status = false;
            return true;
        }

        if (!password_confirmation.val()) {
            modalMessage('Please confirm your password');
            is_status = false;
            return false;
        }

        if (is_status) {
            $.ajax({
                url: "",
                type: 'POST',
                data: {
                    username: username.val(),
                    mobile: mobile.val(),
                    password: password.val(),
                    password_confirmation: password_confirmation.val(),
                    referBy: invite.val(),
                    _token: token
                },
                beforeSend: function() {
					loading.showLoading({type: 4,tip: "loading.."});
                },
                success: function(data) {
                    modalMessage('Registered Successfully', 200, "{{ url(route('user.home')) }}");
                },
                error: function(xhr, status, error) {
                    var data = JSON.parse(xhr.responseText);
                    var responseMessage = data.message

                    // Validator message
                    if (data.errors) {
                        var errorMessages = [];
                        for (var key in data.errors) {
                            if (data.errors.hasOwnProperty(key)) {
                                errorMessages.push(data.errors[key][0]);
                            }
                        }

                        responseMessage = errorMessages.join(", ")
                    }

                    // Redirect
                    if(data.link) {
                        modalMessage(data.message, 400, data.link);
                        return true;
                    }

                    loading.hideLoading();
                    modalMessage(responseMessage);
                }
            });
        }
    })
</script>
@endpush