@extends($activeTemplate.'layouts.home')

@push('style')
  <link rel="stylesheet" href="{{ asset('users/jasper/css/recharge.css') }}{{ $catch }}" >
@endpush


@section('content')
<div class="overlay"></div>
<div class="search-overlay"></div>
<div id="content" class="main-content">
@php $slides = getContent(config('settings')->active_template, 'banner.element'); @endphp
	<div class="layout-px-spacing">
		<div class="layout-top-spacing">
			<div class="layout-spacing">
				<div class="widget widget-account-invoice-three">
					<div class="widget-heading">
						<div class="wallet-usr-info">
							<div class="usr-name">
								<img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" alt="admin-profile" class="img-fluid"/>
								<span>&nbsp;&nbsp;{{ $user->username }}</span>
							</div>
							<div class="add">
								<span><a style="color: white" onclick="recharge()" ><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg></a></span>
							</div>
						</div>
						<div class="wallet-balance">
							<p>Wallet Balance</p>
							<h5 class=""><span class="w-currency">{{ config('settings')->cur_sym }}</span>{{ showAmount($userBalance['main'],0) }}</h5>
						</div>
					</div>

					<div class="widget-amount">
						<div class="w-a-info funds-received riEarn">
							<span>Earning <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-up"><polyline points="18 15 12 9 6 15"></polyline></svg></span>
							<p>{{ config('settings')->cur_sym }}{{ showAmount($userBalance['income']) }}</p>
						</div>

						<div class="w-a-info funds-spent leEarn">
							<span>Cashback <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-chevron-down"><polyline points="6 9 12 15 18 9"></polyline></svg></span>
							<p>{{ config('settings')->cur_sym }}{{ showAmount($user->bonus_balance) }}</p>
						</div>
					</div>

					<div class="widget-content mBox">
						<div onclick="withdraw()" class="cmdBTN bills-stats " style="justify-content: center; display: flex;">
							<span style="width: 80%;">Withdraw Fund <div style="position: relative;float: right;"><iconify-icon width="20" height="20" icon="fa6-solid:money-check-dollar"></iconify-icon></div></span>
						</div>
						
						<div class="invoice-list">
							<div class="inv-action">
								<a data-href="{{ route('user.games') }}" class="linkBTN btn btn-outline-primary view-details"><span>Games</span> <iconify-icon width="20" height="20" icon="solar:gamepad-outline"></iconify-icon></a>
								<a onclick="giftCard()" class="cmdBTN btn btn-outline-primary pay-now"><span>Gifts</span> <iconify-icon width="20" height="20" style="color: #2196F3;" icon="nimbus:gift-card"></iconify-icon></a>
							</div>
						</div>
						<div class="swiper" style="height:90px;">
							<div class="swiper-wrapper" style="height:90px;">
								@foreach($slides as $slide)
								<img class="swiper-slide linkBTN" style="border-radius:8px;" data-href="{{ @$slide->data_values->url }}" src="{{ getImage( 'assets/images/frontend/banner/' .@$slide->data_values->image, '1300x250') }}" alt="one" />
								@endforeach
							</div>
						</div>
					</div>
				</div>
			</div>

			@if( config('settings')->app_link )
			<!-- download the app -->
			<div class="download-app" data-href="{{ config('settings')->app_link }}">
				<div>
					<iconify-icon width="50" icon="openmoji:android"></iconify-icon>
					<div>
						<p>Download the App</p>
					</div>
				</div>
				<button>Download</button>
			</div>
			<!-- end download the app -->
			@endif

			@if( config('settings')->reward_login > 0 )
				@if($today == 0)
				<div class="homenew mb-1" style="margin:-20px 20px 20px 20px !important">
					<a href="{{ route('user.home') }}?claim=1">
						<img src="{{ asset('users/jasper/img/earn-share.png') }}" alt="" width="100%" style="border-radius:8px;">
					</a>
				</div>
				@endif
			@endif
			
			<div class="layout-spacing">
				<div class="widget widget-table-one">
					<div class="widget-heading">
						<h5 class="">News updates</h5>
						<div class="task-action">
							<div class="dropdown">
								<a class="dropdown-toggle" role="button" id="pendingTask" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
									<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-more-horizontal"><circle cx="12" cy="12" r="1"></circle><circle cx="19" cy="12" r="1"></circle><circle cx="5" cy="12" r="1"></circle></svg>
								</a>

								<div class="dropdown-menu dropdown-menu-right" aria-labelledby="pendingTask" style="will-change: transform;">
								</div>
							</div>
						</div>
					</div>

					<div class="widget-content">
						@foreach($pages as $blog)
						<div class="transactions-list linkBTN " data-href="{{ route('user.page.blog', ['id' => $blog->data_values->slug]) }}">
							<div class="t-item">
								<div class="t-company-name">
									<div class="t-icon">
										<img class="icon" src="{{ getImage( 'assets/images/frontend/blogs/' .@$blog->data_values->image, '750x350') }}" alt="">
									</div>
									<div class="t-name">
										<h4>{{ $blog->data_values->title }}</h4>
										<p class="meta-date">{{ $blog->updated_at->format('d M Y') }}</p>
									</div>
								</div>
								<div class="t-rate rate-dec">
									<p><span>read</span></p>
									<p><iconify-icon width="15" height="15" icon="ep:d-arrow-right"></iconify-icon></p>
								</div>
							</div>
						</div>
						@endforeach


						@forelse($blogs as $blog)
						<div class="transactions-list linkBTN " data-href="{{ route('user.blog.page', ['id' => $blog->slug]) }}">
							<div class="t-item">
								<div class="t-company-name">
									<div class="t-icon">
										<img class="icon" src="{{ asset('assets') }}/{{ $blog->image }}" alt="">
									</div>
									<div class="t-name">
										<h4>{{ $blog->name }}</h4>
										<p class="meta-date">{{ $blog->updated_at->format('d M Y') }}</p>
									</div>
								</div>
								<div class="t-rate rate-dec">
									<p><span>read</span></p>
									<p><iconify-icon width="15" height="15" icon="ep:d-arrow-right"></iconify-icon></p>
								</div>
							</div>
						</div>
						@empty
						{{ $emptyMessage  }}
						@endforelse
					</div>
				</div>
			</div>
			
		</div>
	</div>
</div>

<div class="u-popup popView" id="noticeBoard">
	<uni-view data-v-a75f7a08="" data-v-b2a05bc2="" data-v-30282a05="" class="van-overlay"></uni-view>
    <div class="guize_html" style="width:100%;border-radius:24px 24px 0 0;">
		<div class="Ikdcls g_close"><iconify-icon class="beautiful-text" width="45" height="45" icon="carbon:close-filled"></iconify-icon></div>
        <span class="guize_html_nei">
			<p class="capCenter" style="margin-top: 25px;margin-bottom: 5px;">NOTIFICATION BOARD</p>
            {!! config('settings')->home_message !!}
			<br/>
			<a href="{{ config('settings')->telegram_url }}" class="social-channel telegram-bg text-white">
				Join our Official Telegram Group
			</a>
			<a href="{{ config('settings')->whatsapp_url }}" class="social-channel whatsapp-bg text-white">
				Join our Official Telegram Channel
			</a>
        </span>
    </div>
</div>
	
	@include($activeTemplate.'partials.recharge')
	@include($activeTemplate.'partials.withdraw')
	@include($activeTemplate.'partials.giftcard')

@endsection

@push('script')
<script type="text/javascript">
	var lastUpdate = "{{ strtotime(config('settings')->updated_at); }}";
	var lastView = localStorage.getItem('noticeDate');

	if( lastUpdate != lastView ){
        $("#noticeBoard").show();
		localStorage.setItem('noticeDate', lastUpdate);
	}

    const swiper = new Swiper('.swiper', {
        // Optional parameters
        direction: 'horizontal',
        loop: true,
        speed: 2000,
        autoplay: {
            delay: 1000,
        },
    });
</script>
@endpush