@extends($activeTemplate.'layouts.home')

@push('style')
<link rel="stylesheet" href="{{ asset('users/jasper/css/product.css') }}{{$catch}}" >
@endpush


@section('content')
<script>
    "use strict"

    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function() {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById(elementId).innerHTML = hours + "h " + minutes + "m " + seconds + "s ";
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "-";
            }
            tms--;
        }, 1000);
    }
</script>

<div class="wrapper">
<div data-v-af01384a="">
	<div id="home" data-v-c35495fc="" data-v-af01384a="" style="background:#f3f4f6;border-radius:0 0 8px 8px">
		<div class="bg" data-v-c35495fc="" style="height:18vmin"></div>
		<div class="main" data-v-c35495fc="">
			<div class="titleBar" data-v-c35495fc="">
				<div class="left" data-v-c35495fc="">
					<a data-href="{{ route('user.home')}}" data-v-c35495fc="" class="linkBTN text-white"><img class="van-badge__wrapper van-icon van-icon-arrow-left van-nav-bar__arrow" src="{{ asset('users/assets/trade/img/arrow-left-thin.svg') }}" style="width:38px" /></a>
				</div>
				<div class="right" data-v-c35495fc="" style="margin-top: -15px;margin-right: -.75rem;">
					<a data-href="{{ route('user.profile')}}" class="linkBTN right" data-v-c35495fc="" style=""><img src="{{getImage(imagePath()['logoIcon']['path'] .'/logo.png')}}{{$catch}}" alt="" data-v-c35495fc="" style="height:36px;height: 37px; border-radius:5px 0 0px 5px;width: auto;" /></a>
				</div>
			</div>
			<div data-v-af01384a="">
				<div id="team" data-v-c6f9d966="" data-v-af01384a="" class="">
					<div class="containerh" data-v-c6f9d966="">
						<div class="part2" data-v-385ac480="" data-v-c6f9d966="" style="margin-left:0px;">
							<div class="top_lv_VIEw" data-v-385ac480=""><i class="left_icon" data-v-385ac480=""></i><span data-v-385ac480="">System products</span></div>
							<div class="m" data-v-385ac480="" style="background: #FFF;margin-bottom: -10px;">
								<div class="item" data-v-385ac480=""><span data-v-385ac480="">Deposit balance</span><span data-v-385ac480="">{{ config('settings')->cur_sym }}{{ getAmount($user->balance) }}</span></div>
								<div href="" class="item rightItme" data-v-385ac480=""><span data-v-385ac480="">Earning balance</span><span data-v-385ac480="">{{ config('settings')->cur_sym }}{{ getAmount($user->income) }}</span></div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php $doKd = [2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0]; ?>

			<section class="containerh is-max-widescreen dapp" data-v-98c026d4="">
				<div class="isgrid apps" data-v-98c026d4="">
				
				@foreach($plans as $key => $plan)
				@php

					$buyLimit = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? config('settings')->buy_limit : $plan['buy_limit'];
					$limiBuy = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? config('settings')->limit_buy : $plan['limit_buy'];
					$buyLimitType = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? config('settings')->buy_limit_type : $plan['buy_limit_type'];

					if($buyLimitType) {
						$investment = \App\Models\Investment::where(['user_id' => auth()->user()->id, 'plan_id' => $plan['id']])->where('created_at', '>=', \Carbon\Carbon::now()->subHours(24))->count();
					}else {
						$investment = (config('settings')->buy_limit && $plan['escape_buy_limit'] != 1) ? \App\Models\Investment::where(['plan_id' => $plan['id']])->count() : \App\Models\Investment::where(['user_id' => auth()->user()->id, 'plan_id' => $plan['id']])->count();
					}

					$boughtCount = $investment;

					$statusLink = 0;
					$statusText = '';
					$statusUpcoming = 0;
					
					if(($plan['p_status'] == 'to_buy' && $boughtCount >= $limiBuy && $buyLimit) || $plan['purchased'] >= $plan['all_limit_buy']) {
						$statusClass = 'badge bg-danger';
						$statusText = 'Sold Out';
					}elseif($plan['p_status'] == 'trial' && $boughtCount >= $limiBuy || $plan['p_status'] == 'solid_out') {
						$statusClass = 'badge bg-danger';
						$statusText = 'Sold Out';
					}elseif($plan['p_status'] == 'coming') {
						$statusClass = 'badge bg-warning';
						$statusText = 'Upcoming';
						$statusUpcoming = 1;
					}else {
						$statusClass = 'badge bg-primary';
						$statusText = 'Available';
						$statusLink = 1;
					}

					$nextTime = \Carbon\Carbon::parse($plan['lock_endat']);
					@endphp

					@if($plan['p_status'] == 'coming')
					<script>
						createCountDown('counter<?php echo $plan['id']; ?>', {{ $nextTime->diffInSeconds() }});
					</script>
					@endif
					<div class="vite-card app-card relative" data-v-98c026d4="">
						<div class="bgs" style="background-image: linear-gradient(to bottom, rgba(81, 101, 148, 0.82), rgba(0, 0, 0, 0.83)),url({{ asset('assets/'.$plan['img']) }});"></div>
						<div class="apiLink linkBTN relative" data-v-98c026d4="" data-href="{{ route('user.product.view', ['id' => $plan['identifier']]) }}" data-name="$plan['identifier']">
							<div class="app-logo" data-v-98c026d4="">
								<figure class="image" data-v-98c026d4="">
									<img src="{{ asset('assets/'.$plan['img']) }}" alt="{{ $plan['name'] }}" data-v-98c026d4="">
								</figure>
								<span data-v-98c026d4="" class="tag" style="border:1px solid #FFF; color:#fff; background-color:#000000 !important;">{{ $plan['cur_sym'] }}{{ showAmount($plan['min_amount'],0) }}</span>
								<span data-v-98c026d4="" class="tag2 {{ $statusClass }}" style="">{{ $statusText }}</span>
							</div>
							<h5 class="app-name single" data-v-98c026d4="" style="color: #e5f2de;">{{ $plan['name'] }}</h5>
							<!--p class="app-intro injustify" data-v-98c026d4="">
								<span style="">{{ config('settings')->cur_sym }}{{showAmount($plan['capital'],2)}}</span>
								@if( 0 > @$plan['growth'] )
								<span class="text-small danger text-warning" style="display:inline-flex"><svg class="danger dark:text-white" height="20px" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19V5m0 14-4-4m4 4 4-4"></path></svg> {{ @$plan['growth'] }}%</span>
								@else
								<span class="text-small text-white" style="display:inline-flex"><svg class="text-blue-200 dark:text-white" height="20px" style="margin-top: 1px;" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v13m0-13 4 4m-4-4-4 4"/></svg> {{ @$plan['growth']}}%</span>
								@endif
							</p>
							<div class="truncate green">{!! $plan['notes'] !!}</div-->
								
							<p class="app-intro injustify" data-v-98c026d4="">
								<span class="text--small ">Daily Profit</span>
								<span class="text--small text-warning" style="display:inline-flex"> {{ $plan->cur_sym }}{{ showAmount($plan->interest_amount) }}</span>
							</p>
							<p class="app-intro injustify" data-v-98c026d4="">
								<span class="text--small ">Total Profit</span>
								<span class="text--small text-warning" style="display:inline-flex"> {{ $plan->cur_sym }}{{ showAmount($plan->interest_amount * $plan->total_return) }}</span>
							</p>
							<p class="app-intro injustify" data-v-98c026d4="">
								<span class="text--small ">Duration</span>
								<span class="text--small text-warning" style="display:inline-flex"> {{ $plan->total_return }} Days</span>
							</p>
						</div>

						<div class="linkBTN ikJbcs" data-href="{{ route('user.product.view', ['id' => $plan['identifier']]) }}" data-name="$plan['identifier']">
							<div></div>
							<div>
								<div></div>
								<div class="ekIksd">
									<div>
										@if($statusLink)<button id="btn-pay">More info</button> @else <button id="counter<?php echo $plan['id']; ?>">Sold Out</button> @endif
									</div>
									<div>
										<div role="button">
											<p>Share Value</p>
											<p>{{ $plan['cur_sym'] }}{{ showAmount($plan['min_amount'],$doKd[$key]) }}</p>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					@endforeach
				</div>
			</section>
		</div>
	</div>
</div>
</div>
@endsection

@push('script')

@endpush