<?php $user = auth()->user(); ?>
@extends($activeTemplate.'layouts.home')

@push('style')
	<link rel="stylesheet" href="{{ asset('users/jasper/css/recharge.css') }}{{$catch}}" >
	<link rel="stylesheet" href="{{ asset('users/jasper/css/profile.css') }}{{$catch}}" >
@endpush

@section('content')
<div class="bg-red"></div>

<div id="app" data-v-app="">
    <div data-v-af01384a="">
        <div id="userCenter" data-v-e65b4284="" data-v-af01384a="" class="">
            <div class="titleBar" data-v-400f8df7="" data-v-e65b4284="" style="background-color: transparent; z-index: 10;">
                <div class="back" data-v-400f8df7=""><a data-href="{{ route('user.home')}}" data-v-c35495fc="" class="linkBTN text-white"><img class="van-badge__wrapper van-icon van-icon-arrow-left van-nav-bar__arrow" src="{{ asset('users/assets/trade/img/arrow-left-thin.svg') }}" style="width:38px" /></a></div>
                <div class="title" data-v-400f8df7="" style="color: rgb(255, 255, 255);"></div>
                <div class="right" data-v-400f8df7="">
                    <div class="rightBtn" data-v-e65b4284=""><a data-href="{{ route('user.online.support') }}" class="linkBTN"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAAAXNSR0IArs4c6QAABLBJREFUaEPtWm3EnmUYPg760Y9+lBr9aDRFxVKxsYgtikY/moqiWLasKVpEY6WNUVGUokUpKpPKNo02oqX9iC0tlaRRqSyKxvoRxZEj5/W43vu9n/u+7o/Hazwnr9fe+/o4j/P7PK8RZznxLOcfowCQdC6AtQDWAbgWwOUALgJwfgjoRwC/AfgawFEAR0j+NIbwBgGQdA2AbQDuAHBeR4YMZA+Ad0j+23HvZHkvAJKuAPA0gNv6Xpzts3YeJ/l2n7M6AZB0DoDHfCEAm02VjoeJfAfgJIAk2YsBXAZgFYCbpmjrCIB7SP7aBUgxAEk2kX3BQH6HbfvZMIVf2i4PIdwK4MGas/6wOZL8pO2c9L0IgCRL8GMAV2YH/xWaeIXk36UX5uskrQHwYmgmfbLW7iL5fsmZrQBC8scqzNtU7iRp+x1EoZEdIQybqMkgrIkDbYc3AojDP6yo+j0Adw+JHHVMSXIkezPzLWt4DclvmkC0AbBkdmcHzIT5dL4k+4b9LGnCeWN1k4lOBSDJ9v5FJhGbzfVjS74qXUlbIj+kT7tJPjFNC00ALIkU563Oq8ew+Tab9ndJ70ZyTP5wFUmH5UVUC0CSywFLP9GjJJ8ruXyMNZIuAfBVVoo8T/KRLgBeB7AxNjjOr+gbKvsCkvQkgJ2x32F6GUlbwgJapIEozH7PsuV2ks/0ZaTvvsg9P2cOvZnkayUAbgHg0JloOcnWDNuX0aZ9knI/3E9yQwmApwBsj4UnSF43C+ZKzpT0AICXY+1pkheUAPgAgOOxaarzlDAwdI2kleHMU62hzge+j4bEm7aSdM2+JBSVwD/Z5TeSdNU6oToAf2bhaz3JQ0vCfVwq6QcAl8Y/7yX5VhsAZQscxvKCzT7x5awASbow6q6813Dj5GrYdB/JN7oAqOP1YBRzi2LyEGBRQrivaGpNRwFgPg+RXD+E4XyvpNsBuFBso84AXJefAGBpu7hLqvRFLuw+a7ux5Lskly0uX0zOur7Tvx2FPN1I1BnA/SRf9e7I0N9mDrWN5AslDDatiYbpTLZmA8n9cafNydk4jWc6A1gQtiS5rfTsx7ST5K4RADjCONIkct01CRyVKDQHMNdA1eQkzU1ogVAk5Zl47sRtUWpuQjVO5fI1zWU8HZuM+CQ5kaXx4iiNviQnKVfAidal2WiU06eybFyUBz4FcEOcdtp1T6R1M+5ZZqKbSX7UZiIl3yvJygNen+tSwtNslxOJJlk6/aGuH/AsyL1oEx0nubqEuZI1NcOsum21k4lpc6GHY2SeTCk/0OM+S9/jltFIUt6L1527h+TW6oemyZwTjMtc/3ZR5cnE5wAOzmq8GD3wJgAPZX5oni0sTwZtXguodbw+mohbDor3Ng/TNleaGpfy1nht6T46gIgc1lz+GGKtWXv/U5TQfmdzD2BH9Swq9b05VM9D7bg221qaBYC9fmGp3ObGyBJ0Q5Q/v07jyw77EoBddePEfNOoAGIc6Ljdl+xnbqD8bFUUJJYagJ3SmvHPYZJ+g+hEowII+/Yo0CPBnJJJ+LnITumO6yRJJ8pBNDqAAOG3YM/4Ex2d9kAxiHtgnP8rMZSJIftnooEhDHXd+x9T8ixPGevu9QAAAABJRU5ErkJggg==" alt="" data-v-e65b4284=""></a></div>
                </div>
            </div>
            <div class="bg" data-v-e65b4284="">
                <img src="{{ asset('users/assets/trade/img/icon02.24521036.png') }}" alt="" class="icon01" data-v-e65b4284="">
                <img src="{{ asset('users/assets/trade/img/icon03.cd95d11a.png') }}" alt="" class="icon02" data-v-e65b4284="">
            </div>

            <div class="containered" data-v-e65b4284="">
                <div class="part1" data-v-71254db0="" data-v-e65b4284="">
                    <a class="linkBTN" data-href="{{ route('user.home')}}"><img src="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" style="border-radius: 50%;" alt="" data-v-71254db0=""></a>
                    <div class="left" data-v-71254db0="">
                        <div class="p1" data-v-71254db0="">{{ $user->username }}</div>
                        <div class="p2" data-v-71254db0=""><span data-v-71254db0="">ID:{{ $user->id }}</span></div>
                    </div>
                </div>
                <div class="part2" data-v-fd62a59a="" data-v-e65b4284="">
                    <div class="left" data-v-fd62a59a="">
                        <p data-v-fd62a59a="">Interest balance</p>
                        <p data-v-fd62a59a="">{{ config('settings')->cur_sym }}{{ getAmount($userBalance['income']) }}</p>
                    </div>

                    <div class="right" data-v-fd62a59a="">
						<a onclick="recharge()" class="cmdBTN btn btn-1 btn2" data-v-fd62a59a="">
							<iconify-icon width="20" height="20" icon="fa6-solid:money-check-dollar"></iconify-icon>
							<span>&nbsp;&nbsp;&nbsp;Topup&nbsp;&nbsp;&nbsp;</span>
						</a>

						<a onclick="withdraw()" class="cmdBTN btn btn-2" data-v-fd62a59a="">
							<iconify-icon width="20" height="20" icon="uil:money-withdraw"></iconify-icon>
							<span>Withdraw</span>
						</a>
                    </div>
                </div>
            </div>
			
			<div class="my-container my">
				<div class="layout-px-spacing">
					<div class="layout-top-spacing">
						<div class="layout-spacing">
							<div class="widget widget-table-one" style="padding: 0 15px;background:transparent;margin-top: 10px;">
								<div class="widget-content">
									<div class="transactions-list">
										<div class="t-item">
											<div class="t-company-name">
												<div class="t-icon">
													<div class="icon">
														<svg xmlns="http://www.w3.org/2000/svg" style="width:34px;height:34px" viewBox="0 0 50 50">
															<path fill="#f0d5a8" d="M20.45 13s-.69-2.29 1.09-6.1s5.05-4.68 6.92-3.72a3.17 3.17 0 0 1 1.73 3.2s3.53-.76 4.06 2.08s-1.25 3.89-3.54 4a5.83 5.83 0 0 0-3.55 1.34Z" />
															<path fill="#f7e5c6" d="M30.19 6.42a3.17 3.17 0 0 0-1.73-3.2c-1.83-.94-5.07 0-6.81 3.49c1.22-1.16 2.64-1.91 4-1.52c2.35.69 2.19 2.05 2.19 2.05a5.7 5.7 0 0 1 4.28.69a4.49 4.49 0 0 1 2 2.73a3.69 3.69 0 0 0 .14-2.16c-.54-2.84-4.07-2.08-4.07-2.08" />
															<path fill="none" stroke="#306cfe" stroke-linecap="round" stroke-linejoin="round" d="M20.45 13s-.69-2.29 1.09-6.1s5.05-4.68 6.92-3.72a3.17 3.17 0 0 1 1.73 3.2s3.53-.76 4.06 2.08s-1.25 3.89-3.54 4a5.83 5.83 0 0 0-3.55 1.34Z" />
															<path fill="#bf8256" stroke="#306cfe" stroke-linecap="round" stroke-linejoin="round" d="M29.34 14.65c0 1.66-2.39 3.8-5.34 3.8s-5.34-2.14-5.34-3.8s2.39-2.24 5.34-2.24s5.34.59 5.34 2.24" />
															<path fill="#306cfe" d="M7.81 45.06a16.19 1.94 0 1 0 32.38 0a16.19 1.94 0 1 0-32.38 0" opacity="0.15" />
															<path fill="#f0d5a8" d="M37.22 43a2.08 2.08 0 0 0 1.5-2l-.63-13.18c-.33-6.96-6.54-12.39-14.09-12.39S10.25 20.86 9.92 27.74l-.64 13.18a2.08 2.08 0 0 0 1.51 2a42.78 42.78 0 0 0 26.43.08" />
															<path fill="#f7e5c6" d="m38.24 30.88l-.15-3.14c-.33-6.88-6.54-12.31-14.09-12.31S10.25 20.86 9.92 27.74l-.15 3.14c.9-6.36 7.09-11.22 14.23-11.22s13.34 4.86 14.24 11.22" />
															<path fill="none" stroke="#306cfe" stroke-linecap="round" stroke-linejoin="round" d="M37.22 43a2.08 2.08 0 0 0 1.5-2l-.63-13.18c-.33-6.96-6.54-12.39-14.09-12.39S10.25 20.86 9.92 27.74l-.64 13.18a2.08 2.08 0 0 0 1.51 2a42.78 42.78 0 0 0 26.43.08" />
															<path fill="none" stroke="#306cfe" stroke-linecap="round" stroke-linejoin="round" d="M20.2 20.61c0-2.86 1.7-5.18 3.8-5.18s3.81 2.32 3.81 5.18" />
															<path fill="#ff87af" stroke="#306cfe" stroke-linecap="round" stroke-linejoin="round" d="M30.19 6.42a7.83 7.83 0 0 0-4.37 2.34" />
															<path fill="#306cfe" d="M23.35 36.65v-3.43l-1.48-.48a6 6 0 0 1-1.52-.74a3.2 3.2 0 0 1-1-1.13a3.51 3.51 0 0 1-.39-1.73a4.42 4.42 0 0 1 2.19-3.88a5.45 5.45 0 0 1 2.23-.74v-1.17a.47.47 0 0 1 .54-.43c.25 0 .4.08.46.23a2.11 2.11 0 0 1 .09.74v.63a6.6 6.6 0 0 1 2.43.54a1.58 1.58 0 0 1 .78 2.55a1.23 1.23 0 0 1-1 .45a3.2 3.2 0 0 1-1.08-.26a4.84 4.84 0 0 0-1.14-.3v2.74a17.42 17.42 0 0 1 2.36.83a4.17 4.17 0 0 1 1.62 1.33a3.9 3.9 0 0 1 .69 2.43a4.66 4.66 0 0 1-.36 1.85a4.21 4.21 0 0 1-1 1.45a4.9 4.9 0 0 1-1.5 1a5.53 5.53 0 0 1-1.8.44v1.16a.63.63 0 0 1-.15.33a.5.5 0 0 1-.38.13c-.25 0-.4-.08-.47-.24a2.25 2.25 0 0 1-.09-.72v-.64a11.69 11.69 0 0 1-2-.23a4.56 4.56 0 0 1-1.74-.72a1.54 1.54 0 0 1-.73-1.31a1.5 1.5 0 0 1 .38-1a1.27 1.27 0 0 1 1-.42a5.16 5.16 0 0 1 1.49.36a8.17 8.17 0 0 0 1.57.38m0-6.76v-2.35a1.61 1.61 0 0 0-.78.46a1.12 1.12 0 0 0-.31.79a.8.8 0 0 0 .27.63a2.86 2.86 0 0 0 .82.47m1.11 3.67v3a1.72 1.72 0 0 0 1-.6a1.66 1.66 0 0 0 .36-1.06c-.03-.59-.47-1.04-1.36-1.34" />
														</svg>
													</div>
												</div>
												<div class="t-name">
													<h4>{{ config('settings')->cur_sym }}{{ getAmount($todayIncome) }}</h4>
													<p class="meta-date">Today Profit</p>
												</div>
											</div>
											<div class="t-company-name">
												<div class="t-icon">
													<div class="icon">
														<svg xmlns="http://www.w3.org/2000/svg" style="width:34px;height:34px" viewBox="0 0 50 50">
															<g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
																<path stroke="#344054" d="M27.667 14.583s5.979-.479 8.5 1.188a7.38 7.38 0 0 0 5.5.896" />
																<path stroke="#306cfe" d="m27.667 14.583l1.062-5.875a2.082 2.082 0 0 0-2.062-2.458h-7.5a2.083 2.083 0 0 0-2.084 2.458l1.084 5.875zm-4.75 29.167a30 30 0 0 0 8.729-1.187a8.33 8.33 0 0 0 5.854-7.959a14.3 14.3 0 0 0-1.5-6.25l-6.25-12.5a2.08 2.08 0 0 0-1.875-1.146h-9.917a2.08 2.08 0 0 0-1.875 1.146l-6.25 12.5a14.3 14.3 0 0 0-1.5 6.25v0a8.33 8.33 0 0 0 5.855 7.959a30 30 0 0 0 8.729 1.187" />
															</g>
														</svg>
													</div>
												</div>
												<div class="t-name">
													<h4>{{ config('settings')->cur_sym }}{{ getAmount($referralIncome) }}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h4>
													<p class="meta-date">Total Profit&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>
												</div>
											</div>
										</div>
									</div>

									<div class="transactions-list ">
										<div class="t-item">
											<div class="t-company-name">
												<div class="t-icon">
													<div class="icon">
														<svg xmlns="http://www.w3.org/2000/svg" style="width:34px;height:34px" viewBox="0 0 24 24">
															<g fill="none">
																<path fill="#2196F3" fill-opacity="0.25" d="M15 13h6v4h-6zm5-6V4H5.5a2.5 2.5 0 0 0 0 5H18z" />
																<path stroke="#2196F3" stroke-width="1.2" d="M3 6.5A2.5 2.5 0 0 1 5.5 4h13.786c.2 0 .299 0 .38.028a.5.5 0 0 1 .306.307c.028.08.028.18.028.38c0 1.196 0 1.795-.168 2.276a3 3 0 0 1-1.841 1.84C17.51 9 16.91 9 15.714 9H15M3 6.5A2.5 2.5 0 0 0 5.5 9H19c.943 0 1.414 0 1.707.293C21 9.586 21 10.057 21 11v2M3 6.5V17c0 1.886 0 2.828.586 3.414C4.172 21 5.114 21 7 21h12c.943 0 1.414 0 1.707-.293C21 20.414 21 19.943 21 19v-2m0 0h-4c-.943 0-1.414 0-1.707-.293C15 16.414 15 15.943 15 15c0-.943 0-1.414.293-1.707C15.586 13 16.057 13 17 13h4m0 4v-4" />
															</g>
														</svg>
													</div>
												</div>
												<div class="t-name">
													<h4>{{ config('settings')->cur_sym }}{{ getAmount($totalInvest) }}</h4>
													<p class="meta-date">Total Assets</p>
												</div>
											</div>
											<div class="t-company-name">
												<div class="t-icon">
													<div class="icon">
														<svg xmlns="http://www.w3.org/2000/svg" style="width:34px;height:34px" viewBox="0 0 50 50">
															<g fill="none" stroke-linecap="round" stroke-linejoin="round" stroke-width="2">
																<path stroke="#344054" d="m35.854 18.75l3.73-5.333l-10.23-7.167l-8.77 12.5zM18.938 8.333L11.625 18.75h8.958L25 12.5z" />
																<path stroke="#306cfe" d="M41.667 18.75H8.333c-1.15 0-2.083.933-2.083 2.083v20.834c0 1.15.933 2.083 2.083 2.083h33.334c1.15 0 2.083-.933 2.083-2.083V20.833c0-1.15-.933-2.083-2.083-2.083" />
																<path stroke="#344054" d="M33.333 27.083H43.75v8.334H33.333a2.083 2.083 0 0 1-2.083-2.084v-4.166a2.084 2.084 0 0 1 2.083-2.084" />
															</g>
														</svg>
													</div>
												</div>
												<div class="t-name">
													<h4>{{ config('settings')->cur_sym }}{{ getAmount($userBalance['main']) }}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</h4>
													<p class="meta-date">Topups&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p>
												</div>
											</div>
										</div>
									</div>

								</div>
							</div>
						</div>
					</div>
				</div>
					
				<div class="part4" data-v-312d477d="" data-v-e65b4284="">
					<div class="go" data-v-312d477d="">

						<a onclick="cPassword()" class="cmdBTN item" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAsCAYAAAAehFoBAAAAAXNSR0IArs4c6QAAA5RJREFUWEftmEFIFFEYx79vZrIVPBh4UPIQVCALubPvdUjqYJZE0MGgY5GC0cVDh42ICo08FHXpIAQpdAgKKuoSGYQJCQk1bwdZtCBIsIMHBSFhZXHmiyc7NsjuzJvdVbF2ru977/u9//vm+773EHbYhzuMF6rAm31ilVbYYIwlAKAFEQ3XdZcdx8lMTU19r9RGKgLMOd8PACkiOo+IdQXgfhHRI9d1h2zbXioHvmzgZDJ5TdO0AQCIKYDME1G3EOK9gm1Bk3KADc75MwA4V4LzK5ZlPSxhXulZgjF2HxFTG5yOE9GI67oTuVxuRdf1+pqamlNE1IeIB/y2juOcsW37bVTokhROJpMnNE374DkjomUi6kmn0y+LAMjT6AeAm77xBcdxDkaN6ZKAOedpADDzzlcdx+m0bXs8TC3GWD8iynhf+4jogRDiatg8/3hkYNM0TV3XJXBJThljXxDxcH76gmVZTQCwqgodGXiDStJRk2VZC6oOTdPs0nX9tW/DbUKISdX5kYE55y+8zEBEk0KINlVn0i4ej9fV1tb+9gH3CSGGVNcoBfgjALTnY/CpEOKCqjPPjnM+BwDN+TUGhBC3VdcoF/iJEKJH1Zlnxxj7iYj7qsCFlOOc+0OiqnBYeP2bMZxIJPbqup5CRJkdWrzOTJZkAFDOwZ56iCgzhJH/6WS7mUHEN4uLi0Ozs7MrQSqHKmya5lFN00aL9LlhJxh1/Fs2mz0+PT09X2xiIHA8Hm+MxWIziFgf1XOp9mHFKBCYc37H32HJxRBRtpCBxxYRVorR5eVlOdd13c50Or3eDfrXCwRmjH1GxCP5WItchlXBOecNRCSLiXe9umtZ1vVC88OA1ysSAAxalnVLFSKqHWPsEyIey4tTNL8rAxNRpJofFVi1IFWBoyrr6+CUSv7/pzD1dvQTQgqg4ANKAcFpGQEG8fHYPf/glsWw29uRBUSVR5S/fERL2vDYnu0BvtQxB7DWG6h/RBlteOzQtgDnutvNXYZ2EVTLN9FSjtyR3SPjmW0BVpc12LLiMbwjKt2GXX/NX+mVHz1U1W9tbW02DEN2hWu9RFBVDcvDNxBx0HNMRD8AYEIVRNEuhognAaDB56fo40ogsGma9bquzwBAo6Lzss2IaFQIcbrYQio3DvmW9m6LoOXpnQ16+goFljuVSiPiZXmnw6hFQkFzIpL3uldCiOdhD4NKwAo+t8ykCrzZUv8B7Cc6S11cG1EAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
								<span data-v-312d477d="">Change password</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>
						
						<a onclick="setpin()" class="cmdBTN item" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAsCAYAAAAehFoBAAAAAXNSR0IArs4c6QAABYVJREFUWEftmGtsFFUUx8+ZmdJVS8UULTE1AV3RrGV35l41qEReSlAxxqCER4wIhKgIoqJ+EL9oJCYqETWIr2IIVhv5YFRIVLSIRuPj3tudFkgNkMb4RiC0qdl2Z+aYu5lNNqXdx7BoSDqfduaec+5v//ecM/cOwhl24RnGC6PAp3vFRhUeVXiIAlVPCcbYEkR8Uc8TBMFqpdR71VS9qsCpVGqOZVm7AMAMIf0gCOYqpXZXC7pqwMlkcpJlWQIRzyuEI6LjQRCwjo6OnmpAVwW4qanprMbGxm8AwA6hngbI9fj14b06evTotT09PZlTha4KMOe8FQAWhTA7hRC36t+MsV2IODd83iqEWPK/A3POHwSAXJER0SFE5EKIE/retu1xpmkKALhY3/u+v7ajo2PTqUAPqzBj7FEAWAoAnb7vb0yn098PN4njONMNw9AFZQHAP0R0jZTSLbR1HCdlGIZOl7MBwAuC4Aal1JfDxUulUlebpvkwAExBxK1CiOeH2p0EbNv2jaZpfjqkcH4golf6+vraDh48OKDHkslkk2VZEhHPD1vYYqXUu8OBhK1ue7gKRzzPY67r/qLv4/F4bV1d3ULDMFYh4lVD/GcJIdoLn50EzBh7ABFfHmHZ/iaiFs/zWizL2o6IV4YQm6SUa4stNedcp8Ka0P5H3/eXmKa5HBGXAcD44XyDILhPKbWlKHAqlZppWdYXodEWIjoHABYgYu1wQYlor5Rytl7uErlpMcbaEXHaCHEGELFNpxYA3KttPM+blU6niyscj8fr6+vrjyOiQURvSynvaW5ubqypqVlpGMb9ADAhPyER/eZ5nuO67l/lFFIikZgQi8V0r76wwP6PIAg2+77/mo7DGNuKiEuJKOjv7x/X3d3dV1RhPcgYO4CIlwNAlxBiSt4hkUiMicViWm3dwrLZbHa967pd5cDmbZLJZLNlWRsQ0SSi1kwm8/7+/fsH8+Occx3vCiI6IKVMlCy6EHgbIt6lO1E2mz3Xdd3+SqCi2iYSibpYLHZCry4AbBNC3F0WsOM4qw3DeCms/ulKqb1RISrxC9vknnDeNUqpk4p/pD48FRG/DR0fUUptrGTiqLa2ba8zTfM57Z/NZqe6rvtdWQpPnDgx1tDQoJPdIqI2KeXCqBCV+DHG2hBxAREN9vb21ud7fsmi0wacc/1KZQBwWAhxSSUTR7XlnB8GgElEJKSUuR5flsIh8Kv5fpjJZBr27dt3LCpIOX6TJ08eP3bs2CPalog2SylXVQRs2/YK0zTfCAPMlVJ+Us7EUW0cx7nJMAy9+dcnleVKqZaKgBljSURMh8DrpZTPRIUpx49z/iQAPKVtBwcHk52dnZ0VAetjDue8V++yiOhDKeVthQFo5cxbAsI7yoEZamMg7cDX23cWPmeMfYSI84ioX0pZr4WuFFgX3tcAcB0R/S6lLHydQrBidjsgzIgCDAR7jDc/nzkE+E9EvICIvpJSXj9S3KInDsbYRkR8SDt7nteUTqd/zQfKLpsxzTLN5VGAPd9/q6ZljxYjdzU3N19UW1v7c5i/Lyil1kUCtm17sWma74TOtwshPogCWMrHcZz5hmHsCIEXFfs0UFRh27YvNU3zp7DwNkgpnyg1eZRxzvmzAPC49h0YGIh3dXUdiqSwdmKM6a3mOAD4TAgxJwpQKR/G2G5E1HvqY0KIhmL2JU/NnHNdzTfr1yUiJoQQI/77UmDDjSeTycssy3IRcQwRfSylzJ24IyvsOI4+b+XOakSkN+q55l6Ni4jQMIx5AJBTNQiCO5VSuVyODBymxQ5EnF8NyJFiBEHQqpQq+d2iZEqEExiO4zyGiPrQGK8yeDcRbZFS6kMqlYpdLnCpOP/Z+Cjw6ZZ6VOFRhYcocMalxL+HFzZL5CkpQwAAAABJRU5ErkJggg==" alt="" data-v-312d477d="">
								<span data-v-312d477d="">Set Security Pin</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>
						
						<a data-href="{{ route('user.transaction.type', ['type' => 'income']) }}" class="item linkBTN" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAsCAYAAAAehFoBAAAAAXNSR0IArs4c6QAAA3VJREFUWEftmEFoE0EUht/bRolQRBoFDx4itCBFcTPrwYNCbRUVClKISA9C1QQvgopHC7ZID4JgpQiFVuxB8FBERYQerC4o6GWmG1AQeglYbxYD5lB0d57Mmg1J23S7Idk0kLkk7My8+eafN2/mDUKTFWwyXmgB13vF1iis6/o5TdNSiNhe78E3sk9EeUSc5Jy/KW1XBmwYxl0AGG4k6OqxiWhYCDHmfS8C67oeb2trWwSACACYRGQ2GPwoIp4BANtxnC7LsrKKpwjMGBtCxCdElBNC7FENGwwcYYz9Uq5JRBeFEE8rAWeFEPsbDOsObxgGqV8iuiSEmPEF7u7ubo9GoxMA0BPCBNSKzgkhbnqrGxjYMIzrADAeAmxxCCllcmFh4XlVCjPGrqrQEiYwEZ0VQsxVBawiBmPsNgDcQMRdBX/6jIgrtZgEEUUQ8VjB1hIA3OecP/Rsb+gSiUQiqWnarPIf27b1TCbz1evIGPtdOEimOefpWsCW2H6AiDcA4Avn/FDJ99OI6CrtOM6AZVkvyzZdPB6PxmIxFYf3eTMmIje0IWK8oO6IEGK0xsBuOFVCEZFSWY2nzoIix/Lyclc2m3VXteykSyQSRzRNe1HSuIyNiOoJvJ4OS7ZtD2YymY9e5Zq7hFK6o6PjJADsLjb6r4CKh3UFVvHWG1NKmcvlcnOeshWB15tmifMXgel8Tzvs1GKB3WMb2Dj57keJr3ouAZxz3+uub4NV4aUILNN9HwDA2+GBuBFkEqfeu7HWuxKo/1sWWEpnIPLYdHd9aMA01BMFgL2BpFWNI2DjtOlGg1CBA4NW6BCawk0HTJdPHAbU9MDgGtiQc17hrJkP1SVkqncREDsDA6vTiuAaTs8/ChWY0r0TBNBfBfCK/VcObp8xrVCBqwBdt0tr01U66ZpOYUr1XZFIwY9mAvuPLcd2zJhu2h6aS8h073cA9O6sgQRHlcFMzbuZRWjAlOq7AAjqoSNgoTzk5Sg+M3+GChyQsmLz0BRuAdf7PrylFfbSfCIaLzwl1YpXRYk7iDiiDNYs42CMvUbEfvXIDADqUc7d4TUoBxAxqa71RPRWCHHKz+amcjrGWCcifirNpP0MB6lXQkgpj1uW5V6INiqbAlYG1IO3pmm3EPGgn9GA9d8cx7nnPVj79d00sJ+hsOpbwPVWuukU/gemzGFLpZcJCwAAAABJRU5ErkJggg==" alt="" data-v-312d477d="">
								<span data-v-312d477d="">Earning Record</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>

						<?php if( empty($user->payment_set) ) { ?>
						<a data-href="{{ route('user.account-setup') }}" class="linkBTN item" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAsCAYAAAAehFoBAAAAAXNSR0IArs4c6QAABClJREFUWEftmE9oXFUUxr9z37w4iyg1NNBFhXERDEMzzh+Elkb6kioobgQtCiqNTYKCG0VBhIq6ECJ256aQSRvBRSFZCLpwUZMHphih72VMMUoJJNAuXDRQSRejM+99ch+TcZJJMm9mMpMWc9fnnvs73z3v3POO4AFb8oDxomlgDllRKHkBojqh/OsyPvtbK0VoCpjnBp6gkqsQOVqGJJdFcAUep+XS7K97Dd8UsD8yeAMixwAUQd6DyKFNgC2ArxuYZ6xOPCJPQjFGGN9oQM/znjUv2VcL56z+iFIvUfAyUKG6NiKXCXyvyGmZmL3WqPJ1AXPk9DDBC5uVZFGA8yjSxgodse2ihqkBf5vAdCPwoYE5PHCSSs3tqgyZB2ReQBtCGwX+IpN2vha8ABex7H+xEexuZ4QHHh28TMgQwFUp+AMF4JBhquMKOEXCgsiRqoM2BzCPu7xWfBjJ7dKGZNbIzozWSpXQwP7o4AogMSHHJDvz0VbHHLJ6fVNZpQD6N1WO/0pIMbgB38vKhP11oLxhvEPgVW0ivtcjE/Zy0wpzyIrRNFaCD8z3njcn7B9qKaH3eEpZhoFTBCwdbOUeIc9LduZzWlaEPUYhrO9QCnP49FkqTOryJXe9R2XKvlcLeJsbCAJQSs5CYIHMy19+t04RwzB+0vbFgpfqmLRzzStczl/k1PiPqXphK+0rb6tI74QJ9QpF3tVlT2Vnemr53lbhdDr9loi8TTJ4CDpEOkSgfNIrEMH1NbpEoJ09pPf/Q/5tQswdfM/n8/n3lpaW/tyUSlsPTqVS7yulLjQKtMf7bMdxBnYFzmQytwAEvQHJ1T0GCOvusIh0auP19fXumzdv3tnYWJUSmUyGJdg513WfDnvCXtql0+nLIrrmB8/+47lcrizcjsAAqq5jL6F283UA3GqlDxT+XyicTCZPKqV0kxPbKFm7BN4LIOj+2l4lYrFYtKura1xEXm/kZtoOnEqlxpVSI43Atl3hRCJxzDTNGxWwFwF87DhO+eXaLpB9qxKpVOpDpdRYCSrnOE6oTm/fgCsPJjnpuu6bYVJjP4E/EZFPS73JvOu6J+534OMi8nMF5Nja2tpnq6ur+fu2l8hkMlOAHqyUV5Hk7RpKl9vLtpe1eDzeGY1Gp0TkuTDpsNWm7cAbAMlk8kXDMF4DcDgE+P69dCHgqkzqrRL6JzNC8rrruk81cmCze+oF1i+THqHqL/mxWq9Ss3BNv3TpdPpLEfmgVDu/dV33TDD/beOqS+F4PH4kGo3+LqXhNIOhtEwD+KNdzCRHRKQ/VPOjjZLJpKWU+i5E39rqGO44jtNdeciOs7W+vr5e0zS/EpFnWk21g/+i7/tvLCwsXAkFvGGUSCSORiIR/RFWz39bFAnJvOd5c4uLi1UvYqjpZYu4GnJ7ANyQbHVs+hfJyZBLH7VbIAAAAABJRU5ErkJggg==" alt="" data-v-312d477d="">
								<span data-v-312d477d="">Set bank</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>
						<?php }else{ ?>
						<a data-href="{{ route('user.games') }}" class="linkBTN item" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,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" alt="" data-v-312d477d="">
								<span data-v-312d477d="">Play games</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>
						<?php } ?>

						<a onclick="giftCard()" class="cmdBTN item" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAsCAYAAAAehFoBAAAAAXNSR0IArs4c6QAABKJJREFUWEftl12IG1UUx//nTnZNWT/qbv14qGWlChV3S9K0iEghTSxYaB+KXxUsrDSpFCx9KYgooohPKggqrSarqxSkH+KDgj40aaQPCmt2stsIpazaWsVWVyx0t92amfOXyXZKmmbTSDNCIfMyydx7z/3lP/97co7gOrvkOuNFBzjoN9ZRuKNwnQIdS3QscTVLDAwM3OHNMcbQu1uWVb3PzMzw2LFjU/76wcHBW0l2B61ouVw+XbvHZR6ORqMZEXlCRC49J+l/dkh+Ztt2KhqNPgxgrzGmK0hgklTVfaVSKe3vcxlwLBb7CcASVT1fC+1NFhGLZNiDFpH1IhIiec4buhis3QeYIrKA5ImxsbGl8wKT7FXVuOu6J1S1CuG6roTD4WWWZX0F4Ka5R+7Ls7Oz7/f09FTnnD179pLYvp2aqe9brX6OvzYUCi0RkW8A/HVVYMdxohMTEz/XB4tGoyuNMXlVfc+27Reu1Q7cmliKv/W07C9M18davnz53aFQyL4mYC+oF6jRj6nfkE/FF6FHHgLwq2QPFevHzw/F+28IGVuANyWbfz0w4FZUZXrNo6TsgUh4br4elDPc6CvJx+M38hbrMMBljurq7g8L3wcGHIvFHnAcZ3p8fPyHRvBzMOakiJSg7nbXmJUGkhHyFV9JN534SCBDQqQkmxtuFKctlujv7w/39fV5p2uyWCze12ijSioet8Q65Kq7rmu48HVV31TyWwimTSa3lluTz5LYLeCIZPLPzPfG2gLsBY/FYjtU9Tfbtg80VDgVX0yxTpLcbWXz25hecz8h3wmRrUD3hsQcBqQsFfdBGSnMBg7cmocT7xDyHMgpiCwCecaBrguJ2Q8gfKGiqxaMFI43i9UWhT1L9Pb2HgFQHhsb29hsQyeVfNoSJEGeukAd7jayCzBxV90NvlX+F+C+vr5RkpNXA66FYTrxBiE7Lx68V5laE6uOT3JcCgUnsEPXih2uyMdeioM5IMCXqLhphqwvIFg5N49H/1HdEB4uTAaW1lasWPEiyVO2bTdMR7UbXxiKL+vqMqMgTomjq7TL7BJgvVK3gZg2YnZBpOxlj0CAa9La0WKxONhM8Wo+XmhGASx2Krq6e6RQ0lTid4EclGxuc1XfdOI1Ql4ymdwVhVNbDp23iVdPkJwqlUpNT7mmEvsh8pgSm0PZ3J65fJw4AsisOO5qHIfDe71iihGTyd8WiMKtepjp5A4Cbwv4rmTy2/11zpbkJmPwKcApEA5E7hRip2RzbwUGPDAwsLRcLv/YDF7TycPiAU26a+uzQGVL/BFLzBZAwgp8HMrmGv4BtcUSnh1EJE+yaXnJoXg/ZjDVqGxs9S39J2C/gK8NblnWPcaYgyJys1fAq+rzJOfNFF7R3/QtXGwO6uf468Lh8F3GmEIr9fASAOdrWp9qzJoW6RMR2eR9B3COpGlVtSbzqo1u3eW3SL/M23FEIpEPjDFPek1zgwBK8nPbtoei0WgSwD4RCbprVlXdWyqVtvo8jfLf7Y2U8How27b/9McikchCVQ0aGBMTE3/U8rS7022DO5qH6AAHLXFH4Y7CdQp0LNGxxPVuiX8B5GgQWrgYQAAAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
								<span data-v-312d477d="">Gift cards</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>

						<a data-href="{{route('user.about')}}" class="linkBTN item" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAsCAYAAAAehFoBAAAAAXNSR0IArs4c6QAAAuVJREFUWEftmEFIFFEYx79vZjeFDIKCijpYdAgpnWboZjCtl4KkS4e8KSjaqVOHTtGpbgUeOriaQUHHQiMvugMZGPjebrQZUdBGFzu1Bw8ruu8fY+66rs7qqFNjzbvu++b99vf+7817w7TLGu8yXoqAg56xyHBkuMrAvxeJpqamhvr6+n4iusrMDT6mvABgrFAoXJ+ZmZn1UVez64aGTdN8xcwXtzFgVghxlogWt/GMcmlN4Obm5tPxePy921sp1QFgysegjZqmjbizAqBdSjnqo9aza01gwzBsXddTAHJSyuN+B7QsK0VENoAuKeWw3/r1+v8RYCJ6DiBTC5iZ5+bn559ks9kfNfvV+nGnDG/WLIA8ADudTr/zqtmSYXS3HSJWp9Y89DPesOOUF1dFJCaJ6MsG4K3MfJKIJoUQ53cUWPUkPhLxGmAG7nFy4lZpMD8ZNgzD0HU97dYKITxFbtFw4i6Yrq2yAJorQt2MDzpjWwRu1HX9ayDAm82kT8MRcHkfRl/iKBXhLpDVbQFvedgpeEUCHfZB2qv1ElFspRCjnEwJwzCCM7zVRYeethsgelD5Lxk0xsnxS4ECoztxG8R2teAiFe/Ek45T0/A+rZfUiuEFpV7uGXKmAwX+bxYdbDtGJ/gKsbZyTIWa4qHUp1AaXuyyL2sxfWT1/o2slpw4E0rgpV2iQesH+PASNNMiK3rCg+OPAwd2byJ1dXUHSrbS6fS36myH5sVhWdZDIuqrBHRPWkqpzkwm88Jzl1gvw5qa5oHUh8AMt7S0tMZisdceO8WsEOKIF/BfybBpmp3M/AjAtJTynAtXeZWqPGlVR2L5TXcfxMfKGSYa5oHxp4EZLgETkSOEuOAO7DVYKDIcAS8HPopE6ZofukhYlvWdiH6v4hA0AM+klB0llDV3OtM0fzLz/hCwLiEAGJVStnsCG4bhwoYGOJ/Pz+ZyufItZsOPgWEx7Wk4bIDVPJHhoGcoMhy04V8sVdhLisM0lwAAAABJRU5ErkJggg==" alt="" data-v-312d477d="">
								<span data-v-312d477d="">About us</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>
						
						<a href="{{route('user.faqs')}}" class="linkBTN item" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACwAAAAsCAYAAAAehFoBAAAAAXNSR0IArs4c6QAAAthJREFUWEftmE1oE0EUx9+bZCVipc2hoFAx6KHWD8hmlRqLaLSCXvTgSejBWtCbXtqDiFgEoaKCHjxUPVQbasGCCII9eLBYqGB3EinEHAqlePGg2NZWp/l6MnUDIakhtjOW4A4EApl97/f++39vJ4tQZQurjBdcYN13zFV4TRS2LKuZiLoR8TAA+HRDFMYnokkAiAoh7iQSifni3CWWME3zKGNsGAC8fwDNlPlNZW3JbDYbjsfjM4VBS4BDodB7RNwrNxHRKBG9RMTdiNjmXCiIqEclWT4WInqJaD8itjr5b3POu8oCW5ZFzuZxznkYAKSiEAqFbiFip/yeSqWaJiYmkjqgnVz9jkBJ27abKgXu45y35zebptnBGHvkFBPmnL/TBWxZ1iUAuAsAKwM2TXOr4+sdRDQvhNi8XEOstoBAIODz+/0tjLEoAGwCgB7bti9XrHA6nb5pGMYYItatFuZvryeicSFEpFiYkqYr8HAfEd1njI39o6kga5L9kiSiQSHEvYrGWiGw9HAwGAwAgPxoWx6P56m0ABG1c877yiUqq3Bh02mj/T2BphAx8H8DR0817/QAblSh9NxCOnnhtT2bj6Vc4em2yPkt61mvClgZYy6T+/Lk86eGi68mF50HhVpLVB2wVGHwxIHtGS/Wq1B54af4qNUSKiDLxVDu4aoD7m21avfV13T4EA0V8F/TmQ8Hn43KM/fSUq7wt7ORq7UGu64CVsZI5YgeT8/68z5WDpw4c+hYrYEDBsMaFdDzWRrZ1v/muDaFVUC6TZdXoPi0pltdLU03fLpl154Nxg0CWKeigO+ZbKxp4O0VbR5ePHfkmuHBbhWw+RgPp2bqtE2JFydbGsN+o3MxBw0qoH8QPW+MjjzQprAKSHdKVP2UAIChXC639KZH92KMjQJAw6r+0+mGXC7+ioDlQWQtYGVOIuqKxWJD5fK7b+B13x1XYVfhIgWqzhK/APxsbUvNI9kKAAAAAElFTkSuQmCC" alt="" data-v-312d477d="">
								<span data-v-312d477d="">FAQs</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>
						
					</div>
				</div>

				<div class="part4" data-v-312d477d="" data-v-e65b4284="">
					<div class="go" data-v-312d477d="">

						<a data-href="{{ route('user.logout') }}" class="item linkBTN" data-v-312d477d="">
							<div class="left" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAMAAABg3Am1AAAAilBMVEVHcEz/ZUMAAAAAAAAAAAAAAAAAAAD+ZEIAAAAAAAD+ZUMAAAAAAAAAAAD+ZUMAAAD/ZUMAAAAAAAAAAAD/Y0EAAAD/ZUL/ZEIAAAD/ZUP/ZUT/ZEMAAAAAAAAAAAAAAAAAAAAAAAD/ZUP/ZET+ZEIAAAAAAAD+ZUP/Y0T/Y0QAAAD+Y0EAAAD+ZkNI6tFcAAAALHRSTlMAhIhpnBQz4JI+x9F3vdBSu/PkxiUHbsNftZhcKu38St6ypUF5IKryFgqjUUmN1/gAAAIWSURBVEjH3VbZYqsgEFVQ0WjcY2KMMVtN0o7//3sXFAQV297X8hBBz2H2mRjGH10ORpaFsLf7FdrG1gX6lbbB6efLr2dQ1zb6Fv7RMlCdIRxFB7RNe4qzjo96QCNVd1omL1jDu/TjdXafbbGXejz7hMWhOopdU1OpK/cn0ilmKIX4WgbVv/6QR3OjfMsA0ML7VB8FPyUYVKu5r64ABw49SkJx494CuEzxJ4Bs2N26uyS8Om4KUvzRr61Q6NZNVSL8eYZ0YsGZC6i698yGpylEeAoBi+OzmhudP3P22AG4k5glM9/IOJRDCH3wZZScy6BRHhZjpE2xy0mxMBvzwJjkrUkBcuOBlcFDPAhxqMuZTcx+PdUImnZ9ncR7HaEseewsldD8F8HlKpValcKlSphX1YO8Vo1uVKO9ekj4195c4u/kiz0CtVR3LdT9ptDoxC/JIFUynNKHMJLHQsDzzbPPUtuLKPR7l88IXSGunHQoWrZ2v3nMGB1vBgnPtrE1AHwanFHI118CjxdV7Y/5fu9I0Xv3XYVdNdZLYixqNBEdrwjJJo73hJjKdYseS63yx4w2yzguj6M1n9rmR8s60w8Eik917ykj9TTzgrax1DZWGIDmQoKE6mqvtG9aSJAgpQHaARtG7fqA8Hw2IXwUeY7jRUGWsMF1+HYGYX8ysSBFP07GBo2cixv9ao6eMHIty6Vz94/+rfgH8T442+cqlLEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
								<span data-v-312d477d="">Logout</span>
							</div>
							<div class="right" data-v-312d477d="">
								<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAYCAYAAADOMhxqAAAAAXNSR0IArs4c6QAAAfZJREFUOE+F1L+LFDEUB/DvS0Rl8ddiITay5WIh+QEi3MEpqIUih/gDrBQ75QQbOfAfUK4RFEGwsLAQrjgQQVAE8VjBZl72h2iz4hbaWOzhiqDumEjWrOg5s5dqJnmfvEnyJqS1vktEs977c81m8zHWaGStHQDYHEL4CmCGmbNJhowxt4hoLgaFED7leb6v3W6/L0MEYJ219iGAIwm9HQ6HU51OZ6UIRQBrbQXAcwB7E2r0+/1DvV7v22o0ArHV6/XtlUqlQUT1hB4x83EAP/9Gf0DsVErVpJSvAOxI6B4zny8FCSkp5QsAW+K79/6ac+7qGP2TYdyplNovhHhCROtTpjlmvh2fC0EcMMacBvCAiEQIwQM4w8yLpSAirfUlIcTNlOUHgIMTQcq0QERXEnq3JrDWXgcwn0BvIlBKXZRSjhYba817f6AUaK1PENFiXDSAHMDRLMueFgKt9QwRxW3dEH63s865+4XbaozZQ0TLALamT5ln5oXCg7PW7gIQS2NnOuU7zrkLhaWhlNomhHhJRLvTzEvMfCpWx3+gVqttrFarz4QQUyl4eTAYHO52u9+LyltYa5cAzKbB1wCmsyz7vDp4tGhjzA0iupxm/ph+0Q9FwWPwhYg2hRBWQgjTzrk3ZcEjEK8ZIcSxPM9PtlqtxqTgOPYLri3VmGIKUkEAAAAASUVORK5CYII=" alt="" data-v-312d477d="">
							</div>
						</a>
							
					</div>
				</div>
			</div>
        </div>
    </div>
</div>

@include($activeTemplate.'partials.recharge')
@include($activeTemplate.'partials.withdraw')
@include($activeTemplate.'partials.pincode')
@include($activeTemplate.'partials.password')
@include($activeTemplate.'partials.giftcard')

@endsection

@push('script')
@endpush