@extends($activeTemplate.'layouts.home')

@push('style')
@endpush


@section('content')
@include($activeTemplate. 'layouts.home_navprev')
<div class="inner-wrapper-with-header">

    <div class="team-container transaction-detail">

        <!-- balance -->
        <div class="balance">
            <p>Current Balance</p>
            <p>{{ config('settings')->cur_sym }}{{ getAmount($userBalance) }}</p>
        </div>
        <!-- end balance -->

        <!-- details -->
        <div class="details">

            <!-- header leading buttons -->
            <div class="switch-buttons">
                <div>
                    <p>My income</p>
                </div>

                <div class="active">
                    <p>Subordinate income</p>
                </div>
            </div>

            <!-- detail -->
            @foreach($logs as $log)
            <div class="detail">
                <div>
                    <p>{{ $log->plan->name }}</p>
                    <p>{{ $log->created_at }}</p>
                </div>

                <div>
                    <p>{{ $log->total_paid }} of {{ $log->total_return }} Days</p>
                    <p>Balance: {{ config('settings')->cur_sym }}{{ amount_format($log->amount) }}</p>
                </div>
            </div>
            @endforeach

            <!-- detail nth -->

        </div>
        <!-- end details -->
        
    </div>

</div>
@endsection

@push('script')
@endpush
