@extends($activeTemplate.'layouts.app')

@push('style')
<link rel="stylesheet" href="{{ asset('users/assets/app') }}/css/mui.min.css">
<style type="text/css">
    body {
        min-height: 100%;
        background-size: cover;
        background-attachment: fixed;
        position: relative;
    }

    .qrcode-img {
        /*   background: #283C48; */
        padding: 10px;
        border-radius: 10px;
        width: 200px;
        height: 200px;
        display: block;
        margin: 0 auto;
    }

    .share-qrcode p {
        font-size: .3rem;
        color: #fff;
        text-align: center;
        padding: 1rem 2rem 0 2rem;
    }

    .copy-code {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        border-radius: 10px;
        width: 70%;
        margin: auto;
        /* 		padding-bottom: 30px; */

    }

    .copy-code a {
        display: inline-block;
        background: #1984FF;
        color: #FFFFFF;
        font-size: 16px;
        width: 1.7rem;
        height: .40rem;
        line-height: .4rem;
        border-radius: .4rem;
        text-align: center;
        letter-spacing: .01rem;
    }


    .btn {
        text-transform: uppercase;
        background: #000000;
        color: white;
        padding: 10px;
        border-radius: 20px;
        cursor: pointer;
        margin: 30px 15%;
        width: 70%;
        text-align: center;
        border: none;

    }

    .btn:hover {
        background: #b8ced9;
        color: #fff;
    }

    input,
    textarea {
        padding: 10px;
        border: 1px solid #d3d3d3;
        width: 220px
    }

    textarea {
        height: 80px
    }

    #foo {
        padding: 10px 36px;
        border-radius: 8px;
        font-size: 24px;
        font-weight: bold;
        background: #f1f1f1;
        color: #333;
    }


    .appContent {
        border-radius: 6px;
    }

    .demo,
    .demo1 {
        background: #fff;
    }

    .demo {
        border-radius: 8px 8px 0 0;
    }

    .demo p {
        font-size: 18px;
        font-weight: 500;
    }

    .demo1 {
        border-radius: 0 0 8px 8px;
    }
</style>
@endpush


@php
$link = route('invite', ['code' => auth()->user()->ref_code]);
$code = auth()->user()->ref_code;
@endphp

@section('container') <div id="appCapsule" class="pb-2"> @endsection
@section('content')
@include($activeTemplate. 'layouts.app_navprev')
<div class="ban"></div>
<div class="appContent  mtbe">
<section class="container dew">
    <div class="demo pt-3">
        <p class="m-0 text-center text-dark">SCAN QR code to join</p>

        <div class="share-qrcode">
            <div class="qrcode-img" id="qrcode" title="{{ $link }}"><canvas width="180" height="180" style="display: none;"></canvas></div>
        </div>


    </div>
    <div class="transfer-box-bottom">
        <img src="{{ asset('users/assets/app') }}/img/QRcode_bg.png">
    </div>
    <div class="demo1 pb-3">
        <div class="copy-code">
            <p class="mb-2 mt-2">My invitation code</p>
            <span id="foo" class="pt-1">{{ $code }}</span>
        </div>
        <button class="btn" data-clipboard-text="{{ $link }}" id="copyText">Copy</button>
    </div>

</div>
</section>
@endsection

@push('script')
<script src="{{ asset('users/assets/app') }}/js/clipboard.min.js"></script>
<script src="{{ asset('users/assets/app') }}/js/mui.min.js"></script>
<script type="text/javascript" src="{{ asset('users/assets/app') }}/js/qrcode.js"></script>
<script>

    var url = "{{ $link }}";
    var qrcode = new QRCode('qrcode', {
        text: url,
        width: '180',
        height: '180',
        colorDark: '#000000',
        colorLight: '#ffffff',
        correctLevel: QRCode.CorrectLevel.H
    });


    window.onload = function () {

        var clipboard = new Clipboard('#copyText');
        clipboard.on('success', function (e) {
            mui.alert("Copped!");
            e.clearSelection();
        });
    };
</script>
@endpush