@php $faqDatas = getContent(config('settings')->active_template, 'faq.element'); @endphp
@extends($activeTemplate.'layouts.dash')

@section('content')
<div style="background: none; height: auto; overflow: hidden; ">
	<div class="top" style="background: none;">
		<div data-href="{{ route('user.home') }}" class="linkBTN" style="float:left; line-height:46px;width:50%; height:46px;cursor:pointer;" id="btnClose">
			<img src="/assets/images/arrow-long-left.png" style="margin-left:12px;width:32px;" />
		</div>
	</div>
	
	<div style="padding-top:30px;">
		<div style="float: left; width: 100%; text-align: center; color: #fff;">
			<div style="height: 100px; line-height: 100px; margin:0 auto; border-radius: 100px;">
				<img src="{{ getImage(imagePath()['logoIcon']['path'] .'/favicon.png') }}?df" style="height: 100px; border-radius:100px;">
			</div>
			<div style="padding:5px; padding-top:10px;color:#000; font-weight:bold; font-size:20px; margin-top:10px;" id="uid">Reward task</div>
			<div style="padding:5px; padding-top:5px;color:#000; font-size:12px;">Complete this task to earn weekly or daily</div>
		</div>
	</div>
</div>


<div class="home layui-form layui-tab-content" style="padding:5px 10px; margin:60px 0;">
	<div class="my-tasks">

		<div class="tasks">
			@foreach($rewards as $task)
			<div>
				<div>
					<div class="round-badge">
						<img src="/assets/images/{{ strtolower($task->currency) }}.png" alt="">
					</div>
					<p>{{ showAmount($task->amount) }}</p>
				</div>
				<div>
					<div>
						<p>{{ $task->name }}</p>
						<p>{!! $task->summary !!}</p>
					</div>
					<div>
					@if( in_array($task->id, $pending_reward) )
						<button type="button" class="Buy" style="background-color: #000;" onclick="modalMessage('You are currently earning from this reward.');" data-id="{{ $task->id }}">Active </button>
					@else
						<button type="button" class="Buy task-submit" data-id="{{ $task->id }}">Get </button>
					@endif
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>
</div>
@endsection


@push('script')
<script type="text/javascript">
    $('.task-submit').on('click', function() {
        
        var csrfToken = $('meta[name="csrf-token"]').attr('content');
        var $id = $(this).data('id');

        var $button = this;

        $($button).html('<img id="loader" src="/assets/images/loading.gif" style="width:20px" alt="">');

        // Make AJAX POST request
        $.ajax({
            type: 'POST',
            url: "{{ route('user.reward.activate') }}",
            contentType: 'application/json',
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json",
                "X-Requested-With": "XMLHttpRequest",
                "X-CSRF-TOKEN": csrfToken
            },
            data:JSON.stringify({id:$id}),
            dataType: 'json',
            success: function(res) {
                if (res.status == 200) {
                    $($button).val('');
                }

                $($button).html('Get');
				modalMessage(res.message);
            },
            error: function(jqXHR, textStatus, res) {
				var data = JSON.parse(jqXHR.responseText);
				var responseMessage = data.message

				if (data.errors) {
					var errorMessages = [];
					for (var key in data.errors) {
						if (data.errors.hasOwnProperty(key)) {
							errorMessages.push(data.errors[key][0]);
						}
					}
					responseMessage = errorMessages.join(", ")
				}

				modalMessage(responseMessage);
                $($button).html('Get');
            }
        });
    });
	
</script>
@endpush