@php $loginContent = getContent(config('settings')->active_template, 'login.content', true); @endphp

@extends($activeTemplate.'layouts.auth')

@push('seo-lib')
	<?php $pageTitle = 'Verify OTP'; ?>
	<title>{{ config('settings')->sitename }} - {{$pageTitle}}</title>
	<link rel="shortcut icon" href="{{getImage(imagePath()['logoIcon']['path'] .'/favicon.png')}}{{$catch}}" type="image/x-icon">
	<meta name="keywords" content="{!! @$loginContent->data_values->keyword !!}">

	<meta name="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="name" content="{{$pageTitle}}">
	<meta itemprop="description" content="{!! @$loginContent->data_values->description !!}">
	<meta itemprop="image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}">

	<meta property="og:title" content="{{$pageTitle}}">
	<meta property="og:description" content="{!! @$loginContent->data_values->description !!}">
	<meta property="og:image" content="{{ asset( 'assets/images/frontend/login/' .@$loginContent->data_values->seo_image) }}"/>

	<meta name="apple-mobile-web-app-title" content="{{ $pageTitle }}">
@endpush


@section('content')
    <uni-app class="uni-app--maxwidth">
        <uni-page data-page="pages/login/login">
            <uni-page-wrapper class="authDev">
                <uni-page-body>
                    <uni-view data-v-b3f3cefe="" style="position: relative;">
                        <uni-view data-v-b3f3cefe="" class="content" >
                            <form method="post" action="{{ route('user.password.verify.code') }}" data-v-b3f3cefe="" id="resetPassword" class="login-form">
                                <uni-view data-v-b3f3cefe="" class="hero-content"><img data-v-b3f3cefe="" src="{{getImage(imagePath()['logoIcon']['path'] .'/logo.png')}}{{$catch}}" class="logo">
                                    <uni-view data-v-b3f3cefe="" class="card">
                                        <h1 data-v-b3f3cefe="" class="color-linear1">Verify OTP Receiving</h1>
										@csrf
                                        <p data-v-b3f3cefe="" class="inView">
											<span data-v-b3f3cefe="" class="icon-shouji1"></span>
                                            <span data-v-b3f3cefe="" style="margin-left:9px;width: 100%;">
												<input maxlength="140" step="" name="code" style="width:100%" enterkeyhint="done" id="phdk" autocomplete="off" type="mobile" placeholder="Enter the otp code" class="uni-input-input">
                                            </span>
											<div class="report mobileReport" style="color:white"></div>
                                        </p>
										
										<input name="username" type="hidden" value="{{ $username }}" class="uni-input-input">

										<p style="height:30px;">&nbsp;</p>

                                        <uni-button data-v-b3f3cefe="" onclick="onSign()" class="hero-button sendBTN" type="primary">SUBMIT CODE</uni-button>
                                    </uni-view>
									
                                    <uni-view data-v-b3f3cefe="" class="policy">
                                        <p data-v-b3f3cefe="" style="font-size:15px">&nbsp;</p>
                                    </uni-view>

                                    <uni-view data-v-b3f3cefe="" class="fun" style="padding-bottom: 25px;">
                                        <uni-view data-v-b3f3cefe="">Remember Password? Try to <a data-v-b3f3cefe="" href="{{ route('user.login')}}">Log in</a></uni-view>
										@if( config('settings')->app_link )
                                        <uni-view data-v-b3f3cefe=""><img data-v-b3f3cefe="" mode="aspectFit" src="{{ asset($activeTemplateTrue.'img/googlePlay.png') }}" style="height: 25px;"></uni-view>
										@endif
                                    </uni-view>
                                </uni-view>
                            </form>
							
                            <uni-image data-v-b3f3cefe="" style="display: flex; justify-content: center; position: absolute; top: 15px; right: 15px; width: 40px; height: 40px;">
                                <div style="background-image: url('{{ asset($activeTemplateTrue.'img/www.png') }}'); background-size: 100% 100%; background-repeat: no-repeat;"></div>
                                <img src="{{ asset($activeTemplateTrue.'img/www.png') }}" draggable="false">
							</uni-image>
							
							<uni-tabbar class="" style="box-shadow:none;">
								<div class="uni-tabbar" style="backdrop-filter: none;box-shadow:none">
									<div class="uni-tabbar-border" style=""></div>

									@if( config('settings')->whatsapp_url )
										<div class="uni-tabbar__item socialHandle" data-href="{{ config('settings')->whatsapp_url }}" >
											<div class="uni-tabbar__bd" style="height: 45px;">
												<div class="uni-tabbar__icon" style="width: 24px; height: 24px;">
													<img src="{{ asset($activeTemplateTrue.'img/WhatsAppGroup.png') }}">
												</div>
												<div class="uni-tabbar__label" style="color: rgb(233, 164, 98); font-size: 12px; line-height: normal; margin-top: 3px;">Whatsapp</div>
											</div>
										</div>
									@endif

									@if( config('settings')->telegram_url )
										<div class="uni-tabbar__item socialHandle" data-href="{{ config('settings')->telegram_url }}">
											<div class="uni-tabbar__bd" style="height: 45px;">
												<div class="uni-tabbar__icon" style="width: 24px; height: 24px;">
													<img src="{{ asset($activeTemplateTrue.'img/TelegramChannel.png') }}">
												</div>
												<div class="uni-tabbar__label" style="color: rgb(233, 164, 98); font-size: 12px; line-height: normal; margin-top: 3px;">Telegram</div>
											</div>
										</div>
									@endif
								</div>
								<div class="uni-placeholder" style="height: 25px;"></div>
							</uni-tabbar>
							
                        </uni-view>
                    </uni-view>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>

    </uni-app>
@endsection


@push('script')
<script>

	function onSign() {
		let flag = true;
		let li = document.querySelectorAll('.inView');
		var otp = $("#phdk").val();

		$('.report').html('');

		li.forEach((dom, index) => {
			let input = dom.querySelector('input');

			if (input.name == 'code') {
				let u = document.querySelector('.mobileReport');
				
				if (!otp) {
					u.innerText = 'Enter otp sent to you.';
					flag = false
				}else if (otp.length < 4) {
					u.innerText = 'Enter a valid otp code.';
					flag = false
				}
			} 
			
		})

		if (!flag) return
			$('.sendBTN').attr('disabled', true).attr('loading', 'true');
			$(".login-form").submit();
	}
	
</script>

@endpush
