@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/bank.css') }}{{$catch}}">
<style>
.uni-picker-view-content {
    height: 100%; 
    overflow-y: scroll;
}

.uni-picker-view-group {
    max-height: 100%; /* Ensure content does not exceed the wrapper */
}
</style>
@endpush

@section('content')
    <uni-app class="uni-app--maxwidth">
		@php
			$accountNumber = ($user->bankAccount) ? $user->bankAccount->account_number : '';
			$accountName = ($user->bankAccount) ? $user->bankAccount->account_name : '';
			$bankName = ($user->bankAccount) ? $user->bankAccount->bank_name : '';
			$bankCode = ($user->bankAccount) ? $user->bankAccount->bank_code : '';
		@endphp
        <uni-page data-page="pages/setting/data-modify">
            <uni-page-wrapper class="bnKosTh">
                <uni-page-body>
                    <uni-view data-v-6765183a="">
                        <uni-view data-v-58cb4ed7="" data-v-6765183a="" class="back-title">
							<span data-v-58cb4ed7="" data-href="{{ route('user.profile') }}" class="linkBTN"></span>
							<span data-v-58cb4ed7="" class="title-txt">Bank Card Management</span>
						</uni-view>
                        <uni-view data-v-6765183a="" class="content">
                            <uni-view data-v-6765183a="" class="color-bg"></uni-view>
                            <form action="" method="post" id="bankForm"  data-v-6765183a="" class="form">
                                <uni-view data-v-6765183a="" class="info">
								@csrf
								
                                    <p data-v-6765183a="">Bank Name</p>
                                    <uni-view data-v-6765183a="" class="uni-list">
                                        <uni-view data-v-6765183a="" class="uni-list-cell">
                                            <uni-view data-v-6765183a="" class="uni-list-cell-db">
                                                <uni-picker data-v-6765183a="">
                                                    <div>
                                                        <uni-view data-v-6765183a="" class="bank-input">
															<span data-v-6765183a="" class="bankSelected">{{$bankName}}</span>
                                                            <uni-view data-v-6765183a="" class="select-btn">
                                                                <p data-v-6765183a="" class="caret-top"></p>
                                                                <p data-v-6765183a="" class="caret-bottom"></p>
                                                            </uni-view>
                                                        </uni-view>
                                                    </div>
                                                </uni-picker>
                                            </uni-view><span style="color:#F00" id="bank_name_err"></span>
                                        </uni-view>
                                    </uni-view>
									
                                    <p data-v-6765183a="">Account number</p>
                                    <uni-input data-v-6765183a="">
                                        <div class="uni-input-wrapper">
                                            <div class="uni-input-placeholder input-placeholder" data-v-6765183a=""></div>
											<input maxlength="140" step="" value="{{$accountNumber}}" name="account_number" id="account_number" enterkeyhint="done" autocomplete="off" type="" <?php echo ( $user->payment_set == 1 ) ? 'disabled':''; ?> class="uni-input-input">
                                        </div>
                                    </uni-input><span style="color:#F00" id="account_number_err"></span>
									
                                    <p data-v-6765183a="">Users Account Name</p>
                                    <uni-input data-v-6765183a="">
                                        <div class="uni-input-wrapper">
                                            <div class="uni-input-placeholder input-placeholder" data-v-6765183a=""></div>
											<input name="account_name" id="account_name" maxlength="140" value="{{$accountName}}" step="" enterkeyhint="done" autocomplete="off" type="" class="uni-input-input">
                                        </div>
                                    </uni-input><span style="color:#F00" id="account_name_err"></span>
									
									<input type="hidden" name="bank_name" id="bank_name" value="{{$bankName}}">
									<input type="hidden" name="bank_code" id="bank_code" value="{{$bankCode}}">
									<span style="color:#F00;display:none;" id="bank_code_err"></span>
									
                                    <p data-v-6765183a="" style="padding-top:14px;">USDT Wallet Address <span style="float:right">[Crypto]</span></p>
                                    <uni-input data-v-6765183a="">
                                        <div class="uni-input-wrapper">
                                            <div class="uni-input-placeholder input-placeholder" data-v-6765183a=""></div>
											<input maxlength="140" step="" value="{{ $user->withdrawal_usdt_address }}" name="wallet_address" enterkeyhint="done" autocomplete="off" type="" class="uni-input-input">
                                        </div>
                                    </uni-input><span style="color:#F00" id="wallet_address_err"></span>

                                    <uni-button data-v-6765183a="" class="hero-button" onclick="submit();" type="primary">Confirm To Modify</uni-button>
                                </uni-view>
                            </form>
                        </uni-view>
                    </uni-view>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>

        <div class="uni-picker-container uni-selector-select bankSeletor" style="display:block;z-index:-1;">
            <div class="uni-mask uni-picker-mask" style=""></div>
            <div class="uni-picker-custom uni-picker-toggle">
                <div class="uni-picker-header">
                    <div class="uni-picker-action jIislO uni-picker-action-cancel">
                        Cancel
                    </div>
                    <div class="uni-picker-action uIksCj uni-picker-action-confirm">
                        Done
                    </div>
                </div>
                <uni-picker-view class="uni-picker-content">
                    <div class="uni-picker-view-wrapper">
                        <uni-picker-view-column>
                            <div class="uni-picker-view-group">
                                <div class="uni-picker-view-mask" style="background-size: 100% 102px;"></div>
                                <div class="uni-picker-view-indicator" data-v-6765183a="" style="background:#0000002b">
                                    <uni-resize-sensor>
                                        <div>
                                            <div></div>
                                        </div>
                                    </uni-resize-sensor>
                                </div>
								@php $items = count($banks); $totalPiont = (33.5 * $items )+238; @endphp
                                <div class="uni-picker-view-content picker-view-column-1727125002520" id="bankListDiv" style="padding:102px 0px 96px; ">
									@foreach($banks as $bank)
                                    <div class="uni-picker-item" data-epoint="{{ ($totalPiont - 33.4) }}" data-spoint="{{ $totalPiont }}" data-name="{{ $bank['name'] }}" data-value="{{ $bank['bank_code'] }}">
                                        {{ $bank['name'] }}
                                    </div>
									@php $totalPiont -= 33.5; @endphp
									@endforeach
                                </div>
                            </div>
                        </uni-picker-view-column>
                    </div>
                </uni-picker-view>
                <div></div>
            </div>
        </div>
    </uni-app>
@endsection

@push('script-lib')

<script>
	const bnkList = document.querySelectorAll('.uni-picker-item');
	var selected = 0;var canSend = false;
	
    (function ($) {
        "use strict";
		
		var indictPoint = $('.uni-picker-view-indicator').offset().top;
		var endIndict = (indictPoint-32);
		
		
		document.getElementById('bankListDiv').addEventListener('scroll', function() {
			bnkList.forEach(item => {
				const itemOffsetTop = item.getBoundingClientRect().top;

				if (itemOffsetTop >= endIndict && itemOffsetTop <= indictPoint) {
					//console.log(item.dataset);
					selected = Array.from(bnkList).indexOf(item);
				}
			});
		});	
		
		$(document).on("click", '.jIislO', function () {
			$('body,html').css({
				overflow: 'scroll'
			}); $('.bankSeletor').fadeOut();
		})

		$(document).on("click", '.uIksCj', function () {
            let info = bnkList[selected].dataset;
			$(".bankSelected").html(info.name);
			$("#bank_name").val(info.name);
			$("#bank_code").val(info.value);
			
			$('body,html').css({
				overflow: 'scroll'
			}); $('.bankSeletor').fadeOut();
			
            let account = $("#account_number").val();

            if (account != "" && info.value != "" && account == 10) {
                get_account_info(info.value, account);
            }
			
		})
		
		$(document).on("click", '.uni-list-cell', function () {
			
			$('.bankSeletor').css({
				'z-index' : 2
			});
			$('body,html').css({
				overflow: 'hidden'
			});
			$(".bankSeletor").slideDown();
        });
		

        $("#account_number").change(function () {
            let code = $("#bank_code").val();
            let account = $("#account_number").val();

            if (account == "" || code == "" || account.length < 10) {
				canSend = false;
                $("#account_name").val("");
                return;
            }
            get_account_info(code, account);
        });
		

        function get_account_info(code, account) {
			loading.showLoading({type: 3,tip: "loading.."});
			
            $.ajax({
                url: "{{ route('account.fetch') }}",
                type: 'get',
                dataType: 'json',
                data: {
                    'bank-verification': '',
                    'code': code,
                    'account': account
                },
                success: function (response) {
					console.log(response);
					loading.hideLoading();
                    if (response.status == "error") {
                        $("#account_name").val("");
						Toast("Could not get account details. Try again");
						canSend = false;
                        return;
                    }

					canSend = true;
                    console.log(response.data);
                    $("#account_name").val(response.data.account_name);
					Toast("Account found ["+response.data.account_name+"]", "SERVER RESPONSE");
                },

                error: function (err) {
                    console.log(err.responseText);
					loading.hideLoading();
                }
            });
        }

    })(jQuery);
	
	function submit() {
		let flag = true;

		let input = document.querySelectorAll('input');
		input.forEach((dom, index) => {
			if( !input[index].value){
				flag = false;
				let name = input[index].name;
				$('#'+name+'_err').html(name.replace('_',' ') + ' required');
			}
		});

		if (!flag) return

		loading.showLoading({type: 3,tip: "loading.."});
		$("#bankForm").submit();
		
	}

</script>
@endpush
