@extends($activeTemplate.'layouts.dash')

@push('style')
<link rel="stylesheet" href="{{ asset('users/assets/app') }}/css/mui.min.css">

<style type="text/css">
    #tit span {
        width: 50% !important;
        display: inline-block !important;
    }
    
    .text p {
        background: #cebdff;
        width: 100px;
        text-align: center;
        color: #fff;
        border-radius: 5px;
        font-size: 16px;
        height: 30px;
        line-height: 30px;
        margin-top: 10px;
    }

    .appContent {
        padding: 0 10px 20px 10px;

    }

    .text-muted {
        color: #8D95A0;
        font-size: 14px;
        font-weight: 400;
        display: initial;
        float: right;
    }

    .listItem i {
        background-color: #560db0;
        padding: 2px 10px;
        position: absolute;
        font-style: normal;
        top: 0px;
        left: 0;
        color: #fff;
    }

    .listItem span {
        color: #333;
    }

    .text span {
        font-size: 16px;
        font-weight: 500;
    }

    .texle {
        text-align: center;
        margin-top: 8px;
    }

    .texle span {
        background: #ca95ed;
        color: #333;
        padding: 4px 20px;
        border-radius: 4px;
    }

    .itemList .item {
        padding: 4px 10px;
        box-shadow: none;
    }

    .myfle {
        margin-bottom: 12px;
        background: #304256;
        border-radius: 4px;
        border-radius: 8px;
    }

    .myfle small {
        font-size: 12px;
        color: #fff;
    }

    .myfle .title {
        color: #333 !important;
        padding-top: 10px;
    }

    .myfle .title img {
        padding-right: 5px;
    }

    .myfle h6 {
        color: #eee;
    }

    .myfle .borig {
        border-right: 1px solid #e9e7e7;
    }

    .myfle h4 img {
        width: 20px;
        border-radius: 50%;
        margin-right: 10px;
    }

    .btn {
        text-transform: uppercase;
        background: #000000;
        color: white;
        border-radius: 20px;
        cursor: pointer;
        width: 20%;
        height: 20%;
        text-align: center;
        border: none;
        font-size: 13px;
        margin: 5px;

    }

    .btn:hover {
        background: #b8ced9;
        color: #fff;
    }
</style>
@endpush

@section('content')

<script>
    "use strict"

    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function() {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById(elementId).innerHTML = days + "d " + hours + "h " + minutes + "m " + seconds + "s ";
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "Awaiting";
            }
            tms--;
        }, 1000);
    }
</script>

<div style="clear: both;"></div>
<div class="appContent pb-0  pt-1">

    <div id="tit" class="mb-1">
        <span @if($expired == '0') class="select" @endif onclick="location.href='{{ route('user.coupon', ['expired' => '0']) }}'">Active</span>
        <span @if($expired == '1') class="select" @endif onclick="location.href='{{ route('user.coupon', ['expired' => '1']) }}'">Expired</span>
    </div>

    <div class="itemList">
        
        @foreach($pub_coupons as $coupon)

        @php
        $expiredDate = \Carbon\Carbon::parse($coupon['expired_date'])->format('d/m/y h:iA');
        $nextTime = \Carbon\Carbon::parse($coupon['start_date']);
        @endphp

        @if($coupon['started'] != 1)
        <script>
            createCountDown('counter<?php echo $coupon['id']; ?>', {{ $nextTime->diffInSeconds() }});
        </script>
        @endif

        @include($activeTemplate.'user.coupon.list')

        @endforeach

        <!-- MY Coupon -->
        @foreach($coupons as $coupon)

        @php
        $expiredDate = \Carbon\Carbon::parse($coupon['expired_date'])->format('d/m/y h:iA');
        $nextTime = \Carbon\Carbon::parse($coupon['start_date']);
        @endphp

        @if($coupon['started'] != 1)
        <script>
            createCountDown('counter<?php echo $coupon['id']; ?>', {{ $nextTime->diffInSeconds() }});
        </script>
        @endif

        @include($activeTemplate.'user.coupon.list')

        @endforeach
    </div>
</div>
@endsection

@push('script')
<script src="{{ asset('users/assets/app') }}/js/clipboard.min.js"></script>

<script>

    window.onload = function () {

        var clipboard = new Clipboard('#copyText');
        clipboard.on('success', function (e) {
            mui.alert("Copped!");
            e.clearSelection();
        });
    };
</script>
@endpush