@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/recharge.css') }}{{$catch}}">
@endpush


@section('content')
    <uni-app class="uni-app--maxwidth">
		@php $maxAmt = 0; @endphp
        <uni-page data-page="pages/record/recharge">
            <uni-page-wrapper class="IoksjnD">
                <uni-page-body>
                    <uni-view data-v-43007dac="">
                        <uni-view data-v-58cb4ed7="" data-v-43007dac="" class="back-title">
							<span data-v-58cb4ed7="" data-href="{{ route('user.profile') }}" class="linkBTN"></span>
							<span data-v-58cb4ed7="" class="title-txt">Transfer In</span>
							<span data-v-58cb4ed7="" data-href="{{ route('user.deposit.history') }}" class="linkBTN"><img src="{{ asset($activeTemplateTrue.'img/detail.png') }}" style="width:24px" /></span>
						</uni-view>
						
                        <uni-view data-v-43007dac="" class="content">
                            <uni-view data-v-43007dac="" class="color-bg"></uni-view>
                            <uni-view data-v-43007dac="" class="recharge-title" style="display:none">
                                <uni-view data-v-43007dac="" data-currency="NGN" data-symbol="₦" data-rate="1.00" data-exchange="1.00" data-other="₦" class="active tabs"><span data-v-43007dac="">NGN</span></uni-view>
                                <uni-view data-v-43007dac="" data-currency="USDT" data-symbol="₮" data-rate="{{ config('settings')->usdt_to_ngn }}" data-other="₦" data-exchange="{{ config('settings')->ngn_to_usdt }}" class="tabs"><span data-v-43007dac="">USDT</span></uni-view>
                            </uni-view>
							
							<form id="depositForm" action="{{ route('user.deposit.insert') }}" method="post">
								<div data-v-43007dac="" class="ikJlape" style="width:94%;margin:0 auto;">
									<uni-view data-v-43007dac="" class="balance-card" style="display: flex; justify-content: space-around;">
										<span style="font-size:24px;font-weight:700;">{{ config('settings')->cur_sym}}</span>
										<uni-view data-v-240cb67c="" data-v-43007dac="" class="first">
											<uni-view data-v-240cb67c="" class="tip"><span data-v-240cb67c="" class="" style="">DEPOSIT BALANCE</span></uni-view>
											<p data-v-240cb67c="" class="" style="">{{ showAmount($userBalance) }}</p>
										</uni-view>
									</uni-view>
								</div>
								
								<div data-v-43007dac="" class="form wrap ikJlape" style="margin-top: 25px;">
									<p data-v-43007dac="" major-title="true" style="margin-top: 15px;text-align:end">Transfer In</p>
									<uni-view data-v-43007dac="" class="info">
										<p data-v-43007dac="">Enter Amount</p>
										<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;justify-content: space-between;">
												<span data-v-0a75b799="" style="margin-top:7px">{{ config('settings')->cur_sym}}</span>
												<input step="0.0001" id="amtID" style="width:78%;padding:10px 2px;background:transparent;" placeholder="Enter amount to recharge" name="amount" enterkeyhint="done" autocomplete="off" type="text" class="uni-input-input">
												<span data-v-0a75b799="" style="margin-top:7px">{{ config('settings')->cur_text}}</span>
											</span>
										</uni-input>
										
										<uni-view data-v-43007dac="" class="tip" style="display:none">
											<span data-v-43007dac="" id="rateValue" style="display: block;">{{ config('settings')->cur_sym}}0.00 ≈ {{ config('settings')->cur_sym}}0.00</span>
											<span data-v-43007dac="" id="exchangeRate">{{ config('settings')->cur_sym}}1.00 ≈ {{ config('settings')->cur_sym}}1.00</span>
										</uni-view>
										
									</uni-view>
								</div>

								<input type="hidden" name="currency" class="edit-currency" value="NGN" />
								<input type="hidden" name="method" class="edit-method-code" value="{{ config('settings')->defualt_deposit}}" />
								<input type="hidden" required name="plan_id" id="planid" />
								
								<!--div data-v-43007dac="" class="form wrap ikJlape" style="margin-top: 25px;">
									<p data-v-43007dac="" major-title="true" style="margin-top: 2px;">Quick Select Amount</p>
									<uni-view data-v-3ad70c0d="" data-v-43007dac="" class="uni-grid-wrap" style="margin-top: 10px;">
										<uni-view data-v-3ad70c0d="" id="Uni_kqqz" class="uni-grid uni-grid--border" style="border-left-color: rgb(210, 210, 210);">
											
											@foreach ($plans as $key => $plan)
											<uni-view data-v-4336d7d8="" data-amount="{{ getAmount($plan->min_amount) }}" data-v-43007dac="" class="uni-grid-item amounts" style="width: 33.2%; height: 64px;position:relative">
												<uni-view data-v-4336d7d8="" class="uni-grid-item__box uni-grid-item--border uni-grid-item--border-top uni-highlight" style="border-right-color: rgb(210, 210, 210); border-bottom-color: rgb(210, 210, 210); border-top-color: rgb(210, 210, 210);">
													<uni-view data-v-43007dac="" class="amount-box" style="width: 100%; height: 100%;font-weight:900;">{{ config('settings')->cur_sym}}{{ showAmount($plan->min_amount,0) }}</uni-view>
												</uni-view>
											</uni-view>
											@php $maxAmt = $plan->min_amount; @endphp
											@endforeach

										</uni-view>
									</uni-view>
								</div-->
								
								<div data-v-43007dac="" class="form wrap ikJlape" style="margin-top: 25px;">
									<div class="centnen" style="margin-top: 15px;">
										<div class="wrap" >
											<div class="box">
												<p>Select payment method</p>
												<div class="bank">
													@foreach($gatewayCurrency as $data)
													<div class="payoption @if($data->method_code == config('settings')->defualt_deposit) active @endif" data-method_code="{{$data->method_code}}" data-currency="{{$data->currency}}">
														<i></i> {{__($data->name)}}
													</div>
													@endforeach
												</div>
											</div>
										</div>
									</div>
				
									<uni-button data-v-43007dac="" onclick="onOk()" class="hero-button" type="primary">Recharge</uni-button>
								</div>
                            </form>
							
                            <uni-view data-v-5c2fef75="" class="rules">
                                <h3 data-v-5c2fef75="">Deposit Note</h3>
                                <p data-v-5c2fef75="">If you encounter any problem while trying to recharge please contact the support team for assistance.</p>
                                <p data-v-5c2fef75="">Kindly note to make payments intime</p>
                            </uni-view>

                        </uni-view><br>
                    </uni-view><br>
                </uni-page-body><br>
            </uni-page-wrapper>
        </uni-page>

	@include($activeTemplate.'layouts.menu',['activeLink'=>'invest'])
	</uni-app>
@endsection

@push('script')
	<script type="text/javascript">
		var currency = "NGN", symbol = "₦", rate="1", xchange = "1", other = "₮";
        $('#Uni_kqqz .amounts').click(function() {
            $(this).addClass('amount-active').siblings().removeClass('amount-active');
            let value = $(this).data('amount');
            $('#amtID').val(value);
			exchange();
        })

		$(".payoption").click(function() {
			$(".edit-currency").val($(this).data('currency'));
			$(".edit-method-code").val($(this).data('method_code'));
			$(".payoption").removeClass('active');
			$(this).addClass('active');
		})

        $('#amtID').keyup(function() {
            $(this)[0].value = $(this)[0].value.replace(/^(0+)|[^\d]+/g, '');
            $('#Uni_kqqz .amounts').removeClass('amount-active');
			exchange();
        })
		
        $('.tabs').click(function() {
			$(".tabs").removeClass('active');
			$(this).addClass('active');
			var info = $(this).data();
			currency = info.currency, symbol = info.symbol, rate = info.rate, xchange = info.exchange, other = info.other;
			$('.edit-currency').val(currency);
			$('#exchangeRate').html("["+currency+"] "+symbol+"1.00 ≈ " + other + " "+rate+"");
			exchange();
		})
		
		function exchange(){
			let amount = $('#amtID').val();
			if( !isNaN(amount) ){
				var value = amount*xchange;
				$('#rateValue').html("₦"+amount+".00 ≈ " + symbol + "" + value + " [" + currency + "]");
			}
		}
		
		let minAmt = Number({{ $plans[0]['min_amount'] }});
		let maxAmt = Number({{ $maxAmt }});

        function onOk() {
            var money = $('#amtID').val();

            if (money < minAmt || money > maxAmt) {
                Toast("Sorry, the deposit amount is not within the range");
                return false;
            }
			
			loading.showLoading({type: 3,tip: "loading.."});
			$("#depositForm").submit();
        }
    </script>
@endpush
