@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/recharge.css') }}{{$catch}}">
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/signin.css') }}{{$catch}}">
@endpush

@section('content')
	<div class="navbar" style="background:transparent">
		<span style="cursor: pointer;" onclick="onJump(&#39;{{ route('user.deposit.history') }}&#39;)"><i></i></span>
		<span></span>
		<span></span>
	</div>

	<div style="">
		<div style="width: 100%; margin: 0 auto; text-align: center;  position: relative; height: auto; overflow: hidden; background-image: linear-gradient(to top, rgba(255, 0, 0, 0), rgb(221 170 170));">
			<img src="{{ asset('assets/images/crypto-pay.png') }}" style=" width:100%;">
		</div>
		<div class="about" style="padding:10px;"></div>
	</div>

    <div class="recharge-wrap">
        <div class="centnen">
            <form action="" method="POST" enctype="multipart/form-data" id="payProof" class="wrap">

                <div class="tips-box">
                    <h2>
                        <img src="{{ asset($activeTemplateTrue.'img/ic_help@2x.png') }}" alt=""> Complete your deposit and wait.
                    </h2>
                    <p>
						While the system verifies yours payment. But if you have any payment made and not yet verified after 2 hours kindly contact support.
                    </p>
                </div>

				<ul class="listss" style="width: 100%; margin: 0 auto; position: relative; margin-top: 10px; height: auto; overflow: hidden; padding-top:10px; padding-bottom:24px;" id="itemlist">
				
					<li style="height:auto;padding-top:4px;overflow:hidden;color:#333;background:#2E333E;margin:0 auto; width:100%;border-radius: 5px; margin-top:10px;padding-bottom:15px;border-bottom:1px solid #eee;">
						<div style="padding:1px;">
							<div style="float:left;width:45%; margin-left:5%">
								<div style="height:27px; line-height:27px;">
									<span style="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; font-weight:bold;color: #fff;">{{ config('settings')->account_name }}</span>
								</div>
								<div style="height:27px; line-height:27px;">
									<span style="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; color: #fff;">RECEPIENT</span>
								</div>
								<div style="height:17px; line-height:27px;font-size:14px;color:#999;">Account number</div>
								<div style="height:27px; line-height:30px;font-size:18px; color:#999;">{{ config('settings')->account_number }}</div>
							</div>
							<div style="float:left;width:45%; text-align:right; margin-right:5%">
								<div style="height:27px; line-height:27px; font-size:20px; font-family: Roboto Condensed-Regular,Roboto Condensed;font-weight: 400;color: #ddaaaa;">{{ config('settings')->bank_name }}</div>
								<div style="height:27px; line-height:27px;font-size:12px;color:#999;margin-top:-7px;">&nbsp;Bank name</div>
								<div class="" style="height:27px; line-height:27px;font-size:12px;color:#999;"></div>
								<span style="display:none">{{ config('settings')->account_number }}</span>
								<span role="copy" style="font-size:12px;color:#999;margin-top:-7px;cursor:pointer;border-radius:3px;padding:2px 4px;font-weight:900;border:1px solid #db5757;color:#e1e1b4;">COPY</span>
							</div>
						</div>
					</li>
				
					<li style="height:auto;padding-top:4px;overflow:hidden;color:#333;background:#2E333E;margin:0 auto; width:100%;border-radius: 5px; margin-top:10px;padding-bottom:2px;border-bottom:1px solid #eee;">
						<div style="padding:1px;">
							<div style="float:left;width:38%; margin-left:5%">
								<div style="height:27px; line-height:27px;">
									<span style ="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; font-weight:bold;color: #fff;">PAY AMOUNT</span>
								</div>
								<div style="height:8px; line-height:8px; font-size:10px; color:#999;">{{ $data->currency }}</div>
							</div>

							<div style="float:left;width:35%; text-align:right;">
								<div style="height:27px; line-height:27px; font-size:20px; font-family: Roboto Condensed-Regular,Roboto Condensed;font-weight: 400;color: #ddaaaa;">{{ config('settings')->cur_sym }}{{ number_format($data['final_amo'], 0, '', '') }}</div>
								<span style="display:none">{{ ($data['final_amo']+0) }}</span>
								<span role="copy" style="font-size:12px;color:#999;margin-top:-7px;cursor:pointer;border-radius:3px;padding:2px 4px;font-weight:900;border:1px solid #db5757;color:#e1e1b4;">COPY</span>
							</div>

							<div style="float:left;width:20%; text-align:right; margin-right:2%">
								<div class="title" style="padding: 5px;background: #fff;float: right;margin: 5px;border-radius: 5px;text-align: -webkit-center;justify-content: center;width: 50px;display: flex;">
									<div>
										<img src="{{ asset('assets/app/img/hourglass.svg') }}" alt="hourglass" style="width:24px;">

										<!-- countdown container -->
										<span data-v-385ac480="" id="count-down"><span class="minutes">23</span>:<span class="seconds">53</span></span>
									</div>
								</div>
							</div>

						</div>
					</li>

					<li style="height:auto;padding-top:4px;overflow:hidden;color:#333;background:#2E333E;margin:0 auto; width:100%;border-radius: 5px; margin-top:10px;padding-bottom:15px;border-bottom:1px solid #eee;">
						<div style="padding:1px;">
							<div style="float:left;width:45%; margin-left:5%">
								<div style="height:27px; line-height:27px;">
									<span style ="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; font-weight:bold;color: #fff;">NARRATION</span>
								</div>
								<div style="height:8px; line-height:8px; font-size:10px; color:#999;">Use this payment description</div>
							</div>
							<div style="float:left;width:48%; text-align:right;">
								<div style="height:27px; line-height:27px; font-size:20px; font-family: Roboto Condensed-Regular,Roboto Condensed;font-weight: 400;color: #ddaaaa;">{{ $data['trx'] }}</div>
								<span role="copy" style="font-size:12px;color:#999;margin-top:-7px;cursor:pointer;border-radius:3px;padding:2px 4px;font-weight:900;border:1px solid #db5757;color:#e1e1b4;">COPY</span>
							</div>

						</div>
					</li>

					<li>
						<div class="signin-wrap" style="min-height:50px;padding:.32rem 0"> 
							<p style="color:#fff;">Step three: Proof of payment</p>
							<div class="text" style="margin-bottom:0px;border-bottom: 1px solid #fff;background: #2e333e;padding: 5px;border-radius: 5px;">
								<ul>
								@if ($method->gateway_parameter)
									@foreach (json_decode($method->gateway_parameter) as $k => $v)
										@if ($v->type == 'text')
										<li class="form-title" style="margin-top: 10px;">{{ __($v->field_level) }}</li>
										<li class="li ones">
											<input type="text" name="{{ $k }}" value="{{ old($k) }}" placeholder="{{ __($v->field_level) }}" autocomplete="off" class="van-field__control" />
											<p></p> 
										</li>
										@elseif($v->type == 'file')
										<li class="form-title" style="margin-top: 0px;">Select {{ __(inputTitle($v->field_level)) }}</li>
										<li class="li ones">
											<input type="file" accept="image/*" name="{{ $k }}" value="{{ old($k) }}" placeholder="{{ __($v->field_level) }}" autocomplete="off" class="van-field__control" />
											<p></p> 
										</li>
										@endif
									@endforeach
								@endif
								</ul>
							</div>
						</div>
					</li>
					
					@csrf
				</ul>
				
				<div type="submit" onclick='postForm()' class="btn">I have made payment</div>

                <div class="tips-box">
                    <h2>
                        <img src="{{ asset($activeTemplateTrue.'img/ic_help@2x.png') }}" alt=""> Payment Guide.
                    </h2>
                    <p>Open your bank app and make the transfer, Copy the bank account shown below and input the amount shown above.</p>
                </div>

			</form>

		</div>
	</div>

	<script src="{{ asset('assets/app/js/copypaste.js') }}{{ $catch}}"></script>
	<script src="{{ asset('assets/app/js/pageTimeOut.js') }}"></script>
	<script>
		pageTimeOutCountDown({
			initialValue: 596,
			redirectTo: "{{ route('user.home') }}",
			containerId: 'count-down'
		});
		
		function postForm(){
			hsycms.loading('loading.');
			$("#payProof").submit();
		}
	</script>
@endsection
