@extends('layouts.users')


@section('content')


    <body class="depositPage bgfff">
        <div class="app h5MaxWidth">
            <header class="isScrollTo noColor">
                <div class="header h5MaxWidth clear display alignCenter">
                    <a class="back iconfont icon-arrow-left-2" onclick="window.history.go(-1); return false;"></a>
                    <h2 class="flex1">Deposit</h2>
                </div>
            </header>
            <div class="topRegion radius003030PX">
                <div class="statistics">
                    <ul class="display alignCenter">
                        <li class="balance">
                            <p><em class='currency'>₦</em> {{ number_format(auth()->user()->balance) }}</p>
                            <span>Deposit balance</span>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="main">
                <div class="deposit forms">
                    <form id="login" action="{{ route('user.deposit.gtrpay') }}" method="post">
                        <input type="hidden" name="deposit_method" value="102">
                        <input type="hidden" name="currency" value="NGN">
                        <ul>
                            <li>
                                <div class="titleBar display alignCenter justifyDetween">
                                    <div>
                                        <h3>Deposit amount</h3>
                                    </div>
                                </div>
                                <div class="inputArea radius7PX display alignCenter">
                                    <div class="leftSideBox display alignCenter">
                                        <i class="i_inputIcon iconfont icon-money-receive-01"></i>
                                    </div>
                                    <div class="trueInpt display alignCenter flex1">
                                        <input type="number" name="amount" id="itemPrice" class="amount fillArea flex1"
                                            placeholder="Deposit Amount" maxlength="10" oninput="oninputVal(event)" />
                                    </div>
                                </div>
                            </li>

                            <li>
                                <div class="titleBar display alignCenter justifyDetween">
                                    <div>
                                        <h3>Quick amount</h3>
                                    </div>
                                </div>
                                <div class="quickAmount" id="quickAmount">
                                    <ol class="display alignCenter">

                                        @foreach ($plans as $plan)
                                            <li class="item" data-amount="{{ $plan->min_amount }}">
                                                <div class="radius7PX"><em class='currency'>₦</em>{{ $plan->min_amount }}
                                                </div>
                                            </li>
                                        @endforeach
                                    </ol>
                                </div>
                            </li>

                        </ul>
                        <div class="actionBar display alignCenter alignStretch justifyEnd">
                            <button type="submit" id="submitBtn" onclick="disableButton()" style="background: transparent; border:none;">
                                <div class="drawmoneyBtn clickBtn radius50P display alignCenter justifyCenter">
                                    <p>To Deposit <i class="iconfont icon-arrow-right-3"></i></p>
                                </div>
                            </button>
                        </div>
                    </form>
                </div>

                <div class="tipsBox">
                    <div id="tips" class="tips">
                        <div class="title">
                            <h3>Explain</h3>
                        </div>
                        <div class="explain">
                            {{--  <p style="color: red;">1. Please remember to fill in
                                the 12 digit UTR code for successful deposit</p>  --}}
                            <p style="color: red;"><strong>1. Please do not modify the deposit
                                    amount. Unauthorized modification of the
                                    deposit amount will result in the deposit
                                    not being credited</strong></p>
                            <p>2. Minimum deposit: NGN 1000</p>
                            <p>3. Deposit received within 5 minutes, if not
                                received within 5 minutes, please contact online
                                customer service for processing</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="{{ asset('users/js/common.js') }}" type="text/javascript"></script>
        <script src="{{ asset('users/js/swiper.min.js') }}" type="text/javascript"></script>
        <script src="{{ asset('users/js/hSdrop.js') }}" type="text/javascript"></script>
        <script src="{{ asset('users/js/js-sdk.js') }}" type="text/javascript"></script>
        <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
        <script type="text/javascript">
            // Handle click event on items
            $('.item').click(function() {
                var itemPrice = $(this).data('amount');

                // Update input fields with clicked item details
                $('#itemPrice').val(itemPrice);
            });



            $(document.body).on("click", "#quickAmount>ol li", function() {
                $("#amount").val($(this).data('amount'));
                // $("#quickAmount>ol li").removeClass('activate')
                $(this).addClass('activate')
                $(this).addClass('activate').siblings().removeClass('activate');
            })
        </script>
    </body>
@endsection
