@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/recharge.css') }}{{$catch}}">
@endpush

@section('content')
	<div class="navbar" style="background:transparent">
		<span style="cursor: pointer;" onclick="onJump(&#39;{{ route('user.deposit.history') }}&#39;)"><i></i></span>
		<span></span>
		<span></span>
	</div>

	<div style="">
		<div style="width: 100%; margin: 0 auto; text-align: center;  position: relative; height: auto; overflow: hidden; background-image: linear-gradient(to top, rgba(255, 0, 0, 0), rgb(221 170 170));">
			<img src="{{ asset('assets/images/crypto-pay.png') }}" style=" width:100%;">
		</div>
		<div class="about" style="padding:10px;"></div>
	</div>
    <div class="recharge-wrap">

        <div class="centnen">
            <div class="wrap">
                <div class="tips-box">
                    <h2>
                        <img src="{{ asset($activeTemplateTrue.'img/ic_help@2x.png') }}" alt=""> Complete your deposit and wait.
                    </h2>
                    <p>
						While the system verifies yours payment. But if you have any payment made and not yet verified after 2 hours kindly contact support.
                    </p>
                </div>
				
				<ul class="listss" style="width: 100%; margin: 0 auto; position: relative; margin-top: 10px; height: auto; overflow: hidden; padding-top:10px; padding-bottom:24px;" id="itemlist">
				
					<li style="height:auto;padding-top:4px;overflow:hidden;color:#333;background:#2E333E;margin:0 auto; width:100%;border-radius: 5px; margin-top:10px;padding-bottom:15px;border-bottom:1px solid #eee;">
						<div style="padding:1px;">
							<div style="float:left;width:45%; margin-left:5%">
								<div style="height:27px; line-height:27px;">
									<span style="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; font-weight:bold;color: #fff;">GET AMOUNT</span>
								</div>
								<div style="height:27px; line-height:27px;">
									<span style="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; color: #fff;">{{ $deposit->trx }}</span>
								</div>
								<div style="height:27px; line-height:27px;font-size:12px;color:#999;">Charge: {{ config('settings')->cur_sym }}{{ showAmount($deposit->charge) }}</div>
								<div style="height:27px; line-height:27px;font-size:12px; color:#999;">{{ $deposit->created_at->format('dS F Y, H:i') }}</div>
							</div>
							<div style="float:left;width:45%; text-align:right; margin-right:5%">
								<div style="height:27px; line-height:27px; font-size:20px; font-family: Roboto Condensed-Regular,Roboto Condensed;font-weight: 400;color: #ddaaaa;">{{ config('settings')->cur_sym }}{{showAmount($deposit->amount,0)}}</div>
								<div style="height:27px; line-height:27px;font-size:12px;color:#999;margin-top:-7px;">&nbsp;amount</div>
								<div class="" style="height:27px; line-height:27px;font-size:12px;color:#999;"></div>
								<div style="height:27px; line-height:27px;font-size:12px;color:#999;margin-top:-7px;">Currency: <span style="font-weight:900;">{{ $deposit->method_currency }}</span></div>
							</div>
						</div>
					</li>
				
					<li style="height:auto;padding-top:4px;overflow:hidden;color:#333;background:#2E333E;margin:0 auto; width:100%;border-radius: 5px; margin-top:10px;padding-bottom:15px;border-bottom:1px solid #eee;">
						<div style="padding:1px;">
							<div style="float:left;width:30%; margin-left:5%">
								<div style="height:27px; line-height:27px;">
									<span style ="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; font-weight:bold;color: #fff;">PAY AMOUNT</span>
								</div>
							</div>
							<div style="float:left;width:44%; text-align:right;">
								<div style="height:27px; line-height:27px; font-size:20px; font-family: Roboto Condensed-Regular,Roboto Condensed;font-weight: 400;color: #ddaaaa;">{{ ($deposit->btc_amo + 0) }}</div>
							</div>

							<div style="float:left;width:15%; text-align:right; margin-right:5%">
								<div style="height:8px; line-height:8px; font-size:10px;"></div>
								<span style="display:none">{{ ($deposit->btc_amo + 0) }}</span>
								<span role="copy" style="font-size:12px;color:#999;margin-top:-7px;cursor:pointer;border-radius:3px;padding:2px 4px;font-weight:900;border:1px solid #db5757;color:#e1e1b4;">COPY</span>
							</div>
						</div>
					</li>
					
					<?php $network = json_decode($deposit->gatewayCurrency()->gateway_parameter); ?>

					<li style="height:auto;padding-top:4px;overflow:hidden;color:#333;background:#2E333E;margin:0 auto; width:100%;border-radius: 5px; margin-top:10px;padding-bottom:15px;border-bottom:1px solid #eee;">
						<div style="padding:1px;">
							<div style="float:left;width:38%; margin-left:5%">
								<div style="height:27px; line-height:27px;">
									<span style ="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; font-weight:bold;color: #fff;">NETWORK</span>
								</div>
								<div style="height:27px; line-height:27px;">
									<span style ="padding:3px; padding-left: 0px;padding-right:10px;border-radius: 10px; font-weight:bold;color: #fff;">{{ substr($deposit->btc_wallet, 0, 5) . str_repeat('*', 4) . substr($deposit->btc_wallet, -10) }}</span>
								</div>
								<div style="height:auto; line-height:2px;font-size:12px; color:#999;">wallet address</div>
							</div>

							<div style="float:left;width:35%; text-align:right;">
								<div style="height:27px; line-height:27px; font-size:20px; font-family: Roboto Condensed-Regular,Roboto Condensed;font-weight: 400;color: #ddaaaa;">{{ $network->network }}</div>
								<span style="display:none">{{ $deposit->btc_wallet }}</span>
								<span role="copy" style="height:27px; line-height:27px;font-size:12px;color:#999;margin-top:2px;cursor:pointer;border-radius:3px;padding:2px 4px;font-weight:900;border:1px solid #db5757;color:#e1e1b4;">COPY</span>
							</div>

							<div style="float:left;width:20%; text-align:right; margin-right:2%">
								<div class="title" style="padding: 5px;background: #fff;float: right;margin: 5px;border-radius: 5px;text-align: -webkit-center;justify-content: center;width: 50px;display: flex;">
									<div>
										<img src="{{ asset('assets/app/img/hourglass.svg') }}" alt="hourglass" style="width:24px;">

										<!-- countdown container -->
										<span data-v-385ac480="" id="count-down"><span class="minutes">23</span>:<span class="seconds">53</span></span>
									</div>
								</div>
							</div>

						</div>
					</li>
					<li style="margin-top:5px;">
						<div class="getQRcodeBtn clickBtn radius7PX flex3 display alignCenter justifyCenter" id="getQRC" onclick="getQRC()" style="font-size:16px;justify-content:center;padding:10px;color:#000;border-radius: 0 0 .75rem .75rem;background: #d7dfe5;">
							@lang('SCAN QR CODE')
						</div>
					</li>
					
				</ul>

				<!-- submit button -->
				<div class="btn confirmPay" onclick="confirmBox('CONFIRM PAYMENT','Are you sure you have made the payment of {{number_format($deposit->final_amo, 4)}} USDT to the generated wallet address?, click go ahead to verify payment.','{{ route('user.home') }}');" > I'VE PAID NOW</div>
			</div>
			
		</div>
	</div>

@endsection

@push('script')
	<script src="{{ asset('assets/app/js/copypaste.js') }}{{ $catch}}"></script>
	<script src="{{ asset('assets/app/js/pageTimeOut.js') }}{{ $catch}}"></script>
	<script src="{{ asset('users/js/jqueryqr.js') }}" type="text/javascript"></script>
	<script src="{{ asset('users/js/qrcode.js') }}" type="text/javascript"></script>

	<script>
		initializeClock({
			redirectTo: "{{ route('user.home') }}",
			container: 'count-down',
			deadline: new Date(Date.parse('{{$data->initiate}}'))
		});
		
		function getQRC() {
			var QRCodeHtml = ""
			QRCodeHtml += `<div id="invitationQRCode"><canvas width="400" height="400"></canvas></div>
			<div class="explain"></div>`;
			prompt('', QRCodeHtml, "QRCode", 1);

			$('#invitationQRCode').erweima({
				mode: 2,
				mSize: 8,
				image: $("#QRCLogo")[0],
				text: '{{ $deposit->btc_wallet }}',
			});
			$(".cancelBtn").on("click", function() {
				removePrompt("QRCode")
			})
		}
		
    </script>
@endpush