@extends($activeTemplate.'layouts.users')

@push('style')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/team.css') }}{{$catch}}">
@endpush

@section('content')
    <uni-app class="uni-app--showtabbar uni-app--maxwidth">
		<?php $authUser = 0; ?>
        <uni-page data-page="pages/index/team">
            <uni-page-wrapper class="vithw">
                <uni-page-body>
                    <uni-view data-v-e5ca8920="" class="content">
                        <uni-view data-v-e5ca8920="" class="pg-top">
							<img data-v-e5ca8920="" mode="aspectFit" src="{{getImage(imagePath()['logoIcon']['path'] .'/logo.png')}}{{$catch}}" style="height: 25px;">
						</uni-view>
                        <uni-view data-v-e5ca8920="" class="container">
                            <p data-v-e5ca8920="">Invite Friends</p>
                            <p data-v-e5ca8920="">Get Rewards</p>
							<img data-v-e5ca8920="" src="{{ asset($activeTemplateTrue.'img/team0.png') }}" style="width: 100px; height: 100px; border-radius: 50%; background-color: rgb(255, 252, 246); margin-top: 90px; border: 1px solid rgb(242, 182, 65);">
							<h4 data-v-e5ca8920="" style="margin-top: 5px; color: rgb(246, 81, 0); margin-bottom: 50px;">New Employees</h4>
                        </uni-view>

                        <uni-view data-v-e5ca8920="" class="content-inset">
                            <uni-view data-v-e5ca8920="" class="card">
                                <uni-view data-v-c9bbff92="" data-v-e5ca8920="" class="invite-container" style="margin-top: 5px;">
                                    <uni-view data-v-c9bbff92="" class="shu"></uni-view>
                                    <uni-view data-v-c9bbff92="" class="row">
										<img data-v-c9bbff92="" src="{{ asset($activeTemplateTrue.'img/step1.png') }}" class="icon">
                                        <uni-view data-v-c9bbff92="" class="input-tip">Share link invite friends</uni-view>
                                    </uni-view>
                                    <uni-view data-v-c9bbff92="" class="row">
										<img data-v-c9bbff92="" src="{{ asset($activeTemplateTrue.'img/step2.png') }}" class="icon">
                                        <uni-view data-v-c9bbff92="" class="input-tip">Register and purchase a miner</uni-view>
                                    </uni-view>
                                    <uni-view data-v-c9bbff92="" class="row">
										<img data-v-c9bbff92="" src="{{ asset($activeTemplateTrue.'img/step3.png') }}" class="icon">
                                        <uni-view data-v-c9bbff92="" class="input-tip">Rebate bonus</uni-view>
                                    </uni-view>
                                </uni-view>
								
                                <uni-view data-v-e5ca8920="" class="invite">
                                    <uni-view data-v-e5ca8920="" class="invite-operate"><span data-v-e5ca8920="">ID</span><span data-v-e5ca8920="" id="copy" class="color-linear2">{{ $user->id }}</span></uni-view>
                                    <uni-view data-v-e5ca8920="" class="invite-operate">
										<span data-v-e5ca8920="">Code</span>
										<span data-v-e5ca8920="" id="copy" class="color-linear2">{{ $code }}</span>
                                        <uni-image data-v-e5ca8920="" onclick="copy('{{ $code }}')" style="width: 20px; height: 20px; flex-shrink: 0;">
                                            <div style="background-image: url(&quot;{{ asset($activeTemplateTrue.'img/copy.png') }}&quot;); background-position: 0% 0%; background-size: 100% 100%; background-repeat: no-repeat;"></div>
                                            <img src="{{ asset($activeTemplateTrue.'img/copy.png') }}" draggable="false">
										</uni-image>
                                    </uni-view>
									
                                    <uni-view data-v-e5ca8920="" class="invite-operate">
										<span data-v-e5ca8920="">Link</span>
										<span data-v-e5ca8920="" class="my-link color-linear2">{{ $link }}</span>
                                        <uni-image data-v-e5ca8920="" onclick="copy('{{ $link }}')" style="width: 20px; height: 20px; flex-shrink: 0;">
                                            <div style="background-image: url(&quot;{{ asset($activeTemplateTrue.'img/copy.png') }}&quot;); background-position: 0% 0%; background-size: 100% 100%; background-repeat: no-repeat;"></div>
                                            <img src="{{ asset($activeTemplateTrue.'img/copy.png') }}" draggable="false">
										</uni-image>
                                    </uni-view>
									
                                    <uni-button data-v-e5ca8920="" class="hero-button invite-now shareLink" type="primary">Invite Friends</uni-button>
                                </uni-view>
                            </uni-view>
							
                            <uni-view data-v-e5ca8920="" class="card" style="margin-top: 15px;">
                                <p data-v-e5ca8920="" major-title="true">Team Details</p>
                                <uni-view data-v-3ad70c0d="" data-v-e5ca8920="" class="uni-grid-wrap">
                                    <uni-view data-v-3ad70c0d="" id="Uni_gw1a" class="uni-grid" style="border-left-color: rgb(210, 210, 210);">
                                        <uni-view data-v-4336d7d8="" data-v-e5ca8920="" class="uni-grid-item" style="width: 104px; height: 104px;">
                                            <uni-view data-v-4336d7d8="" class="uni-grid-item__box uni-highlight" style="border-right-color: rgb(210, 210, 210); border-bottom-color: rgb(210, 210, 210); border-top-color: rgb(210, 210, 210);">
                                                <uni-view data-v-e5ca8920="" class="my-invite-code"><span data-v-e5ca8920="">Total members</span>
                                                    <p data-v-e5ca8920="">{{ $totalReferral }}</p>
                                                </uni-view>
                                            </uni-view>
                                        </uni-view>
                                        <uni-view data-v-4336d7d8="" data-v-e5ca8920="" class="uni-grid-item" style="width: 104px; height: 104px;">
                                            <uni-view data-v-4336d7d8="" class="uni-grid-item__box uni-highlight" style="border-right-color: rgb(210, 210, 210); border-bottom-color: rgb(210, 210, 210); border-top-color: rgb(210, 210, 210);">
                                                <uni-view data-v-e5ca8920="" class="my-invite-code"><span data-v-e5ca8920="">Total commission</span>
                                                    <p data-v-e5ca8920="">{{ config('settings')->cur_sym }}{{ showAmount($user->referral,0) }}</p>
                                                </uni-view>
                                            </uni-view>
                                        </uni-view>
                                        <uni-view data-v-4336d7d8="" data-v-e5ca8920="" class="uni-grid-item" style="width: 104px; height: 104px;">
                                            <uni-view data-v-4336d7d8="" class="uni-grid-item__box uni-highlight" style="border-right-color: rgb(210, 210, 210); border-bottom-color: rgb(210, 210, 210); border-top-color: rgb(210, 210, 210);">
                                                <uni-view data-v-e5ca8920="" class="my-invite-code"><span data-v-e5ca8920="">Members renting miners</span>
                                                    <p data-v-e5ca8920="" id="authenticated">0</p>
                                                </uni-view>
                                            </uni-view>
                                        </uni-view>
										
										@foreach($levels as $level)
											@php $LevelEarn = \App\Models\Transaction::where('type', 'commission')->where('user_id', $user->id)->where('ref_level', $level->level); @endphp
											@php $gAmount = $LevelEarn->sum('amount'); @endphp
											<uni-view data-v-4336d7d8="" data-v-e5ca8920="" class="uni-grid-item" style="width: 104px; height: 104px;">
												<uni-view data-v-4336d7d8="" class="uni-grid-item__box uni-highlight" style="border-right-color: rgb(210, 210, 210); border-bottom-color: rgb(210, 210, 210); border-top-color: rgb(210, 210, 210);">
													<uni-view data-v-e5ca8920="" class="my-invite-code"><span data-v-e5ca8920="">level {{$level->level}}, {{$LevelEarn->count()}} users</span>
														<p data-v-e5ca8920="">{{ config('settings')->cur_sym }}{{ showAmount((($gAmount*100)/$level->percent), 0) }}</p>
													</uni-view>
													<?php $authUser += $LevelEarn->count(); ?>
												</uni-view>
											</uni-view>
										@endforeach
										
										
                                    </uni-view>
                                </uni-view>
                                <uni-button data-v-e5ca8920="" class="hero-button invite-now linkBTN" data-href="{{route('user.agents.level', 1)}}" type="primary">View Team Members </uni-button>
                            </uni-view>

							
                            <uni-view data-v-e5ca8920="" class="card invite_rules">
                                <p data-v-e5ca8920="" major-title="true" style="margin-bottom: 10px;">Invitation rules</p>
                                <p data-v-e5ca8920="">Invite more users to increase the computing power of the mining pool to get more rewards.</p>

                                <p data-v-e5ca8920="" style="margin-top: 25px;">Specific rules:</p>

								@if( isset($levels[0]) )
                                <p data-v-e5ca8920="">User invites Level 1 users to get {{$levels[0]->percent}}% revenue.</p>
								@endif
								@if( isset($levels[1]) )
                                <p data-v-e5ca8920="">User invites Level 2 users to get {{$levels[1]->percent}}% revenue.</p>
								@endif
								@if( isset($levels[2]) )
                                <p data-v-e5ca8920="">User invites Level 3 users to get {{$levels[2]->percent}}% revenue.</p>
								@endif
                                <p data-v-e5ca8920="">Additional computing power rewards can be also be obtained during the user invitation process.</p>
                            </uni-view>
                        </uni-view>
						
                        <uni-view data-v-6be04898="" data-v-e5ca8920="">
                            <uni-view data-v-6be04898="" class="flex_row_c_c modalView">
                                <uni-view data-v-6be04898="" class="flex_column">
                                    <uni-view data-v-6be04898="" class="backgroundColor-white padding1vh border_radius_10px">
                                        <uni-image data-v-6be04898="" id="poster" class="posterImage">
                                            <div style="background-image: none; background-size: 100% 100%; background-repeat: no-repeat;"></div>
                                            <uni-resize-sensor>
                                                <div>
                                                    <div></div>
                                                </div>
                                                <div>
                                                    <div></div>
                                                </div>
                                            </uni-resize-sensor>
                                        </uni-image>
                                    </uni-view>
                                    <uni-view data-v-6be04898="" class="flex_row marginTop2vh">
                                        <uni-button data-v-6be04898="" class="saveButton" type="default" size="mini">Save Picture</uni-button>
                                    </uni-view>
                                </uni-view>
                            </uni-view>
                        </uni-view>
						

                        <uni-view data-v-79177165="" data-v-302f3c1e="" data-v-e5ca8920="" class="uni-popup bottom shareDiv"  border-radius="20px 20px 0 0">
                            <uni-view data-v-79177165="">
                                <uni-view data-v-acf5fb64="" data-v-79177165="" class="shareMask" name="mask" style="opacity: 1; position: fixed; inset: 0px; background-color: rgba(0, 0, 0, 0.4); transition: opacity 300ms, -webkit-transform 300ms, transform 300ms; transform-origin: 50% 50%;"></uni-view>
                                <uni-view data-v-acf5fb64="" data-v-79177165="" class="" name="content" style="transform: translateY(0px); opacity: 1; position: fixed; left: 0px; right: 0px; bottom: 0px; padding-bottom: 0px; background-color: transparent; transition: -webkit-transform 300ms, transform 300ms; transform-origin: 50% 50%;">
                                    <uni-view data-v-79177165="" class="uni-popup__wrapper bottom" style="background-color: transparent;">
                                        <uni-view data-v-302f3c1e="" style="height: 180px; width: 100%; background-color: white;">
                                            <p data-v-302f3c1e="" style="text-align: center; margin: 25px 0px; transform: translateY(10px);">Share To</p>
                                            <uni-scroll-view data-v-302f3c1e="" style="width: 100%;">
                                                <div class="uni-scroll-view">
                                                    <div class="uni-scroll-view" style="overflow: auto hidden;">
                                                        <div class="uni-scroll-view-content">
                                                            <uni-view data-v-302f3c1e="" style="display: flex; flex-wrap: nowrap;">
															
                                                                <uni-view data-v-302f3c1e="" class="socialHandle" data-href="https://www.facebook.com/sharer/sharer.php?u={{$link}}%26feature%3Dshare" style="width: calc(22.22%); flex-shrink: 0;">
                                                                    <uni-view data-v-302f3c1e="" style="display: flex; flex-direction: column; align-items: center;">
																		<img data-v-302f3c1e="" src="{{ asset($activeTemplateTrue.'img/Facebook.png') }}" style="height: 40px; width: 40px;">
																		<span data-v-302f3c1e="" style="font-size: 13px;">Facebook</span>
																	</uni-view>
                                                                </uni-view>
																
                                                                <uni-view data-v-302f3c1e="" class="socialHandle" data-href="https://t.me/share/url?url={{$link}}" style="width: calc(22.22%); flex-shrink: 0;">
                                                                    <uni-view data-v-302f3c1e="" style="display: flex; flex-direction: column; align-items: center;">
																		<img data-v-302f3c1e="" src="{{ asset($activeTemplateTrue.'img/Telegram.png') }}" style="height: 40px; width: 40px;">
																		<span data-v-302f3c1e="" style="font-size: 13px;">Telegram</span>
																	</uni-view>
                                                                </uni-view>
																
                                                                <uni-view data-v-302f3c1e="" class="socialHandle" data-href="https://line.me/R/share?text={{$link}}" style="width: calc(22.22%); flex-shrink: 0;">
                                                                    <uni-view data-v-302f3c1e="" style="display: flex; flex-direction: column; align-items: center;">
																		<img data-v-302f3c1e="" src="{{ asset($activeTemplateTrue.'img/LINE.png') }}" style="height: 40px; width: 40px;">
																		<span data-v-302f3c1e="" style="font-size: 13px;">LINE</span>
																	</uni-view>
                                                                </uni-view>
																
                                                                <uni-view data-v-302f3c1e="" class="socialHandle" data-href="https://wa.me/?text={{$link}}" style="width: calc(22.22%); flex-shrink: 0;">
                                                                    <uni-view data-v-302f3c1e="" style="display: flex; flex-direction: column; align-items: center;">
																		<img data-v-302f3c1e="" src="{{ asset($activeTemplateTrue.'img/WhatsApp.png') }}" style="height: 40px; width: 40px;">
																		<span data-v-302f3c1e="" style="font-size: 13px;">WhatsApp</span>
																	</uni-view>
                                                                </uni-view>
																
                                                                <uni-view data-v-302f3c1e="" class="socialHandle" data-href="https://x.com/intent/tweet?url={{$link}}%26feature%3Dshare&text=Join me and earn big with the new platform&via={{ config('settings')->sitename }}" style="width: calc(22.22%); flex-shrink: 0;">
                                                                    <uni-view data-v-302f3c1e="" style="display: flex; flex-direction: column; align-items: center;">
																		<img data-v-302f3c1e="" src="{{ asset($activeTemplateTrue.'img/x.avif') }}" style="border-radius:12px;height: 40px; width: 40px;">
																		<span data-v-302f3c1e="" style="font-size: 13px;">X [Twitter]</span>
																	</uni-view>
                                                                </uni-view>

                                                                <uni-view data-v-302f3c1e="" class="socialHandle" data-href="https://www.tiktok.com/share?url={{$link}}" style="width: calc(22.22%); flex-shrink: 0;">
                                                                    <uni-view data-v-302f3c1e="" style="display: flex; flex-direction: column; align-items: center;">
																		<img data-v-302f3c1e="" src="{{ asset($activeTemplateTrue.'img/tiktok.png') }}" style="height: 40px; width: 40px;">
																		<span data-v-302f3c1e="" style="font-size: 13px;">TikTok</span>
																	</uni-view>
                                                                </uni-view>
                                                            </uni-view>
                                                        </div>
                                                    </div>
                                                </div>
                                            </uni-scroll-view>
                                        </uni-view>
                                    </uni-view>
                                </uni-view>
                            </uni-view>
                        </uni-view>
						
                    </uni-view>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>
		
		@include($activeTemplate.'layouts.menu',['activeLink'=>'team'])
	</uni-app>
@endsection


@push('script')
<script>
	$(document).ready(function() {
		var ucont = '{{$authUser}}';
		$('#authenticated').html(ucont);
		
		$(".shareMask").click(function () {
			$('.shareDiv').fadeOut();
			$('body,html').css({
				overflow: 'scroll'
			})
		});

		$(".shareLink").click(function () {

			$('.shareDiv').fadeIn();
			$('body,html').css({
				overflow: 'hidden'
			})
			
			$('.shareDiv').show();

		});
		
	});
	
</script>
@endpush