@extends($activeTemplate.'layouts.users')

@push('style-lib')
	<link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/withdraw.css') }}{{$catch}}">
@endpush

@section('content')
    <uni-app class="uni-app--maxwidth">
		@php
			$accountNumber = ($user->bankAccount) ? $user->bankAccount->account_number : 'CRYPTO';
			$accountName = ($user->bankAccount) ? explode(' ', $user->bankAccount->account_name)[0] : $user->withdrawal_usdt_address;
			$bankName = ($user->bankAccount) ? $user->bankAccount->bank_name : 'USDT';
		@endphp
        <uni-page data-page="pages/record/withdraw">
			<uni-page-wrapper class="cpKljEd">
            <uni-page-wrapper>
                <uni-page-body>
                    <uni-view data-v-5c2fef75="">
                        <uni-view data-v-58cb4ed7="" data-v-5c2fef75="" class="back-title">
							<span data-v-58cb4ed7="" data-href="{{ route('user.profile') }}" class="linkBTN"></span>
							<span data-v-58cb4ed7="" class="title-txt">Transfer Out</span>
							<span data-v-58cb4ed7="" data-href="{{ route('user.withdraw.history') }}" class="linkBTN"><img src="{{ asset($activeTemplateTrue.'img/detail.png') }}" style="width:24px" /></span>
						</uni-view>
						
                        <uni-view data-v-5c2fef75="" class="content">
                            <uni-view data-v-5c2fef75="" class="color-bg"></uni-view>
                            <uni-view data-v-5c2fef75="" class="withdraw-title" style="display:none">
                                <uni-view data-v-5c2fef75="" data-currency="NGN" data-symbol="₦" data-rate="1.00" data-exchange="1.00" data-other="₦" class="active tabs"><span data-v-5c2fef75="">NGN</span></uni-view>
                                <uni-view data-v-5c2fef75="" data-currency="USDT" data-symbol="₮" data-rate="{{ config('settings')->usdt_to_ngn }}" data-other="₦" data-exchange="{{ config('settings')->ngn_to_usdt }}" class="tabs"><span data-v-5c2fef75="">USDT</span></uni-view>
                            </uni-view>
							
                            <form method="post" action="{{ route('user.withdraw.money') }}" data-v-5c2fef75="" class="">

								<div data-v-43007dac="" class="form xkKlDe" style="margin-top: 25px;">
									<uni-view data-v-5c2fef75="" class="balance-card" style="display: flex; justify-content: space-around;">
										<span style="color: rgb(75, 127, 12);font-size:24px;font-weight:700;">{{ $user->user_currency_sym}}</span>
										<uni-view data-v-240cb67c="" data-v-5c2fef75="" class="first">
											<uni-view data-v-240cb67c="" class="tip">
												<span data-v-240cb67c="" class="" style="color: rgb(100, 168, 19);">Available assets</span>
											</uni-view>
											<p data-v-240cb67c="" class="" style="color: rgb(75, 127, 12);">{{ showAmount($userBalance['income']) }}</p>
										</uni-view>
									</uni-view>
								
									<p data-v-5c2fef75="" major-title="true" style="margin-top: 15px;text-align:center;margin-bottom:20px">Fill the form to make a mithdrawal</p>

									<uni-view data-v-43007dac="" class="info">
										<p data-v-43007dac="">Request amount</p>
										<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;justify-content: space-between;">
												<span data-v-0a75b799="" style="margin-top:7px">{{ config('settings')->cur_sym}}</span>
												<input step="0.0001" id="amtID" style="width:78%;padding:10px 2px;background:transparent;" placeholder="Enter amount to recharge" name="amount" enterkeyhint="done" autocomplete="off" type="text" class="uni-input-input">
												<span data-v-0a75b799="" style="margin-top:7px">{{ config('settings')->cur_text}}</span>
											</span>
										</uni-input>
										
										<uni-view data-v-5c2fef75="" class="tip" style="display:none">
											<span data-v-5c2fef75="" style="display: block;" >
												<span id="rateValue">{{ config('settings')->cur_sym}}0.00 ≈ {{ config('settings')->cur_sym}}0.00</span>
												<span id="taxRate" data-v-5c2fef75="" style="font-size: 15px; color: rgb(99, 132, 66); margin-top: 0px; padding-left: 0px; margin-bottom: 2px;">({{ ($withdrawMethod[0]->percent_charge + 0)}}% Tax)</span>
											</span>
											<span data-v-5c2fef75="" id="exchangeRate">{{ config('settings')->cur_sym}}1.00 ≈ {{ config('settings')->cur_sym}}1.00</span>
										</uni-view>
									</uni-view>
								</div>

								<div data-v-43007dac="" class="form xkKlDe" style="margin-top: 25px;">
									<p data-v-5c2fef75="" major-title="true" style="margin: 15px 0px;">Transfer To</p>
									<uni-view data-v-5c2fef75="" class="transfer-to-card">
										<uni-view data-v-5c2fef75="">
											<span data-v-5c2fef75="">Bank <span style="float:right;">{{ $bankName }}</span></span>
											<uni-input data-v-5c2fef75="">
												<div class="uni-input-wrapper">
													<div class="uni-input-placeholder input-placeholder" data-v-5c2fef75="" style="z-index:2;padding-left:8px;margin-top:8px"><img src="{{ asset($activeTemplateTrue.'img/bank.png') }}" style="width:24px" /></div>
													<input disabled="disabled" value="{{ $accountNumber }}" maxlength="140" style="padding-left:44px !important" step="" enterkeyhint="done" autocomplete="off" type="" class="uni-input-input">
												</div>
											</uni-input>
										</uni-view>

										<uni-view data-v-5c2fef75="">
											<uni-input data-v-5c2fef75="">
												<div class="uni-input-wrapper">
													<div class="uni-input-placeholder input-placeholder" data-v-5c2fef75="" style="z-index:2;padding-left:8px;margin-top:8px"><img src="{{ asset($activeTemplateTrue.'img/record.png') }}" style="width:24px" /></div>
													<input disabled="disabled" value="{{ $accountName }}" maxlength="140" style="padding-left:44px !important" step="" enterkeyhint="done" autocomplete="off" type="" class="uni-input-input">
												</div>
											</uni-input>
										</uni-view>
									</uni-view>
								
									@if( $user->ts )
									<p data-v-5c2fef75="" major-title="true" style="margin: 15px 0px;">User security</p>
									<uni-view data-v-43007dac="" style="margin-top:12px" class="info">
										<p data-v-43007dac="">Google authenticator</p>
										<uni-input data-v-64270b22="" class="inView" style="background-color: #f5f5f5;height:auto;margin-top:8px;border-radius: 8px; padding: 4px;border-bottom: 1px #eee solid;">
											<span data-v-64270b22="" class="" style="margin-left:9px;width: 94%;display: flex;justify-content: space-between;">
												<span data-v-0a75b799="" style="margin-top:7px"><img src="{{ asset($activeTemplateTrue.'img/password.png') }}" style="width:24px" /></span>
												<input id="authenticator" style="width:78%;padding:10px 2px;background:transparent;" placeholder="Requires two factor code" name="authenticator" enterkeyhint="done" autocomplete="off" type="password" maxlength="6" class="uni-input-input">
												<span data-v-0a75b799="" class="eyeView" style="margin-top:9px"><img src="{{ asset($activeTemplateTrue.'img/eye-fill.png') }}" style="width:17px" /></span>
											</span>
										</uni-input>
									</uni-view>
									@endif
								
									<input type="hidden" name="method" id="method" value="{{ $withdrawMethod[0]->id}}">
									<input type="hidden" name="debit_from" id="debit_with" value="2">
									<input id="bank_free" type="hidden" value="{{ ($withdrawMethod[0]->percent_charge/100) }}">
									@csrf

									<div style="width: 100%; height: 25px; line-height: 30px; margin-top:10px;border-width: 0px; border-style: solid; border-radius: 2px 2px 2px 2px; text-align: left;">
										<span class="textOthers" style="float:left;font-size:12px;">
											<font>Receiving amount</font>:
											<font id="jieguo1"></font>
										</span>
										<span class="textOthers" style="float: right; font-size: 12px;"><font>Tax</font>: <font id="free">{{ $withdrawMethod[0]->percent_charge}}</font>%</span>
									</div>
									<uni-button data-v-5c2fef75="" class="hero-button" id="withdrawBTN" type="primary">Withdraw Now</uni-button>
								</div>
								
                            </form>
							
                            <uni-view data-v-5c2fef75="" class="rules">
                                <h3 data-v-5c2fef75="">Withdrawal Rules</h3>
								{!! $withdrawMethod[0]->description !!}
                            </uni-view>
                        </uni-view>
                    </uni-view>
                </uni-page-body>
            </uni-page-wrapper>
        </uni-page>

		<uni-view data-v-79177165="" data-v-5daafb14="" data-v-5c2fef75="" class="uni-popup bottom" style="border-radius:20px 20px 0 0" id="transPassDIV">
			<uni-view data-v-79177165="">
				<uni-view data-v-acf5fb64="" data-v-79177165="" class="iOksm" name="mask" style="opacity: 1; position: fixed; inset: 0px; background-color: rgba(0, 0, 0, 0.4); transition: opacity 300ms, -webkit-transform 300ms, transform 300ms; transform-origin: 50% 50%;"></uni-view>
				<uni-view data-v-acf5fb64="" data-v-79177165="" class="" name="content" style="transform: translateY(0px); opacity: 1; position: fixed; left: 0px; right: 0px; bottom: 0px; padding-bottom: 0px; background-color: transparent; transition: -webkit-transform 300ms, transform 300ms; transform-origin: 50% 50%;z-index:10;">
					<uni-view data-v-79177165="" class="uni-popup__wrapper bottom" style="background-color: transparent;">
						<div data-v-5daafb14="" class="verify-mail">
							<p data-v-5daafb14="" title="true" style="margin-bottom: 30px;">Enter your Tx Password</p>
							<div data-v-5daafb14="" class="input-code" id="phoneInput">
								<span data-v-5daafb14="" class="input-item">
									<input maxlength="1" max="9" min="0" enterkeyhint="done" pattern="[0-9]*" autocomplete="off" type="tel" class="uni-input-input letter" autoFocus />
								</span>
								<span data-v-5daafb14="" class="input-item">
									<input maxlength="1" max="9" min="0" enterkeyhint="done" pattern="[0-9]*" autocomplete="off" type="tel" class="uni-input-input letter" />
								</span>
								<span data-v-5daafb14="" class="input-item">
									<input maxlength="1" max="9" min="0" enterkeyhint="done" pattern="[0-9]*" autocomplete="off" type="tel" class="uni-input-input letter" />
								</span>
								<span data-v-5daafb14="" class="input-item">
									<input maxlength="1" max="9" min="0" enterkeyhint="done" pattern="[0-9]*" autocomplete="off" type="tel" class="uni-input-input letter" />
								</span>
								<span data-v-5daafb14="" class="input-item">
									<input maxlength="1" max="9" min="0" enterkeyhint="done" pattern="[0-9]*" autocomplete="off" type="tel" class="uni-input-input letter" />
								</span>
								<span data-v-5daafb14="" class="input-item">
									<input maxlength="1" max="9" min="0" enterkeyhint="done" pattern="[0-9]*" autocomplete="off" type="tel" class="uni-input-input letter" />
								</span>
							</div>
							
							<div id="testWrapper">
								<input type="hidden" id="withPassword" value="" name="code">
							</div>
							
							<uni-view data-v-5daafb14="" style="display: flex; justify-content: center; width: 90%; margin: 0px auto;">
								<uni-button data-v-5daafb14="" class="iOksm" type="primary" style="width:48%;background:#6e6464;">Cancel</uni-button>
								<uni-button data-v-5daafb14="" class="confirmEntry" type="primary" style="width:48%">Confirm</uni-button>
							</uni-view>
						</div>
					</uni-view>
				</uni-view>
			</uni-view>
		</uni-view>


	</uni-app>
@endsection

@push('script')
<script src="{{ asset($activeTemplateTrue.'script/jquery.inputLettering.js') }}"></script>
<script>
	var currency = "NGN", symbol = "₦", rate="1", xchange = "1", other = "₮";
	$('#amtID').keyup(function() {
		$(this)[0].value = $(this)[0].value.replace(/^(0+)|[^\d]+/g, '')
		exchange();
	})

	$('.eyeView').click(function() {
		if ($($(this).siblings('input')[0]).attr('type') == 'password') {
			$($(this).siblings('input')[0]).attr('type', 'text')
			$(this).addClass('active')
		} else {
			$($(this).siblings('input')[0]).attr('type', 'password')
			$(this).removeClass('active')
		}
	})


	$('.tabs').click(function() {
		$(".tabs").removeClass('active');
		$(this).addClass('active');
		var info = $(this).data();
		currency = info.currency, symbol = info.symbol, rate = info.rate, xchange = info.exchange, other = info.other;
		$('#exchangeRate').html("["+currency+"] "+symbol+"1.00 ≈ " + other + " "+rate+"");
		exchange();
	})

	function exchange(){
		let amount = $('#amtID').val();
		var free = $("#bank_free").val();
		var toFix = 2;
		if( !isNaN(amount) ){
			var value = amount*xchange;
			$('#rateValue').html("₦"+amount+".00 ≈ " + symbol + "" + value + " [" + currency + "]");
			
			toFix = (currency == "NGN") ? 2:4;

			var freeamount = value * free * 1;
			var sjamount = value - freeamount;
			$("#jieguo1").html(currency + " " + sjamount.toFixed(toFix));

		}
		
	}

    $("#withdrawBTN").click(function() {

        var amount = $('#amtID');
        var method = $('#method');
        var debit_from = $('#debit_with');
        var password = $('#withPassword');
        var gFactore = $('#authenticator');
        var token = document.querySelector('input[name="_token"]').value;
        var is_status = true;

        if (!amount.val()) {
			Toast('Withdrawing amount required','REQUEST AMOUNT');
            is_status = false; return false;
        }

		<?php if( $user->withdrawal_password ){ ?>
        if (!password.val()) {
			$('#transPassDIV').fadeIn();
			$('body,html').css({
				overflow: 'hidden'
			})
			$('#transPassDIV').slideDown();
            is_status = false;
        }
		<?php } ?>

		<?php if( $user->ts ){ ?>
        if (!gFactore.val()) {
            Toast("Google two factor code Required",'GOOGLE AUTHENTICATOR');
            is_status = false;
        }
		<?php } ?>

        if (is_status) {
            $.ajax({
                type: "POST",
                url: "{{ route('user.withdraw.money') }}",
                data: {
                    amount: amount.val(),
                    method: method.val(),
                    debit_from: debit_from.val(),
                    password: password.val(),
                    _token: token
                },
                beforeSend: function() {
					loading.showLoading({type: 3,tip: "loading.."});
                },
                success: function(data) {
					loading.hideLoading();
					Toast(data.message,'RESPONSE MESSAGE',false,'SUCCESS',data.link);
					password.val('');
                },
                error: function(xhr, status, error) {
                    var responseText = JSON.parse(xhr.responseText);
					loading.hideLoading();
					Toast(responseText.message,'ERROR MESSAGE');
					password.val('');
                },
                fail: function() {
					Toast('Request Failed', 'RESPONSE MESSAGE');
					loading.hideLoading();
					password.val('');
                }
            });
        }

        return false;
    });

	var codes;
	$(function() {
		$(document).on("click", '.iOksm', function () {
			$('body,html').css({
				overflow: 'scroll'
			})
			$('.uni-popup').fadeOut();
		});

		$(document).on("click", '.confirmEntry', function () {
			$('.iOksm').trigger('click');
			$('#withdrawBTN').trigger('click');
		});

		$('#phoneInput').letteringInput({
			inputClass: 'letter',
			hiddenInputWrapperID: 'testWrapper',
			hiddenInputName: 'code',
			onLetterKeyup: function ($item, event) {
			},
			onSet: function ($el, event, value) {
				codes = $('#withPassword').val();
				if (codes.length >= 6) {
					$('.iOksm').trigger('click');
					$('#withdrawBTN').trigger('click');
				}
			},
		});
	});

</script>
@endpush
