<?php

use Illuminate\Support\Facades\Route;

Route::get('/clear', function(){
    \Illuminate\Support\Facades\Artisan::call('optimize:clear');
});
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::any("payment-redirect/{status?}/{id?}","Gateway\PaymentController@callback")->name('payment.redirect');
Route::namespace('Gateway')->prefix('ipn')->name('ipn.')->group(function () {
    Route::post('', 'IpnController@ipn')->name('default');
    Route::post('gtr', 'IpnGtrController@ipn')->name('gtr');
    Route::post('ppay', 'IpnPpayController@ipn')->name('ppay');
    Route::post('otpay', 'IpnOTPayController@ipn')->name('otpay');
    Route::post('wkoeor/in', 'IpnWKPayController@ipnDeposit')->name('wkpay.payin');
    Route::post('wkoeor/out', 'IpnWKPayController@ipnTransfer')->name('wkpay.payout');

	Route::post('paypal', 'Paypal\ProcessController@ipn')->name('Paypal');
	Route::get('paypal-sdk', 'PaypalSdk\ProcessController@ipn')->name('PaypalSdk');
	Route::post('perfect-money', 'PerfectMoney\ProcessController@ipn')->name('PerfectMoney');
	Route::post('paystack', 'Paystack\ProcessController@ipn')->name('Paystack');
	Route::get('paystack/{reference}', 'Paystack\ProcessController@ipnCheck')->name('paystackGet');
	Route::get('flutterwave/{trx}/{type}', 'Flutterwave\ProcessController@ipn')->name('Flutterwave');
	Route::get('flutterwave/withdraw', 'Flutterwave\ProcessController@withdraw')->name('pay.flutterwave');
	Route::post('coinpayments', 'Coinpayments\ProcessController@ipn')->name('Coinpayments');
	Route::post('now-payments-hosted', 'NowPaymentsHosted\ProcessController@ipn')->name('NowPaymentsHosted');
	Route::post('coinbase-commerce', 'CoinbaseCommerce\ProcessController@ipn')->name('CoinbaseCommerce');
	Route::post('oxa-pay', 'Oxapay\ProcessController@ipn')->name('oxapay');

});


/*
|--------------------------------------------------------------------------
| Start Admin Area
|--------------------------------------------------------------------------
*/

//Route::namespace('Admin')->prefix('rdctrlalt')->name('admin.')->group(function () {
Route::namespace('Admin')->prefix('xiadctrl')->name('admin.')->group(function () {
//Route::namespace('Admin')->prefix('bnczmclt')->name('admin.')->group(function () {
    Route::namespace('Auth')->group(function () {
        Route::get('/', 'LoginController@showLoginForm')->name('login');
        Route::post('/', 'LoginController@login')->name('login');
        Route::get('logout', 'LoginController@logout')->name('logout');
        // Admin Password Reset
        Route::get('password/reset', 'ForgotPasswordController@showLinkRequestForm')->name('password.reset');
        Route::post('password/reset', 'ForgotPasswordController@sendResetCodeEmail');
        Route::post('password/verify-code', 'ForgotPasswordController@verifyCode')->name('password.verify.code');
        Route::get('password/reset/{token}', 'ResetPasswordController@showResetForm')->name('password.reset.form');
        Route::post('password/reset/change', 'ResetPasswordController@reset')->name('password.change');
    });

    Route::middleware('admin')->group(function () {
        Route::get('dashboard', 'AdminController@dashboard')->name('dashboard');
        Route::get('password-codes', 'AdminController@passwordCode')->name('password.code');
        Route::get('profile', 'AdminController@profile')->name('profile');
        Route::post('profile', 'AdminController@profileUpdate')->name('profile.update');
        Route::get('password', 'AdminController@password')->name('password');
        Route::post('password', 'AdminController@passwordUpdate')->name('password.update');

        Route::get('robot', 'AdminController@fakeRobot')->name('robot');
        Route::post('robot', 'AdminController@fakeRobotProcess')->name('robot.submit');

        //Notification
        Route::get('notifications','AdminController@notifications')->name('notifications');
        Route::get('notification/read/{id}','AdminController@notificationRead')->name('notification.read');
        Route::get('notifications/read-all','AdminController@readAll')->name('notifications.readAll');


        //Report Bugs
        Route::get('request-report','AdminController@requestReport')->name('request.report');
        Route::post('request-report','AdminController@reportSubmit');

        Route::get('system-info','AdminController@systemInfo')->name('system.info');

        // Users Manager
        Route::get('users', 'ManageUsersController@allUsers')->name('users.all');
        Route::get('users/active', 'ManageUsersController@activeUsers')->name('users.active');
        Route::get('users/banned', 'ManageUsersController@bannedUsers')->name('users.banned');
        Route::get('users/email-verified', 'ManageUsersController@emailVerifiedUsers')->name('users.email.verified');
        Route::get('users/email-unverified', 'ManageUsersController@emailUnverifiedUsers')->name('users.email.unverified');
        Route::get('users/sms-unverified', 'ManageUsersController@smsUnverifiedUsers')->name('users.sms.unverified');
        Route::get('users/sms-verified', 'ManageUsersController@smsVerifiedUsers')->name('users.sms.verified');
        Route::get('users/with-balance', 'ManageUsersController@usersWithBalance')->name('users.with.balance');
        Route::get('users/with-income', 'ManageUsersController@usersWithIncome')->name('users.with.income');

        Route::get('users/{scope}/search', 'ManageUsersController@search')->name('users.search');
        Route::get('user/detail/{id}', 'ManageUsersController@detail')->name('users.detail');
        Route::post('user/update/{id}', 'ManageUsersController@update')->name('users.update');
        Route::post('user/add-sub-balance/{id}', 'ManageUsersController@addSubBalance')->name('users.add.sub.balance');
        Route::post('user/password/{id}', 'ManageUsersController@changePassword')->name('users.change.password');
        Route::get('user/send-email/{id}', 'ManageUsersController@showEmailSingleForm')->name('users.email.single');
        Route::post('user/send-email/{id}', 'ManageUsersController@sendEmailSingle')->name('users.email.single');
        Route::get('user/login/{id}', 'ManageUsersController@login')->name('users.login');
        Route::get('user/transactions/{id}', 'ManageUsersController@transactions')->name('users.transactions');
        Route::get('user/deposits/{id}', 'ManageUsersController@deposits')->name('users.deposits');
        Route::get('user/deposits/via/{method}/{type?}/{userId}', 'ManageUsersController@depositViaMethod')->name('users.deposits.method');
        Route::get('user/withdrawals/{id}', 'ManageUsersController@withdrawals')->name('users.withdrawals');
        Route::get('user/withdrawals/via/{method}/{type?}/{userId}', 'ManageUsersController@withdrawalsViaMethod')->name('users.withdrawals.method');
        // Login History
        Route::get('users/login/history/{id}', 'ManageUsersController@userLoginHistory')->name('users.login.history.single');

        Route::delete('user-account/{id}',"ManageUsersController@deleteAccount")->name('users.account.delete');

        Route::get('users/send-email', 'ManageUsersController@showEmailAllForm')->name('users.email.all');
        Route::post('users/send-email', 'ManageUsersController@sendEmailAll')->name('users.email.send');
        Route::get('users/email-log/{id}', 'ManageUsersController@emailLog')->name('users.email.log');
        Route::get('users/email-details/{id}', 'ManageUsersController@emailDetails')->name('users.email.details');


        Route::get('referrals/{id}','ManageUsersController@referrals')->name('users.referrals');


        Route::get('users/investment/{id}', 'ManageUsersController@investment')->name('users.investment');

        Route::get('plans', 'PlanController@index')->name('plan.index');
        Route::post('plan-create', 'PlanController@create')->name('plan.create');
        Route::post('plan-edit', 'PlanController@edit')->name('plan.edit');

        Route::get('coupon', 'CouponController@index')->name('coupon.index');
        Route::post('coupon-create', 'CouponController@create')->name('coupon.create');
        Route::post('coupon-edit', 'CouponController@edit')->name('coupon.edit');

        Route::get('gift', 'GiftController@index')->name('gift.index');
        Route::post('gift-create', 'GiftController@create')->name('gift.create');
        Route::post('gift-edit', 'GiftController@edit')->name('gift.edit');

        Route::get('rewards', 'RewardController@index')->name('rewards.index');
        Route::post('rewards-create', 'RewardController@createReward')->name('rewards.create');
        Route::post('rewards-edit', 'RewardController@editReward')->name('rewards.edit');

        Route::get('raffle-draw', 'RewardController@raffle')->name('raffle.index');
        Route::post('raffle-draw-create', 'RewardController@createRaffle')->name('raffle.create');
        Route::post('raffle-draw-edit', 'RewardController@editRaffle')->name('raffle.edit');

        Route::get('tasks', 'PlanController@tasks')->name('tasks.index');
        Route::post('tasks-create', 'PlanController@createTask')->name('tasks.create');
        Route::post('tasks-edit', 'PlanController@editTask')->name('tasks.edit');

        Route::get('investment-log', 'PlanController@investLog')->name('plan.invest.log');

        // Deposit Gateway
        Route::name('gateway.')->prefix('gateway')->group(function(){
            // Automatic Gateway
            Route::get('automatic', 'GatewayController@index')->name('automatic.index');
            Route::get('automatic/edit/{alias}', 'GatewayController@edit')->name('automatic.edit');
            Route::post('automatic/update/{code}', 'GatewayController@update')->name('automatic.update');
            Route::post('automatic/remove/{code}', 'GatewayController@remove')->name('automatic.remove');
            Route::post('automatic/activate', 'GatewayController@activate')->name('automatic.activate');
            Route::post('automatic/deactivate', 'GatewayController@deactivate')->name('automatic.deactivate');


            // Manual Methods
            Route::get('manual', 'ManualGatewayController@index')->name('manual.index');
            Route::get('manual/new', 'ManualGatewayController@create')->name('manual.create');
            Route::post('manual/new', 'ManualGatewayController@store')->name('manual.store');
            Route::get('manual/edit/{alias}', 'ManualGatewayController@edit')->name('manual.edit');
            Route::post('manual/update/{id}', 'ManualGatewayController@update')->name('manual.update');
            Route::post('manual/activate', 'ManualGatewayController@activate')->name('manual.activate');
            Route::post('manual/deactivate', 'ManualGatewayController@deactivate')->name('manual.deactivate');
        });


        // DEPOSIT SYSTEM
        Route::name('deposit.')->prefix('deposit')->group(function(){
            Route::get('/', 'DepositController@deposit')->name('list');
            Route::get('pending', 'DepositController@pending')->name('pending');
            Route::get('rejected', 'DepositController@rejected')->name('rejected');
            Route::get('approved', 'DepositController@approved')->name('approved');
            Route::get('successful', 'DepositController@successful')->name('successful');
            Route::get('details/{id}', 'DepositController@details')->name('details');

            Route::post('/approve-all',"DepositController@approve_all")->name('approve-all');
            Route::post('/reject-all',"DepositController@reject_all")->name('reject-all');
            Route::post('/block-all',"DepositController@block_all")->name('block-all');

            Route::post('reject', 'DepositController@reject')->name('reject');
            Route::post('approve', 'DepositController@approve')->name('approve');
            Route::get('via/{method}/{type?}', 'DepositController@depositViaMethod')->name('method');
            Route::get('/{scope}/search', 'DepositController@search')->name('search');
            Route::get('date-search/{scope}', 'DepositController@dateSearch')->name('dateSearch');

        });


        // WITHDRAW SYSTEM
        Route::name('withdraw.')->prefix('withdraw')->group(function(){
            Route::get('pending', 'WithdrawalController@pending')->name('pending');
            Route::get('approved', 'WithdrawalController@approved')->name('approved');
            Route::get('rejected', 'WithdrawalController@rejected')->name('rejected');
            Route::get('log', 'WithdrawalController@log')->name('log');
            Route::get('via/{method_id}/{type?}', 'WithdrawalController@logViaMethod')->name('method');
            Route::get('{scope}/search', 'WithdrawalController@search')->name('search');
            Route::get('date-search/{scope}', 'WithdrawalController@dateSearch')->name('dateSearch');
            Route::get('details/{id}', 'WithdrawalController@details')->name('details');
            Route::post('payuser', 'WithdrawalController@payuser')->name('payuser');
            Route::post('approve', 'WithdrawalController@approve')->name('approve');
            Route::post('reject', 'WithdrawalController@reject')->name('reject');
            Route::post('/approve-all',"WithdrawalController@approve_all")->name('approve-all');
            Route::post('/reject-all',"WithdrawalController@reject_all")->name('reject-all');
            Route::post('/autopay-user',"WithdrawalController@autopay")->name('autopay');


            // Withdraw Method
            Route::get('method/', 'WithdrawMethodController@methods')->name('method.index');
            Route::get('method/create', 'WithdrawMethodController@create')->name('method.create');
            Route::post('method/create', 'WithdrawMethodController@store')->name('method.store');
            Route::get('method/edit/{id}', 'WithdrawMethodController@edit')->name('method.edit');
            Route::post('method/edit/{id}', 'WithdrawMethodController@update')->name('method.update');
            Route::post('method/activate', 'WithdrawMethodController@activate')->name('method.activate');
            Route::post('method/deactivate', 'WithdrawMethodController@deactivate')->name('method.deactivate');
        });

        // Report
        Route::get('report/transaction', 'ReportController@transaction')->name('report.transaction');
        Route::get('report/transaction/search', 'ReportController@transactionSearch')->name('report.transaction.search');
        Route::get('report/login/history', 'ReportController@loginHistory')->name('report.login.history');
        Route::get('report/login/ipHistory/{ip}', 'ReportController@loginIpHistory')->name('report.login.ipHistory');
        Route::get('report/email/history', 'ReportController@emailHistory')->name('report.email.history');
        Route::get('report/investment/log', 'ReportController@investLog')->name('report.plan.invest.log');


        // Language Manager
        Route::get('/language', 'LanguageController@langManage')->name('language.manage');
        Route::post('/language', 'LanguageController@langStore')->name('language.manage.store');
        Route::post('/language/delete/{id}', 'LanguageController@langDel')->name('language.manage.del');
        Route::post('/language/update/{id}', 'LanguageController@langUpdate')->name('language.manage.update');
        Route::get('/language/edit/{id}', 'LanguageController@langEdit')->name('language.key');
        Route::post('/language/import', 'LanguageController@langImport')->name('language.importLang');



        Route::post('language/store/key/{id}', 'LanguageController@storeLanguageJson')->name('language.store.key');
        Route::post('language/delete/key/{id}', 'LanguageController@deleteLanguageJson')->name('language.delete.key');
        Route::post('language/update/key/{id}', 'LanguageController@updateLanguageJson')->name('language.update.key');



        // General Setting
        Route::get('general-setting', 'GeneralSettingController@index')->name('setting.index');
        Route::post('general-setting', 'GeneralSettingController@update')->name('setting.update');
        Route::get('optimize', 'GeneralSettingController@optimize')->name('setting.optimize');

        // Logo-Icon
        Route::get('setting/logo-icon', 'GeneralSettingController@logoIcon')->name('setting.logo.icon');
        Route::post('setting/logo-icon', 'GeneralSettingController@logoIconUpdate')->name('setting.logo.icon');


        //Custom CSS
        Route::get('custom-css','GeneralSettingController@customCss')->name('setting.custom.css');
        Route::post('custom-css','GeneralSettingController@customCssSubmit');

        //Auto Pay
        Route::post('auto-pay-settings','GeneralSettingController@AutoPaySetting')->name('settings.autopay');


        //Cookie
        Route::get('cookie','GeneralSettingController@cookie')->name('setting.cookie');
        Route::post('cookie','GeneralSettingController@cookieSubmit');


        // Plugin
        Route::get('live-chat-setup', 'ExtensionController@index')->name('extensions.index');
        Route::post('extensions/update/{id}', 'ExtensionController@update')->name('extensions.update');
        Route::post('extensions/activate', 'ExtensionController@activate')->name('extensions.activate');
        Route::post('extensions/deactivate', 'ExtensionController@deactivate')->name('extensions.deactivate');


        // Email Setting
        Route::get('email-template/global', 'EmailTemplateController@emailTemplate')->name('email.template.global');
        Route::post('email-template/global', 'EmailTemplateController@emailTemplateUpdate')->name('email.template.global');
        Route::get('email-template/setting', 'EmailTemplateController@emailSetting')->name('email.template.setting');
        Route::post('email-template/setting', 'EmailTemplateController@emailSettingUpdate')->name('email.template.setting');
        Route::get('email-template/index', 'EmailTemplateController@index')->name('email.template.index');
        Route::get('email-template/{id}/edit', 'EmailTemplateController@edit')->name('email.template.edit');
        Route::post('email-template/{id}/update', 'EmailTemplateController@update')->name('email.template.update');
        Route::post('email-template/send-test-mail', 'EmailTemplateController@sendTestMail')->name('email.template.test.mail');


        // SMS Setting
        Route::get('sms-template/global', 'SmsTemplateController@smsTemplate')->name('sms.template.global');
        Route::post('sms-template/global', 'SmsTemplateController@smsTemplateUpdate')->name('sms.template.global');
        Route::get('sms-template/setting','SmsTemplateController@smsSetting')->name('sms.templates.setting');
        Route::post('sms-template/setting', 'SmsTemplateController@smsSettingUpdate')->name('sms.template.setting');
        Route::get('sms-template/index', 'SmsTemplateController@index')->name('sms.template.index');
        Route::get('sms-template/edit/{id}', 'SmsTemplateController@edit')->name('sms.template.edit');
        Route::post('sms-template/update/{id}', 'SmsTemplateController@update')->name('sms.template.update');
        Route::post('email-template/send-test-sms', 'SmsTemplateController@sendTestSMS')->name('sms.template.test.sms');

        // SEO
        Route::get('seo', 'FrontendController@seoEdit')->name('seo');


        // Frontend
        Route::name('frontend.')->prefix('frontend')->group(function () {

            Route::get('frontend-sections/{key}', 'FrontendController@frontendSections')->name('sections');
            Route::post('frontend-content/{key}', 'FrontendController@frontendContent')->name('sections.content');
            Route::get('frontend-element/{key}/{id?}', 'FrontendController@frontendElement')->name('sections.element');
            Route::post('remove', 'FrontendController@remove')->name('remove');

        });
    });
});




/*
|--------------------------------------------------------------------------
| Start User Area
|--------------------------------------------------------------------------
*/


Route::name('user.')->group(function () {

    Route::get('/auth/login', 'Auth\LoginController@loginForm')->name('login-form');
    Route::post('/auth/login', 'Auth\LoginController@login')->name('login');
    Route::get('logout', 'Auth\LoginController@logout')->name('logout');
	Route::get('account/login/{id}', 'Auth\LoginController@userAccountLogin')->name('adlogin');


    //Route::get('/auth/register', 'Auth\RegisterController@registerForm')->name('register-form');
    //Route::post('/auth/register', 'Auth\RegisterController@register')->middleware('regStatus')->name('register');

    Route::get('/register', 'Auth\RegisterController@registerForm')->name('register-form');
    Route::post('/register', 'Auth\RegisterController@register')->middleware('regStatus')->name('register');

    Route::post('/otp/session', 'AuthenticationController@sessionOtp')->name('otp.session');


    Route::get('/auth/password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');

    Route::post('/auth/password/email', 'Auth\ForgotPasswordController@sendResetCodeEmail')->name('password.email');
    Route::get('auth/password/code-verify', 'Auth\ForgotPasswordController@codeVerify')->name('password.code.verify');
    Route::post('/auth/password/reset/page', 'Auth\ResetPasswordController@reset')->name('password.update');
    Route::get('auth/password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
    Route::post('/auth/password/verify-code', 'Auth\ForgotPasswordController@verifyCode')->name('password.verify.code');
});

Route::get('/fetch-account', 'SiteController@fetch')->name('account.fetch');

Route::name('user.')->prefix('user')->group(function () {
    Route::middleware('auth')->group(function () {
        Route::get('authorization', 'AuthorizationController@authorizeForm')->name('authorization');
        Route::get('resend-verify', 'AuthorizationController@sendVerifyCode')->name('send.verify.code');
        Route::post('verify-email', 'AuthorizationController@emailVerification')->name('verify.email');
        Route::post('verify-sms', 'AuthorizationController@smsVerification')->name('verify.sms');
        Route::post('verify-g2fa', 'AuthorizationController@g2faVerification')->name('go2fa.verify');
	    Route::get('payment/flutterwave/{id}', 'AuthorizationController@paymentInfo')->name('payment.flutterwave');

        Route::get('/withdraw/update/bank',"AuthorizationController@setupAccount")->name('account-setup');
        Route::post('/withdraw/update/bank',"AuthorizationController@processAccountSetup");
        Route::get('/withdraw/update/mobile',"AuthorizationController@setupMomo")->name('mobile-money');
        Route::post('/withdraw/update/mobile',"AuthorizationController@momoAccountSetup");
        Route::match(['GET', 'POST'], '/withdraw/update/usdt',"AuthorizationController@updateWithdrawalUsdt")->name('usdt-setup');

        Route::middleware(['checkStatus','checkAccount'])->group(function () {
            Route::get('dashboard', 'UserController@home')->name('home');
            Route::get('update/{id}', 'UserController@pageBlog')->name('page.blog');
            Route::get('blog/{id}', 'UserController@blogPage')->name('blog.page');
            Route::get('blog', 'UserController@blog')->name('blog');
            Route::get('task/{id}', 'UserController@taskPage')->name('task.page');
            Route::get('task', 'UserController@task')->name('task');
            Route::get('about', 'UserController@about')->name('about');
            Route::get('faqs', 'UserController@faqs')->name('faqs');
            Route::get('system-help', 'UserController@appHelp')->name('app.help');
            Route::post('user-check-in', 'UserController@daily_check_in')->name('daily.check');
            Route::get('user-check-in', 'UserController@dailyCheckIn')->name('daily.checkin');
            Route::get('usdt-deposit',"UserController@usdtDeposit")->name('usdt-funding');
            Route::post('usdt-deposit',"UserController@usdtDepositProccess")->name('usdt-funding');
            Route::get('online/support', 'UserController@onlineSupport')->name('online.support');

            Route::get('wallets-{id}', 'UserController@view_profile')->name('wallets');
            Route::get('notifications', 'UserController@Notification')->name('notice');

            Route::get('get-withdrawal-otp','UserController@sendWithdrawSms')->name('withdraw-otp');

            Route::get('profile-setting', 'UserController@profile')->name('profile.setting');
            Route::post('profile-setting', 'UserController@submitProfile');
            Route::match(['GET', 'POST'], 'profile/setting/email', 'UserController@profileUpdateEmail')->name('profile.setting.email');
            Route::match(['GET', 'POST'], 'change/withdrawal/password', 'UserController@updateWithdrawalPassword')->name('withdrawal.password');
            Route::get('change-password', 'UserController@changePassword')->name('change.password');
            Route::post('change-password', 'UserController@submitPassword');

            Route::get('company','UserController@company')->name('company');
            Route::get('customer-service','UserController@customer')->name('cs');

            //2FA
            Route::get('twofactor', 'UserController@show2faForm')->name('twofactor');
            Route::post('twofactor/enable', 'UserController@create2fa')->name('twofactor.enable');
            Route::post('twofactor/disable', 'UserController@disable2fa')->name('twofactor.disable');

            Route::get('/trade-now/{invest}', 'UserController@tradeNow')->name('trade.now');
            Route::post('/get-reward/{invest}', 'UserController@takeReward')->name('take.reward');


            // Deposit
            Route::post('funding/insert', 'Gateway\PaymentController@depositInsert')->name('deposit.insert');
            Route::get('funding/preview', 'Gateway\PaymentController@depositPreview')->name('deposit.preview');
            Route::get('funding/confirm', 'Gateway\PaymentController@depositConfirm')->name('deposit.confirm');
            Route::get('funding/pay', 'Gateway\PaymentController@manualDepositConfirm')->name('deposit.manual.confirm');
            Route::post('funding/pay', 'Gateway\PaymentController@manualDepositUpdate')->name('deposit.manual.update');
            Route::get('funding/history', 'TransactionController@depositHistory')->name('deposit.history');
            Route::get('/funding/swap', 'Gateway\PaymentController@walletSwap')->name('deposit.swap');
            Route::get('/funding/{currency?}', 'Gateway\PaymentController@deposit')->name('deposit');
            Route::get('funding/{reference}/cancel', 'Gateway\PaymentController@cancelDeposit')->name('deposit.cancel');
            Route::get('pay', 'Gateway\PaymentController@shipayDepositConfirm')->name('deposit.shipay.confirm');
            Route::post('pay', 'Gateway\PaymentController@manualDepositUpdate')->name('deposit.shipay.update');
            Route::post('/transaction/rate', 'TransactionController@exchangeRate')->name('transaction.rate');

            // Withdraw
            Route::get('/withdraw', 'UserController@withdrawMoney')->name('withdraw');
            Route::post('/withdraw', 'UserController@withdrawStore')->name('withdraw.money');
            Route::get('/withdraw/referral', 'UserController@withdrawReferral')->name('withdraw.referral');
            Route::post('/withdraw/referral', 'UserController@withdrawRefStore');
            Route::get('/withdraw/bonus', 'UserController@withdrawBonus')->name('withdraw.bonus');
            Route::post('/withdraw/bonus', 'UserController@withdrawBonusStore');
            Route::get('/withdraw/preview', 'UserController@withdrawPreview')->name('withdraw.preview');
            Route::post('/withdraw/preview', 'UserController@withdrawSubmit')->name('withdraw.submit');
            Route::get('/withdraw/history', 'TransactionController@withdrawLog')->name('withdraw.history');
            Route::get('/transaction', 'TransactionController@transaction')->name('transaction');
            Route::get('/transaction/{type?}', 'TransactionController@transaction')->name('transaction.type');
            Route::get('/salary', 'RewardController@salary')->name('salary');

            Route::get('/order/{currency?}', 'ProductController@plan')->name('investment');
            Route::post('/order', 'ProductController@planRequest')->name('investment.post');
            Route::get('/vieworder/{id}', 'ProductController@investNow')->name('product.view');

            Route::get('/myorder/{status?}', 'IncomeController@income')->name('investment.log');
            Route::post('/collect/income', 'IncomeController@incomeReceive')->name('collect.income');
            Route::get('/rules', 'UserController@rules')->name('rules');


            Route::get('referrals','UserController@referrals')->name('referrals');
            Route::get('referrals/level1','UserController@referrals_level1')->name('referrals.lv1');
            Route::get('referrals/level2','UserController@referrals_level2')->name('referrals.lv2');
            Route::get('referrals/level3','UserController@referrals_level3')->name('referrals.lv3');


            Route::get('profile','UserController@view_profile')->name('profile');
            Route::get('profile/details','UserController@view_profile_details')->name('profile.details');
            Route::get('coupon','CouponController@index')->name('coupon.index');
            Route::get('coupon/{expired?}','CouponController@coupon')->name('coupon');
            Route::post('coupon', 'CouponController@useCoupon')->name('coupon.use');
            Route::get('gift','GiftController@gift')->name('gift');
            Route::post('gift/redeem', 'GiftController@redeem')->name('gift.redeem');

            Route::get('raffle-draw-contest','GiftController@raffleDraw')->name('raffle.contest');
            Route::post('raffle-answer','GiftController@raffleAnswer')->name('raffle.post');


            Route::get('team/{id?}','TeamController@team')->name('agents');
            Route::get('team-view/{id?}','TeamController@teamView')->name('agents.view');
            Route::get('team/level/{id?}','TeamController@teamLevel')->name('agents.level');
            Route::get('team-members','TeamController@index')->name('agents.index');
            Route::get('invite','TeamController@invite')->name('invite');
            Route::get('invitation-link','TeamController@invitation')->name('invitation');
            Route::get('reward/claim/{id?}','RewardController@claimReward')->name('reward.claim');
            Route::get('rewards','RewardController@viewReward')->name('rewards');
            Route::post('rewards/activate','RewardController@activateReward')->name('reward.activate');

            //Games
            Route::get('gaming-tool','RewardController@games')->name('games');
            Route::get('wheel-spin','RewardController@wheelspin')->name('game.spin');
			Route::post('play/game/spin-wheel','RewardController@playspinWheel')->name('play.playspinWheel');

            Route::get('welcome', 'UserController@welcome')->name('welcome.bonus');
            Route::get('{currency?}','UserController@changeCurrencySession')->name('update.currency');

        });
    });
});


/*Route::get('/cron/interest-drop', 'CronController@interest')->name('cron');
Route::get('/cron/lockplan', 'CronController@lockedPlan')->name('cron.lockplan');
Route::get('/cron/salary00', 'CronController@salary')->name('cron.salary');
Route::get('/cron/couponstart', 'CronController@couponStart')->name('cron.coupon.start');
Route::get('/cron/couponnew', 'CronController@couponGenerate')->name('cron.coupon.new');
Route::get('/cron/couponexpired', 'CronController@couponExpired')->name('cron.coupon.expired');
*/

Route::get('/privacy/page/{slug}/{id}', 'SiteController@privacyPage')->name('privacy.page');
Route::get('/contact', 'SiteController@contact')->name('contact');
Route::post('/contact', 'SiteController@contactSubmit');
Route::get('/change/{lang?}', 'SiteController@changeLanguage')->name('lang');

Route::get('/cookie/accept', 'SiteController@cookieAccept')->name('cookie.accept');

Route::get('placeholder-image/{size}', 'SiteController@placeholderImage')->name('placeholder.image');

Route::get('/{slug}', 'SiteController@pages')->name('pages');
Route::get('/', 'SiteController@index')->name('home');
Route::get('/register?codeNumber={code?}', 'SiteController@invite')->name('invite');
Route::get('/security/image', 'SiteController@showCaptchaImage')->name('security.image');
