<?php $__env->startSection('panel'); ?>
<div class="row justify-content-center">
    <?php if(request()->routeIs('admin.withdraw.log') || request()->routeIs('admin.withdraw.method') || request()->routeIs('admin.users.withdrawals') || request()->routeIs('admin.users.withdrawals.method')): ?>
    <div class="col-xl-4 col-sm-6 mb-30">
        <div class="widget-two box--shadow2 b-radius--5 bg--success">
            <div class="widget-two__content">
                <h2 class="text-white"><?php echo e(__(config('settings')->cur_sym)); ?><?php echo e($withdrawals->where('status',1)->sum('amount')); ?></h2>
                <p class="text-white"><?php echo app('translator')->get('Approved Withdrawals'); ?></p>
            </div>
        </div><!-- widget-two end -->
    </div>
    <div class="col-xl-4 col-sm-6 mb-30">
        <div class="widget-two box--shadow2 b-radius--5 bg--6">
            <div class="widget-two__content">
                <h2 class="text-white"><?php echo e(__(config('settings')->cur_sym)); ?><?php echo e($withdrawals->where('status',2)->sum('amount')); ?></h2>
                <p class="text-white"><?php echo app('translator')->get('Pending Withdrawals'); ?></p>
            </div>
        </div><!-- widget-two end -->
    </div>
    <div class="col-xl-4 col-sm-6 mb-30">
        <div class="widget-two box--shadow2 b-radius--5 bg--pink">
            <div class="widget-two__content">
                <h2 class="text-white"><?php echo e(__(config('settings')->cur_sym)); ?><?php echo e($withdrawals->where('status',3)->sum('amount')); ?></h2>
                <p class="text-white"><?php echo app('translator')->get('Rejected Withdrawals'); ?></p>
            </div>
        </div><!-- widget-two end -->
    </div>
    <?php endif; ?>
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">

                <div class="table-responsive--sm table-responsive">
                    <form action="<?php echo e(route('admin.withdraw.approve-all')); ?>" method="post" onsubmit="return confirm('Are you sure you want to continue?')">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Gateway | Trx'); ?></th>
                                    <th><?php echo app('translator')->get('Initiated'); ?></th>
                                    <th><?php echo app('translator')->get('User'); ?></th>
                                    <th><?php echo app('translator')->get('Amount'); ?></th>
                                    <th>Details</th>
                                    
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>

                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                $details = ($withdraw->withdraw_information != null) ? json_encode($withdraw->withdraw_information) : null;
                                ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Gateway | Trx'); ?>">
                                        <span class="font-weight-bold"><a href="<?php echo e(route('admin.withdraw.method',[$withdraw->method->id,'all'])); ?>"> <?php echo e(__(@$withdraw->method->name)); ?></a></span>
                                        <br>
                                        <small><?php echo e($withdraw->trx); ?></small>
                                        <br>
                                        <label for="with<?php echo e($withdraw->id); ?>">
                                            <input type="checkbox" name="ids[]" value="<?php echo e($withdraw->id); ?>" id="with<?php echo e($withdraw->id); ?>">
                                            Mark
                                        </label>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Initiated'); ?>">
                                        <?php echo e(showDateTime($withdraw->created_at)); ?> <br> <?php echo e(diffForHumans($withdraw->created_at)); ?>

                                    </td>

                                    <td data-label="<?php echo app('translator')->get('User'); ?>">
                                        <span class="font-weight-bold"><?php echo e($withdraw->user->fullname); ?></span>
                                        <br>
                                        <span class="small"> <a href="<?php echo e(route('admin.users.detail', $withdraw->user_id)); ?>"><span>@</span><?php echo e($withdraw->user->username); ?></a> </span>
                                    </td>


                                    <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                        <?php echo e(__(config('settings')->cur_sym)); ?><?php echo e(showAmount($withdraw->amount )); ?> - <span class="text-danger" data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('charge'); ?>"><?php echo e(showAmount($withdraw->charge)); ?> </span>
                                        <br>
                                        <strong data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Amount after charge'); ?>">
                                            <?php echo e(showAmount($withdraw->amount-$withdraw->charge)); ?> <?php echo e(__(config('settings')->cur_text)); ?>

                                        </strong>

                                    </td>

                                    <td data-label="Details">
                                        <?php if($withdraw->method->is_bank && $withdraw->user->bankAccount): ?>
                                        Account Name - <?php echo e($withdraw->user->bankAccount->account_name); ?> <br> Account Number - <?php echo e($withdraw->user->bankAccount->account_number); ?>

                                        <br> Bank Name - <?php echo e($withdraw->user->bankAccount->bank_name); ?>

                                        <?php endif; ?>

                                        <?php if(!$withdraw->method->is_bank && $withdraw->user->withdrawal_usdt_address != ""): ?>
                                        <hr>
                                        <span><?php echo e($withdraw->user->withdrawal_usdt_address); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <?php if($withdraw->status == 2): ?>
										<button type="button" class="btn btn--success ml-1 autoBtn" data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Auto Approve'); ?>"
												data-id="<?php echo e($withdraw->id); ?>" data-amount="<?php echo e(showAmount($withdraw->final_amount)); ?> <?php echo e($withdraw->currency); ?>">
											<i class="fas la-check"></i> <?php echo app('translator')->get('Auto Pay'); ?>
										</button>

										<div type="button" onclick="approveThis(<?php echo e($withdraw->id); ?>)" class="btn btn--success btn-sm"><?php echo app('translator')->get('Mark Paid'); ?></div>
                                        <?php endif; ?>

                                        <a href="<?php echo e(route('admin.withdraw.details', $withdraw->id)); ?>" class="icon-btn ml-1 " data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Detail'); ?>">
                                            <i class="la la-desktop"></i>
                                        </a>
                                    </td>

                                    

                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php if($withdraw->status == 2): ?>
                                        <span class="text--small badge font-weight-normal badge--warning"><?php echo app('translator')->get('Pending'); ?></span>
                                        <?php elseif($withdraw->status == 1): ?>
                                        <span class="text--small badge font-weight-normal badge--success"><?php echo app('translator')->get('Approved'); ?></span>
                                        <br><?php echo e(diffForHumans($withdraw->updated_at)); ?>

                                        <?php elseif($withdraw->status == 3): ?>
                                        <span class="text--small badge font-weight-normal badge--danger"><?php echo app('translator')->get('Rejected'); ?></span>
                                        <br><?php echo e(diffForHumans($withdraw->updated_at)); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                                <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->

						<input type="hidden" name="is_manual" value="1">
						
                        <div class="col-lg-12">
							<button type="submit" class="btn btn-primary" formaction="<?php echo e(route('admin.withdraw.approve-all')); ?>">Approve Marked</button>
							<button type="submit" class="btn btn-warning" formaction="<?php echo e(route('admin.withdraw.reject-all')); ?>">Reject Marked</button>
                        </div>
                    </form>
                </div>
            </div>

            <div class="card-footer py-4">
                <?php echo e(paginateLinks($withdrawals)); ?>

            </div>
        </div><!-- card end -->
    </div>
</div>


<div id="autoModal" class="modal fade" tabindex="-1" role="dialog">
	<div class="modal-dialog" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title"><?php echo app('translator')->get('PAY USER WITHDRAWAL'); ?></h5>
				<button type="button" class="close" data-dismiss="modal" aria-label="Close">
					<span aria-hidden="true">&times;</span>
				</button>
			</div>
			<form action="<?php echo e(route('admin.withdraw.autopay')); ?>" method="POST">
				<?php echo csrf_field(); ?>
				<input type="hidden" name="id">
				<div class="modal-body">
					<p><?php echo app('translator')->get('By clicking on the pay the platform try to pay the user the sum of '); ?> <span class="font-weight-bold withdraw-amount text-success"></span>? automatically using <span class="font-weight-bold text-success"><?php echo e(config('settings')->payout_config->auto_pay); ?></span> payment settings</p>
					<p class="withdraw-detail">Payment will be approved if it goes successfull</p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
					<button type="submit" class="btn btn--success">Pay & Approve</button>
				</div>
			</form>
		</div>
	</div>
</div>

<form action="<?php echo e(route('admin.withdraw.approve')); ?>" id="appSection" method="POST" style="display: inline-block;visibility: hidden;">
	<?php echo csrf_field(); ?>
	<input type="hidden" id="paidWithID" name="id" value="">
	<input type="hidden" name="details" value="Paid" />
	<input type="hidden" name="is_manual" value="1">
	<button type="submit" class="btn btn--success btn-sm"><?php echo app('translator')->get('Mark Paid'); ?></button>
</form>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('breadcrumb-plugins'); ?>

<?php if(!request()->routeIs('admin.users.withdrawals') && !request()->routeIs('admin.users.withdrawals.method')): ?>

<form action="<?php echo e(route('admin.withdraw.search', $scope ?? str_replace('admin.withdraw.', '', request()->route()->getName()))); ?>" method="GET" class="form-inline float-sm-right bg--white mb-2 ml-0 ml-xl-2 ml-lg-0">
    <div class="input-group has_append">
        <input type="text" name="search" class="form-control" placeholder="<?php echo app('translator')->get('Trx number/Username'); ?>" value="<?php echo e($search ?? ''); ?>">
        <div class="input-group-append">
            <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
        </div>
    </div>
</form>
<form action="<?php echo e(route('admin.withdraw.dateSearch',$scope ?? str_replace('admin.withdraw.', '', request()->route()->getName()))); ?>" method="GET" class="form-inline float-sm-right bg--white">
    <div class="input-group has_append">
        <input name="date" type="text" data-range="true" data-multiple-dates-separator=" - " data-language="en" class="datepicker-here form-control" data-position='bottom right' placeholder="<?php echo app('translator')->get('Min Date - Max date'); ?>" autocomplete="off" value="<?php echo e(@$dateSearch); ?>">
        <input type="hidden" name="method" value="<?php echo e(@$method->id); ?>">
        <div class="input-group-append">
            <button class="btn btn--primary" type="submit"><i class="fa fa-search"></i></button>
        </div>
    </div>
</form>
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-lib'); ?>
<script src="<?php echo e(asset('assets/admin/js/vendor/datepicker.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/admin/js/vendor/datepicker.en.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
<script>
	function approveThis(vID){
		$("#paidWithID").val(vID);
		$("#appSection").submit();
	}
	
    (function($) {
        'use strict';
        if (!$('.datepicker-here').val()) {
            $('.datepicker-here').datepicker();
        }

		$('.autoBtn').on('click', function() {
			var modal = $('#autoModal');
			modal.find('input[name=id]').val($(this).data('id'));
			modal.find('.withdraw-amount').text($(this).data('amount'));
			modal.modal('show');
		});
    })(jQuery)
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metalixz/public_html/core/resources/views/admin/withdraw/withdrawals.blade.php ENDPATH**/ ?>