<?php $__env->startSection('panel'); ?>
    <div class="row">

        <div class="col-lg-12">

            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Method'); ?></th>
                                <th><?php echo app('translator')->get('Currency'); ?></th>
                                <th><?php echo app('translator')->get('Charge'); ?></th>
                                <th><?php echo app('translator')->get('Withdraw Limit'); ?></th>
                                <th><?php echo app('translator')->get('Processing Time'); ?> </th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td data-label="<?php echo app('translator')->get('Method'); ?>">
                                        <div class="user">
                                            <div class="thumb"><img src="<?php echo e(getImage(imagePath()['withdraw']['method']['path'].'/'. $method->image,imagePath()['withdraw']['method']['size'])); ?>" alt="<?php echo app('translator')->get('image'); ?>" /></div>

                                            <span class="name"><?php echo e(__($method->name)); ?></span>
                                        </div>
                                    </td>

                                    <td data-label="<?php echo app('translator')->get('Currency'); ?>"
                                        class="font-weight-bold"><?php echo e(__($method->currency)); ?></td>
                                    <td data-label="<?php echo app('translator')->get('Charge'); ?>"
                                        class="font-weight-bold"><?php echo e(showAmount($method->fixed_charge)); ?> <?php echo e(__($method->currency)); ?> <?php echo e((0 < $method->percent_charge) ? ' + '. showAmount($method->percent_charge) .' %' : ''); ?> </td>
                                    <td data-label="<?php echo app('translator')->get('Withdraw Limit'); ?>"
                                        class="font-weight-bold"><?php echo e($method->min_limit + 0); ?>

                                        - <?php echo e($method->max_limit + 0); ?> <?php echo e(__($method->currency)); ?></td>
                                    <td data-label="<?php echo app('translator')->get('Processing Time'); ?>"><?php echo e($method->delay); ?></td>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        <?php if($method->status == 1): ?>
                                            <span class="text--small badge font-weight-normal badge--success"><?php echo app('translator')->get('Active'); ?></span>
                                        <?php else: ?>
                                            <span class="text--small badge font-weight-normal badge--warning"><?php echo app('translator')->get('Disabled'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                        <a href="<?php echo e(route('admin.withdraw.method.edit', $method->id)); ?>"
                                           class="icon-btn ml-1" data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Edit'); ?>"><i class="las la-pen"></i></a>
                                        <?php if($method->status == 1): ?>
                                            <a href="javascript:void(0)" class="icon-btn btn--danger deactivateBtn  ml-1" data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Disable'); ?>" data-id="<?php echo e($method->id); ?>" data-name="<?php echo e(__($method->name)); ?>">
                                                <i class="la la-eye-slash"></i>
                                            </a>
                                        <?php else: ?>
                                            <a href="javascript:void(0)" class="icon-btn btn--success activateBtn  ml-1"
                                               data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('Enable'); ?>"
                                               data-id="<?php echo e($method->id); ?>" data-name="<?php echo e(__($method->name)); ?>">
                                                <i class="la la-eye"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                </tr>
                            <?php endif; ?>

                            </tbody>
                        </table><!-- table end -->
                    </div>
                </div>
            </div><!-- card end -->
        </div>
		
        <div class="col-lg-12 pt-5">
            <div class="card b-radius--10 p-1">
                <div class="card-body p-0">

					<form action="<?php echo e(route('admin.settings.autopay')); ?>" method="POST">
						<?php echo csrf_field(); ?>
						<div class="card-body">
							<div class="form-row">
								<div class="form-group col-md-6">
									<label class="mb-4"><?php echo app('translator')->get('Auto Withdraw Pay'); ?></label>
									<select name="auto_pay" class="form-control" >
										<option value="0" <?php if(config('settings')->payout_config->auto_pay == '0'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Disabled [OFF]'); ?></option>
										<option value="oxapay" <?php if(config('settings')->payout_config->auto_pay == 'oxapay'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Oxapay [CRYPTO]'); ?></option>
										<option value="flutterwave" <?php if(config('settings')->payout_config->auto_pay == 'flutterwave'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Flutterwave [NGN]'); ?></option>
										<option value="paystack" <?php if(config('settings')->payout_config->auto_pay == 'paystack'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Paystack [NGN]'); ?></option>
										<option value="gtrpay" <?php if(config('settings')->payout_config->auto_pay == 'gtrpay'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Gtrpay [NGN]'); ?></option>
										<option value="nowpay" <?php if(config('settings')->payout_config->auto_pay == 'nowpay'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Nowpayment [CRYPTO]'); ?></option>
									</select>
								</div>
								<div class="form-group col-md-6 text-right">
									<h6 class="mb-4">&nbsp;</h6>
									<button type="button" data-target="#testMailModal" data-toggle="modal" class="btn btn--info"><?php echo app('translator')->get('Make Test Payment'); ?></button>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="oxapay">
								<div class="col-md-12">
									<h6 class="mb-2"><?php echo app('translator')->get('Oxapay API Configuration'); ?></h6>
								</div>
								<div class="form-group col-md-12">
									<label><?php echo app('translator')->get('Payout API KEY'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Oxapay Api key'); ?>" name="app_key" value="<?php echo e(config('settings')->payout_config->app_key ?? ''); ?>"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="flutterwave">
								<div class="col-md-12">
									<h6 class="mb-2"><?php echo app('translator')->get('Flutter-wave API Configuration'); ?></h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('Api Public Key'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Flutter-wave Api Public Key'); ?>" name="flu_public_key" value="<?php echo e(config('settings')->payout_config->flu_public_key ?? ''); ?>"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('Api Secret Key'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Flutter-wave Api Secret Key'); ?>" name="flu_secret_key" value="<?php echo e(config('settings')->payout_config->flu_secret_key ?? ''); ?>"/>
								</div>
								<div class="form-group col-md-12">
									<label class="font-weight-bold"><?php echo app('translator')->get('Encryption Key'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Provide Encryption Key'); ?>" name="flu_encryption_key" value="<?php echo e(config('settings')->payout_config->flu_encryption_key ?? ''); ?>"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="paystack">
								<div class="col-md-12">
									<h6 class="mb-2"><?php echo app('translator')->get('Paystack API Configuration'); ?></h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('Public Key'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Api Public Key'); ?>" name="py_public_key" value="<?php echo e(config('settings')->payout_config->py_public_key ?? ''); ?>"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('Secret Key'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Api Secret Key'); ?>" name="py_secret_key" value="<?php echo e(config('settings')->payout_config->py_secret_key ?? ''); ?>"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="gtrpay">
								<div class="col-md-12">
									<h6 class="mb-2"><?php echo app('translator')->get('GTRPay API Configuration'); ?></h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('Merchant ID'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Merchant ID'); ?>" name="merchant_id" value="<?php echo e(config('settings')->payout_config->merchant_id ?? ''); ?>"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('APP ID'); ?></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Application ID'); ?>" name="app_id" value="<?php echo e(config('settings')->payout_config->app_id ?? ''); ?>"/>
								</div>
								<div class="form-group col-md-12">
									<label class="font-weight-bold" style="width: 100%;"><?php echo app('translator')->get('Secret Key'); ?> </label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('App Secret Key'); ?>" name="merchant_key" value="<?php echo e(config('settings')->payout_config->merchant_key ?? ''); ?>"/>
								</div>
							</div>
							<div class="form-row mt-4 d-none configForm" id="nowpay">
								<div class="col-md-12">
									<h6 class="mb-2"><?php echo app('translator')->get('Nowpayment API Configuration'); ?></h6>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('API KEY'); ?> <span class="text-danger">*</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('API KEY'); ?>" name="now_api_key" value="<?php echo e(config('settings')->payout_config->now_api_key ?? ''); ?>"/>
								</div>
								<div class="form-group col-md-6">
									<label class="font-weight-bold"><?php echo app('translator')->get('Secret Key'); ?></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Secret Key'); ?>" name="now_secret_key" value="<?php echo e(config('settings')->payout_config->now_secret_key ?? ''); ?>"/>
								</div>
								<div class="form-group col-md-12">
									<label class="font-weight-bold" style="width: 100%;"><?php echo app('translator')->get('Domain Link'); ?> <span class="text-danger" style="float:right">e.g(support.<?php echo e(request()->getHttpHost()); ?>)</span></label>
									<input type="text" class="form-control" placeholder="<?php echo app('translator')->get('Domain name'); ?>" name="now_host" value="<?php echo e(config('settings')->payout_config->now_host ?? ''); ?>"/>
								</div>
							</div>
						</div>

						<div class="card-footer">
							<button type="submit" class="btn btn-block btn--primary mr-2"><?php echo app('translator')->get('Update'); ?></button>
						</div>
					</form>
				
                </div>
            </div><!-- card end -->
        </div>

        <div class="col-lg-12">
			<div class="card bl--5-primary mt-3">
				<form class="card-body" method="post" action="" style="padding: 0.35rem;">
					<?php echo csrf_field(); ?>
					<div style="float:right">
						<select name="payname" required>
							<option value="">Select option</option>
							<?php $__currentLoopData = $gCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option value="<?php echo e($data->alias); ?>" <?php echo e((config('settings')->auto_transfer_default == $data->alias) ? 'selected':''); ?> ><?php echo e($data->alias); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
						<button type="submit" class="icon-btn btn--success form-control-lg">GO</button>
					</div>
					<p style="margin-top: 6px;">Set autopay option</p>
				</form>
			</div>
		</div>
    </div>


    
    <div id="activateModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Withdrawal Method Activation Confirmation'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.withdraw.method.activate')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <p><?php echo app('translator')->get('Are you sure to activate'); ?> <span class="font-weight-bold method-name"></span> <?php echo app('translator')->get('method'); ?>?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn--primary"><?php echo app('translator')->get('Activate'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div id="deactivateModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Withdrawal Method Disable Confirmation'); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.withdraw.method.deactivate')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id">
                    <div class="modal-body">
                        <p><?php echo app('translator')->get('Are you sure to disable'); ?> <span class="font-weight-bold method-name"></span> <?php echo app('translator')->get('method'); ?>?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark" data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <button type="submit" class="btn btn--danger"><?php echo app('translator')->get('Disable'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>



<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a class="btn btn-sm btn--primary box--shadow1 text--small" href="<?php echo e(route('admin.withdraw.method.create')); ?>"><i class="fa fa-fw fa-plus"></i><?php echo app('translator')->get('Add New'); ?></a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";
            $('.activateBtn').on('click', function () {
                var modal = $('#activateModal');
                modal.find('.method-name').text($(this).data('name'));
                modal.find('input[name=id]').val($(this).data('id'));
                modal.modal('show');
            });

            $('.deactivateBtn').on('click', function () {
                var modal = $('#deactivateModal');
                modal.find('.method-name').text($(this).data('name'));
                modal.find('input[name=id]').val($(this).data('id'))
                modal.modal('show');
            });

            var method = '<?php echo e(config('settings')->payout_config->auto_pay); ?>';
            $('select[name=auto_pay]').on('change', function() {
                var method = $(this).val();
                emailMethod(method);
            });

            function emailMethod(method){
                $('.configForm').addClass('d-none');
                if(method != '0') {
                    $(`#${method}`).removeClass('d-none');
                }
            }
            emailMethod(method);
			
        })(jQuery);
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/metalixz/public_html/core/resources/views/admin/withdraw/index.blade.php ENDPATH**/ ?>