<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Oauth\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class OpenidDiscoveryContext extends InstanceContext {
    /**
     * Initialize the OpenidDiscoveryContext
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/.well-known/openid-configuration';
    }

    /**
     * Fetch the OpenidDiscoveryInstance
     *
     * @return OpenidDiscoveryInstance Fetched OpenidDiscoveryInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): OpenidDiscoveryInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new OpenidDiscoveryInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Oauth.V1.OpenidDiscoveryContext ' . \implode(' ', $context) . ']';
    }
}