function modalMessage(message, status = 200, callback = null) {
    let html = '<div id="alert-bar" class="alert-bar">';
    html += '<div id="alert-message" class="alert-message">';

    // Success
    if(status == 200) {
        html += '<iconify-icon icon="ooui:success" class="icon-green"></iconify-icon> ' + message;
    }else {
        // Error
        html += '<iconify-icon icon="ph:seal-warning-light" class="icon-red"></iconify-icon> ' + message;
    }

    html += '</div>';
    html += '<button id="close-alert" class="close-btn">&times;</button>';
    html += '</div>';

    // Create a container element
    let container = document.createElement('div');
    container.innerHTML = html;

    // Append the container to the body
    document.body.appendChild(container);

    // Callback
    if(callback) {
        window.location.href = callback;
    }

    document.getElementById('close-alert').addEventListener('click', function() {
        const alertBar = document.getElementById('alert-bar');
        alertBar.style.opacity = '0';
        setTimeout(() => {
            alertBar.style.display = 'none';
            alertBar.classList.add('hidden');
        }, 500);
    });
}

