var showPasswords = document.querySelectorAll("[data-role='show-password']");
var hidePasswords = document.querySelectorAll("[data-role='hide-password']");

showPasswords.forEach(showPassword => {
    showPassword.addEventListener('click', (e) => {
        changeInputType('text', e.target)
        e.target.classList.add('hidden')
        e.target.parentElement.querySelector("[data-role='hide-password']").classList.remove('hidden')
    }, false)
});

hidePasswords.forEach(hidePassword => {
    hidePassword.addEventListener('click', (e) => {
        changeInputType('password', e.target)

        e.target.classList.add('hidden')
        e.target.parentElement.querySelector("[data-role='show-password']").classList.remove('hidden')
    }, false)
});

function changeInputType(type, currentIconElement){
    //find parent
    let parent = currentIconElement.parentElement;
    let input  = parent.getElementsByTagName('input')[0]

    input.type = type
}

//copier
//the copied text should be in <p> tag
var copiers = document.querySelectorAll("[data-role='copier']");
Array.from(copiers).forEach(copier => 
    copier.addEventListener('click', ()=>{
        var target = copier.getAttribute('data-target')
        navigator.clipboard.writeText(document.getElementById(target).innerHTML)

        copier.innerHTML = "Copied!";
        setTimeout(function(){
            copier.innerHTML = "Copy"
        }, 1000)
    })
)