var forms = document.getElementsByClassName('validate-form');
var currentForm = null

//looop froms
Array.from(forms).forEach(form => {
    //get input containers
    let inputContainers = form.getElementsByClassName('input-group is-required');

    //loop through input to get the input
    Array.from(inputContainers).forEach(inputContainer => {
        let inputs = inputContainer.getElementsByTagName('input')

        Array.prototype.forEach.call(inputs, function(input, idx) {
            // do something
            input.addEventListener('blur', inputIsNotEmpty,false)
        });
    });
})

function inputIsNotEmpty(e){
    var input = e.target
    //currentForm = input.form

    let parentContainer = input.parentElement || input.parentNode
    activateSubmitButton(input.form)
    
    if(input.value == '' || input.value == 'undefined'){
        parentContainer.classList.add('has-error')
    }
    else{
        parentContainer.classList.remove('has-error')
    }
}

function activateSubmitButton(form){
    if (form == null) {
        return
    }

    //submit button
    let submitButton = form.querySelector('[role="submit"]')
    //console.log(submitButton)

    //get all inputs
    let inputContainers = form.getElementsByClassName('input-group is-required');

    // check if any input is empty, if any return from continuing checking
    console.log(_noInputIsEmpty(inputContainers))
    if (_noInputIsEmpty(inputContainers)) {
        submitButton.setAttribute('disabled', 'disabled')
    }
    else{
        submitButton.removeAttribute('disabled')
    }
}

function _noInputIsEmpty(inputContainers){
    Array.from(inputContainers).forEach(inputContainer => {
        let inputs = inputContainer.getElementsByTagName('input')

        Array.prototype.forEach.call(inputs, function(input, idx) {
            if (input.value === '') {
                console.log(input.value)
                return true
            }
        });
    });

    return true
}