function modalMessage(message, status = 200, callback = null) {
    let html = '<div id="alert-bar" class="alert-bar">';
    html += '<div id="alert-message" class="alert-message">';

    // Success
    if(status == 200) {
        html += '<iconify-icon icon="ooui:success" class="icon-green"></iconify-icon> ' + message;
    }else {
        // Error
        html += '<iconify-icon icon="ph:seal-warning-light" class="icon-red"></iconify-icon> ' + message;
    }

    html += '</div>';
    html += '<button id="close-alert" class="close-btn">&times;</button>';
    html += '</div>';

    // Create a container element
    let container = document.createElement('div');
    container.innerHTML = html;

    // Append the container to the body
    document.body.appendChild(container);

    // Callback
    if(callback) {
        window.location.href = callback;
    }

    document.getElementById('close-alert').addEventListener('click', function() {
        const alertBar = document.getElementById('alert-bar');
        alertBar.remove(); 
    });
}

(function ($) {
	"use strict";
	$('.linkBTN').on('click', function() {
		loading.showLoading({type: 5,tip: "loading.."});
		window.location.href = $(this).data('href');
	});

	$('.inkBTN').on('click', function() {
		mui.showLoading("Please wait...", "div");
		window.location.href = $(this).data('href');
	});

	$(".langSel").on("change", function() {
		window.location.href = "{{route('home')}}/change/"+$(this).val() ;
	});

    $('.g_close').click(function() {
		$("body").removeClass('van-overflow-hidden');
        $(".popView").hide();
    });

	$(document).on("submit", ".formPost", function(event) {
		var cSub = $("button[type=submit]",this);
		disableBTN(cSub,!0,"processing...");
		loading.showLoading({type: 4,tip: "Loading..."});
	});

	
})(jQuery);


window.onload = function() {
	let pass = document.querySelectorAll('.passwordIn');
	for (let i = 0; i < pass.length; i++) {
	  let passInput = pass[i].querySelector('input[type=password]');
	  let passToggle = pass[i].querySelector('.viewPass');
	  passToggle.addEventListener('click', (e) => {
		if (passInput.type === "password") {
		  passInput.type = "text";
		} else {
		  passInput.type = "password";
		} 
	  }, false);
	}
}
